package com.ejianc.business.income.controller;

import com.ejianc.business.income.service.IHistoryService;
import com.ejianc.business.income.vo.HistoryVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 施工合同记录表 前端控制器
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@RestController
@RequestMapping("/contract/history")
public class HistoryController {
    @Autowired
    private IHistoryService historyService;
    /**
     * 根据变更主键ID查询历史详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailByChangeId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<HistoryVo> queryDetailByChangeId(@RequestParam Long id) {
        HistoryVo historyVo = historyService.queryDetailByChangeId(id);
        return CommonResponse.success(historyVo);
    }
}
