package com.ejianc.business.sub.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.vo.SubChangeRecordVO;
import com.ejianc.business.sub.vo.SubChangeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 分包变更表 前端控制器
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@RestController
@RequestMapping("changeSub")
public class SubChangeController implements Serializable {

    @Autowired
    IChangeService changeService;

    @Autowired
    ICommonBusinessService change;


    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubChangeVO> test(Long id) {
        change.afterApprovalProcessor(id, null, null);
        return CommonResponse.success("查询详情数据成功！");
    }

    /**
     * @param changeVO
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增或者修改
     * @Return com.ejianc.framework.core.response.CommonResponse<ChangeVO>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubChangeVO> saveOrUpdate(@RequestBody SubChangeVO changeVO) {
        SubChangeVO vo = changeService.insertOrUpdate(changeVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param contractId
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description 新增变更根据合同主键查询转换变更
     * @Return com.ejianc.framework.core.response.CommonResponse<ChangeVO>
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubChangeVO> addConvertByConId(Long contractId) {
        SubChangeVO vo = changeService.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！", vo);
    }

    /**
     * @param id
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询详情
     * @Return com.ejianc.framework.core.response.CommonResponse<ChangeVO>
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubChangeRecordVO> queryDetailRecord(Long id) {
        SubChangeRecordVO vo = changeService.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param id
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询变更记录详情
     * @Return com.ejianc.framework.core.response.CommonResponse<ChangeVO>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubChangeVO> queryDetail(Long id) {
        SubChangeVO vo = changeService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param param
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubChangeVO>> queryList(@RequestBody QueryParam param) {
        return changeService.queryListVOs(param);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubChangeVO> vos) {
        return changeService.deleteByIds(vos);
    }

}
