/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageEntity;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageService;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageSupplierService;
import com.ejianc.business.bidprice.material.service.IPicketageQuotePurchaseDetailService;
import com.ejianc.business.bidprice.material.service.IPicketageQuoteRentDetailService;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialPicketage"})
@Api(value="\u6750\u6599\u5b9a\u6807", tags={"\u6750\u6599\u5b9a\u6807"})
public class MaterialPicketageController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPicketageQuoteRentDetailService rentDetailService;
    @Autowired
    private IPicketageQuotePurchaseDetailService purchaseDetailService;
    private static final String BILL_CODE = "ZYDX_MATERIAL_PICKETAGE";
    @Autowired
    private IMaterialPicketageService service;
    @Autowired
    private IMaterialPicketageSupplierService materialPicketageSupplierService;
    @Autowired
    private IMaterialInquiryService inquiryService;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialPicketageVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialPicketageVO saveOrUpdateVO) {
        MaterialPicketageEntity entity = (MaterialPicketageEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), MaterialPicketageEntity.class));
        if (entity.getBidWinMny() != null) {
            entity.setBidWinMnyStr(entity.getBidWinMny().toString());
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setContractSign(0);
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getSelfFlag() == null) {
            entity.setSelfFlag(1);
        }
        this.service.insertOrUpdate(entity);
        MaterialPicketageVO vo = (MaterialPicketageVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialPicketageVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialPicketageVO> queryDetail(@RequestParam Long id) {
        MaterialPicketageVO vo = this.service.queryMaterialPicketageDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @ApiOperation(value="\u53c2\u7167\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetailToRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryDetailToRef(@RequestParam Long id) {
        JSONObject vo = this.service.queryDetailToRef(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryByInquiryToDetailAndQuote"}, method={RequestMethod.GET})
    @ResponseBody
    CommonResponse<JSONObject> queryByInquiryToDetailAndQuote(@RequestParam(value="inquiryId") String inquiryId) {
        return this.service.queryByInquiryToDetailAndQuote(inquiryId);
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539\u53c2\u7167")
    @RequestMapping(value={"/saveOrUpdateRef"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> saveOrUpdateRef(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialPicketageVO saveOrUpdateVO) {
        MaterialPicketageEntity entity = (MaterialPicketageEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), MaterialPicketageEntity.class));
        if (entity.getBidWinMny() != null) {
            entity.setBidWinMnyStr(entity.getBidWinMny().toString());
        }
        this.service.checkRefSave(entity);
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setContractSign(0);
            if (entity.getInquiryId() != null) {
                this.inquiryService.updateInquiry(entity.getInquiryId(), InquiryStateEnum.WIN_STATE.getCode());
            }
        }
        if (entity.getSelfFlag() == null) {
            entity.setSelfFlag(1);
        }
        this.service.insertOrUpdateRef(entity);
        JSONObject vo = this.service.queryDetailToRef(entity.getId());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialPicketageVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            Collection materialPicketageEntities = this.service.listByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
            for (MaterialPicketageEntity vo : materialPicketageEntities) {
                if (vo.getSelfFlag() != 1) {
                    this.inquiryService.updateInquiry(vo.getInquiryId(), InquiryStateEnum.EXPIRATION_STATE.getCode());
                }
                QueryWrapper purchaseWrapper = new QueryWrapper();
                purchaseWrapper.eq((Object)"picketage_id", (Object)vo.getId());
                this.purchaseDetailService.remove((Wrapper)purchaseWrapper);
                QueryWrapper rentWrapper = new QueryWrapper();
                rentWrapper.eq((Object)"picketage_id", (Object)vo.getId());
                this.rentDetailService.remove((Wrapper)rentWrapper);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialPicketageVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("bidWinnerName");
        Map params = param.getParams();
        if (params.containsKey("contractSign")) {
            Integer contractSign = Integer.parseInt(((Parameter)params.get("contractSign")).getValue().toString());
            params.remove("contractSign");
            if (contractSign == 1) {
                param.getParams().put("contractSign", new Parameter("gt", (Object)0));
            } else {
                param.getParams().put("contractSign", new Parameter("eq", (Object)0));
            }
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialPicketageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("bidWinnerName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Map params = param.getParams();
        if (params.containsKey("contractSign")) {
            Integer contractSign = Integer.parseInt(((Parameter)params.get("contractSign")).getValue().toString());
            params.remove("contractSign");
            if (contractSign == 1) {
                param.getParams().put("contractSign", new Parameter("gt", (Object)0));
            } else {
                param.getParams().put("contractSign", new Parameter("eq", (Object)0));
            }
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List vos = BeanMapper.mapList((Iterable)list, MaterialPicketageVO.class);
        if (CollectionUtils.isNotEmpty((Collection)vos)) {
            for (MaterialPicketageVO vo : vos) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setPurchaseTypeName(vo.getPurchaseType() == 1 ? "\u9879\u76ee\u81ea\u91c7" : "\u516c\u53f8\u96c6\u91c7");
                vo.setPricingTypeName(vo.getPricingType() == 1 ? "\u91c7\u8d2d" : "\u79df\u8d41");
                if (!ObjectUtil.isNotEmpty((Object)vo.getContractSign())) continue;
                vo.setContractSignStr(vo.getContractSign() > 0 ? vo.getContractSign() + "" : "\u672a\u7b7e\u8ba2");
            }
        }
        beans.put("records", vos);
        ExcelExport.getInstance().export("MaterialPicketage-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refMaterialPicketageData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialPicketageVO>> refMaterialPicketageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialPicketageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/handlePrintDetail"})
    @ResponseBody
    public CommonResponse<JSONObject> handlePrintDetail(@RequestBody String detailJsonStr) {
        return this.service.handlePrintDetail(detailJsonStr);
    }
}

