/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.InstallDetailEntity;
import com.ejianc.business.material.bean.InstallEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.service.IInstallDetailService;
import com.ejianc.business.material.service.IInstallService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.vo.InstallVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"install"})
public class InstallController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZYDX_AZYS";
    @Autowired
    private IInstallService service;
    @Autowired
    private IInstallDetailService detailService;
    @Autowired
    private IOutStoreService outStoreService;
    @Autowired
    private IOutStoreSubService outStoreSubService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InstallVO> saveOrUpdate(@RequestBody InstallVO saveOrUpdateVO) {
        List<InstallDetailEntity> detailList;
        InstallEntity entity = (InstallEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), InstallEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(detailList = entity.getInstallDetailList())) {
            HashSet<Long> useIdSubs = new HashSet<Long>();
            HashSet<Long> freeSubIds = new HashSet<Long>();
            HashSet<Long> useIds = new HashSet<Long>();
            HashSet<Long> freeIds = new HashSet<Long>();
            HashMap<Long, Set> sourceSubMap = new HashMap<Long, Set>();
            for (InstallDetailEntity detail : detailList) {
                Long sourceId = detail.getSourceMainId();
                Long sourceSubId = detail.getSourceSubId();
                if ("del".equals(detail.getRowState())) {
                    freeIds.add(sourceId);
                    freeSubIds.add(sourceSubId);
                    continue;
                }
                useIdSubs.add(sourceSubId);
                useIds.add(sourceId);
                if (CollectionUtils.isNotEmpty((Collection)((Collection)sourceSubMap.get(sourceId)))) {
                    Set sourceSubIds = (Set)sourceSubMap.get(sourceId);
                    sourceSubIds.add(sourceSubId);
                    sourceSubMap.put(sourceId, sourceSubIds);
                    continue;
                }
                HashSet<Long> sourceSubIdSet = new HashSet<Long>();
                sourceSubIdSet.add(sourceSubId);
                sourceSubMap.put(sourceId, sourceSubIdSet);
            }
            freeIds.removeAll(useIds);
            freeSubIds.removeAll(useIdSubs);
            if (CollectionUtils.isNotEmpty(useIds)) {
                StringBuffer msg = new StringBuffer("");
                useIds.forEach(s -> {
                    OutStoreEntity outStoreEntity = (OutStoreEntity)((Object)((Object)this.outStoreService.selectById((Serializable)s)));
                    if (outStoreEntity != null) {
                        LambdaUpdateWrapper uw;
                        List<OutStoreSubEntity> outStoreSubEntities = outStoreEntity.getOutStoreSubEntities();
                        List collect2 = outStoreSubEntities.stream().filter(e -> null == e.getInstallFlag() || 0 == e.getInstallFlag()).collect(Collectors.toList());
                        if (((Set)sourceSubMap.get(s)).size() == collect2.size()) {
                            uw = new LambdaUpdateWrapper();
                            uw.eq(BaseEntity::getId, s);
                            uw.set(OutStoreEntity::getInstallFlag, (Object)1);
                            this.outStoreService.update((Wrapper)uw);
                        }
                        uw = new LambdaUpdateWrapper();
                        uw.in(BaseEntity::getId, (Collection)sourceSubMap.get(s));
                        uw.set(OutStoreSubEntity::getInstallFlag, (Object)1);
                        this.outStoreSubService.update((Wrapper)uw);
                    } else {
                        msg.append("1");
                    }
                });
                if (msg.length() > 0) {
                    return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u51fa\u5e93\u5355\u4fe1\u606f\uff01");
                }
            }
            if (CollectionUtils.isNotEmpty(freeIds)) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, freeIds);
                updateWrapper.set(OutStoreEntity::getInstallFlag, (Object)0);
                this.outStoreService.update((Wrapper)updateWrapper);
                LambdaUpdateWrapper updateWrapperMain = new LambdaUpdateWrapper();
                updateWrapperMain.in(BaseEntity::getId, freeSubIds);
                updateWrapperMain.set(OutStoreSubEntity::getInstallFlag, (Object)0);
                this.outStoreSubService.update((Wrapper)updateWrapperMain);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        InstallVO vo = (InstallVO)((Object)BeanMapper.map((Object)((Object)entity), InstallVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InstallVO> queryDetail(Long id) {
        InstallEntity entity = (InstallEntity)((Object)this.service.selectById(id));
        InstallVO vo = (InstallVO)((Object)BeanMapper.map((Object)((Object)entity), InstallVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InstallVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(InstallDetailEntity::getPid, ids);
            queryWrapper.eq(BaseEntity::getDr, (Object)0);
            List detailList = this.detailService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                HashSet<Long> freeIds = new HashSet<Long>();
                HashSet<Long> freeSubIds = new HashSet<Long>();
                for (InstallDetailEntity detail : detailList) {
                    Long sourceMainId = detail.getSourceMainId();
                    Long sourceSubId = detail.getSourceSubId();
                    freeIds.add(sourceMainId);
                    freeSubIds.add(sourceSubId);
                }
                if (CollectionUtils.isNotEmpty(freeIds)) {
                    LambdaUpdateWrapper uw = new LambdaUpdateWrapper();
                    uw.in(BaseEntity::getId, freeIds);
                    uw.set(OutStoreEntity::getInstallFlag, (Object)0);
                    this.outStoreService.update((Wrapper)uw);
                    LambdaUpdateWrapper uwSub = new LambdaUpdateWrapper();
                    uwSub.in(BaseEntity::getId, freeSubIds);
                    uwSub.set(OutStoreSubEntity::getInstallFlag, (Object)0);
                    this.outStoreSubService.update((Wrapper)uwSub);
                }
            }
            this.service.removeByIds(ids, true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InstallVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "pubUnitName", "contractorUnitName", "outStoreName", "employeeName", "", ""));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InstallVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "pubUnitName", "contractorUnitName", "outStoreName", "employeeName", "", ""));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Install-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInstallData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InstallVO>> refInstallData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InstallVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

