package com.ejianc.business.sub.vo;

import com.ejianc.business.sub.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author zhangwx
 * @Date 2020/5/27 分包合同明细
 * @Description ContractDetailVO
 */

public class SubContractDetailVO extends BaseVO implements ITreeNodeB{

    private static final long serialVersionUID = 2779265683222435571L;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 序号
     */
    private String treeIndex;

    /**
     * 清单编码
     */
    private String code;

    /**
     * 清单名称
     */
    private String name;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 工程量
     */
    private BigDecimal num;

    /**
     * 综合单价
     */
    private BigDecimal price;

    /**
     * 合价
     */
    private BigDecimal money;

    /**
     * 备注
     */
    private String memo;

    /**
     * 父ID
     */
    private Long parentId;

    /**
     * 是否末级
     */
    private Boolean leafFlag;

    /**
     * 变更主键
     */
    private Long changeId;

    /**
     * 变更子表主键
     */
    private Long srcBid;

    /**
     * 变更类型
     */
    private Integer changeType;

    /**
     * 项目预算ID
     */
    private Long budgetId;

    /**
     * 预算明细ID
     */
    private Long budgetDetailId;

    /**
     * 来源类型(1:新增，2:导入，3:专业预算，4:项目预算)
     */
    private Integer sourceType;

    private String tid;
    private String tpid;
    //错误类型
    private String warnType;
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    // 是否是父级错误
    private Boolean parentWarn;

    private String shadowId;
    private List<ITreeNodeB> children;

    private BigDecimal sumSettleNum; // 累计结算工程量 (不含本期)
    private BigDecimal sumSettleNumEndthis; // 累计结算工程量 (含本期)
    private String spec;//特征

    private Long supplierId;
    private String supplierName;
    private BigDecimal projectTaskPrice;


    public BigDecimal getProjectTaskPrice() {
        return projectTaskPrice;
    }

    public void setProjectTaskPrice(BigDecimal projectTaskPrice) {
        this.projectTaskPrice = projectTaskPrice;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public BigDecimal getSumSettleNumEndthis() {
        return sumSettleNumEndthis;
    }

    public void setSumSettleNumEndthis(BigDecimal sumSettleNumEndthis) {
        this.sumSettleNumEndthis = sumSettleNumEndthis;
    }

    public BigDecimal getSumSettleNum() {
        return sumSettleNum;
    }

    public void setSumSettleNum(BigDecimal sumSettleNum) {
        this.sumSettleNum = sumSettleNum;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public Boolean getParentWarn() {
        return parentWarn;
    }

    public void setParentWarn(Boolean parentWarn) {
        this.parentWarn = parentWarn;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getSrcBid() {
        return srcBid;
    }

    public void setSrcBid(Long srcBid) {
        this.srcBid = srcBid;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getBudgetId() {
        return budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public Long getBudgetDetailId() {
        return budgetDetailId;
    }

    public void setBudgetDetailId(Long budgetDetailId) {
        this.budgetDetailId = budgetDetailId;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    public List<ITreeNodeB> getChildren() {
//        if (children == null) {
//            children = new ArrayList<>();
//        }
        return children;

    }
}
