package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 固定资产摊销-子实体
 * 
 * @author generator
 * 
 */
public class AssetAmortizeDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long assetAmortizeId; // 主表id
    private BigDecimal detailMny; // 本次摊销金额
    private BigDecimal totalDetailMny; // 累计摊销金额
    private Long subjectId; // 成本科目主键
    private String subjectName; // 成本科目名称
    private String detailMemo; // 备注
    

    public Long getAssetAmortizeId() {
        return assetAmortizeId;
    }

    public void setAssetAmortizeId(Long assetAmortizeId) {
        this.assetAmortizeId = assetAmortizeId;
    }
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    public BigDecimal getTotalDetailMny() {
        return totalDetailMny;
    }

    public void setTotalDetailMny(BigDecimal totalDetailMny) {
        this.totalDetailMny = totalDetailMny;
    }
    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }

    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    
}
