package com.ejianc.business.labprice.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 劳务询价-报价详情
 * 
 * @author generator
 * 
 */
public class LaborQuoteDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long quoteId; // 报价单id
    private Long inquiryId; // 询价单id
    private Long sourceId; // 来源清单id
    private String detailCode; // 编码
    private String detailName; // 名称
    private String spec; // 规格型号
    private String unit; // 计量单位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planUseDate; // 计划使用日期
    private BigDecimal num; // 数量
    private BigDecimal referPrice; // 参考价
    private BigDecimal purchaseQuotePrice; // 报价
    private BigDecimal purchaseQuotePriceNoTax; // 报价(无税)
    private BigDecimal purchaseInquiryMny; // 金额（询价单）
    private BigDecimal purchaseMny; // 金额
    private BigDecimal purchaseMnyNoTax; // 金额(无税)
    private BigDecimal purchaseRate; // 报价税率
    private String purchaseInquiryMemo; // 备注（询价单）
    private String purchaseMemo; // 备注
    //供应商名称 冗余主表便于前端显示
    private String supplierName;

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getQuoteId() {
        return quoteId;
    }

    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }
    public Long getInquiryId() {
        return inquiryId;
    }

    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }
    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public Date getPlanUseDate() {
        return planUseDate;
    }

    public void setPlanUseDate(Date planUseDate) {
        this.planUseDate = planUseDate;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getReferPrice() {
        return referPrice;
    }

    public void setReferPrice(BigDecimal referPrice) {
        this.referPrice = referPrice;
    }
    public BigDecimal getPurchaseQuotePrice() {
        return purchaseQuotePrice;
    }

    public void setPurchaseQuotePrice(BigDecimal purchaseQuotePrice) {
        this.purchaseQuotePrice = purchaseQuotePrice;
    }
    public BigDecimal getPurchaseQuotePriceNoTax() {
        return purchaseQuotePriceNoTax;
    }

    public void setPurchaseQuotePriceNoTax(BigDecimal purchaseQuotePriceNoTax) {
        this.purchaseQuotePriceNoTax = purchaseQuotePriceNoTax;
    }
    public BigDecimal getPurchaseInquiryMny() {
        return purchaseInquiryMny;
    }

    public void setPurchaseInquiryMny(BigDecimal purchaseInquiryMny) {
        this.purchaseInquiryMny = purchaseInquiryMny;
    }
    public BigDecimal getPurchaseMny() {
        return purchaseMny;
    }

    public void setPurchaseMny(BigDecimal purchaseMny) {
        this.purchaseMny = purchaseMny;
    }
    public BigDecimal getPurchaseMnyNoTax() {
        return purchaseMnyNoTax;
    }

    public void setPurchaseMnyNoTax(BigDecimal purchaseMnyNoTax) {
        this.purchaseMnyNoTax = purchaseMnyNoTax;
    }
    public BigDecimal getPurchaseRate() {
        return purchaseRate;
    }

    public void setPurchaseRate(BigDecimal purchaseRate) {
        this.purchaseRate = purchaseRate;
    }
    public String getPurchaseInquiryMemo() {
        return purchaseInquiryMemo;
    }

    public void setPurchaseInquiryMemo(String purchaseInquiryMemo) {
        this.purchaseInquiryMemo = purchaseInquiryMemo;
    }
    public String getPurchaseMemo() {
        return purchaseMemo;
    }

    public void setPurchaseMemo(String purchaseMemo) {
        this.purchaseMemo = purchaseMemo;
    }
    
}
