/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.ProjectImplProtocolDetailEntity;
import com.ejianc.business.cost.bean.ProjectImplProtocolEntity;
import com.ejianc.business.cost.bean.ProjectTaskBookDetailEntity;
import com.ejianc.business.cost.bean.ProjectTaskBookEntity;
import com.ejianc.business.cost.service.IProjectImplProtocolService;
import com.ejianc.business.cost.service.IProjectTaskBookService;
import com.ejianc.business.cost.vo.ProjectTaskBookVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectImplProtocol")
public class ProjectImplProtocolBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectImplProtocolService projectImplProtocolService;
    @Autowired
    private IProjectTaskBookService projectTaskBookService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "zydxProjectTaskBook";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ProjectImplProtocolEntity entity = (ProjectImplProtocolEntity)((Object)this.projectImplProtocolService.selectById(billId));
        List<ProjectImplProtocolDetailEntity> detailList = entity.getProjectImplProtocolDetailList();
        ProjectTaskBookEntity en = (ProjectTaskBookEntity)((Object)BeanMapper.map((Object)((Object)entity), ProjectTaskBookEntity.class));
        en.setBillCode(null);
        en.setId(IdWorker.getId());
        en.setBillState(0);
        en.setCreateTime(null);
        en.setCreateUserCode(null);
        en.setUpdateTime(null);
        en.setUpdateUserCode(null);
        en.setVersion(null);
        en.setPrjimplProtocolId(billId);
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)en), ProjectTaskBookVO.class)));
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        en.setBillCode((String)billCode.getData());
        ArrayList<ProjectTaskBookDetailEntity> projectTaskBookDetailList = new ArrayList<ProjectTaskBookDetailEntity>();
        BigDecimal prjtaskcostTotal = new BigDecimal(0);
        if (detailList != null && detailList.size() > 0) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (ProjectImplProtocolDetailEntity item2 : detailList) {
                ProjectTaskBookDetailEntity e = (ProjectTaskBookDetailEntity)((Object)BeanMapper.map((Object)((Object)item2), ProjectTaskBookDetailEntity.class));
                if (item2.getPid() == null && item2.getInnerAmount() != null) {
                    prjtaskcostTotal = prjtaskcostTotal.add(item2.getInnerAmount());
                }
                e.setPrjimplProtocolDetailId(item2.getId());
                e.setId(IdWorker.getId());
                e.setCreateTime(null);
                e.setCreateUserCode(null);
                e.setUpdateTime(null);
                e.setUpdateUserCode(null);
                e.setVersion(null);
                e.setRowState("add");
                e.setId(IdWorker.getId());
                map.put(e.getCode(), e.getId());
                projectTaskBookDetailList.add(e);
            }
            en.setPrjtaskcostTotal(prjtaskcostTotal);
            projectTaskBookDetailList.forEach(item -> {
                if (item.getCode().indexOf(".") != -1) {
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid((Long)map.get(code));
                }
            });
            en.setProjectTaskBookDetailList(projectTaskBookDetailList);
        }
        this.projectTaskBookService.saveOrUpdate((Object)en, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff01" + resp.getMsg()));
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"prjimpl_protocol_id", (Object)billId);
        List list = this.projectTaskBookService.list((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            for (ProjectTaskBookEntity en : list) {
                if (en.getBillState() == 0 || en.getBillState() == 4) continue;
                return CommonResponse.error((String)"\u751f\u6210\u7684\u9879\u76ee\u4efb\u52a1\u4e66\u5355\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u652f\u6301\u64a4\u56de");
            }
            this.projectTaskBookService.remove((Wrapper)wrapper);
        }
        return CommonResponse.success();
    }
}

