/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.bean.ChangeClauseEntity;
import com.ejianc.business.income.bean.ChangeDetailEntity;
import com.ejianc.business.income.bean.ChangeEntity;
import com.ejianc.business.income.bean.ContractDetailEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.history.ChangeHistoryVo;
import com.ejianc.business.income.mapper.ChangeMapper;
import com.ejianc.business.income.mapper.ContractMapper;
import com.ejianc.business.income.service.IChangeClauseService;
import com.ejianc.business.income.service.IChangeDetailService;
import com.ejianc.business.income.service.IChangeService;
import com.ejianc.business.income.service.IContractClauseService;
import com.ejianc.business.income.service.IContractDetailService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.ChangeClauseVo;
import com.ejianc.business.income.vo.ChangeDetailVo;
import com.ejianc.business.income.vo.ChangeVo;
import com.ejianc.business.income.vo.ContractClauseVo;
import com.ejianc.business.income.vo.ContractDetailVo;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.income.vo.comparator.ContractDetailComparatorVo;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ChangeService")
public class ChangeServiceImpl
extends BaseServiceImpl<ChangeMapper, ChangeEntity>
implements IChangeService {
    private static final String CHANGE_BILL_CODE = "INCOME_CHANGE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IChangeDetailService changeDetailService;
    @Autowired
    private IChangeClauseService changeClauseService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ChangeMapper changeMapper;
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private IContractDetailService detailsService;
    @Autowired
    private IContractClauseService clauseService;

    @Override
    public CommonResponse<ChangeVo> saveOrUpdate(ChangeVo changeVo) {
        ChangeDetailEntity detailslist;
        List entities;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        ChangeEntity entity = null;
        String operateType = null;
        if (StringUtils.isBlank((CharSequence)changeVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(CHANGE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                changeVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (changeVo.getId() != null && changeVo.getId() > 0L && null != this.changeService.getById(changeVo.getId())) {
            entity = (ChangeEntity)((Object)BeanMapper.map((Object)((Object)changeVo), ChangeEntity.class));
            operateType = "edit";
        } else {
            if (null == changeVo.getChangeVersion() || changeVo.getChangeVersion() == 0) {
                changeVo.setChangeVersion(1);
            } else {
                changeVo.setChangeVersion(changeVo.getChangeVersion() + 1);
            }
            if (2 == changeVo.getChangeStatus()) {
                throw new BusinessException("\u5408\u540c\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            entity = (ChangeEntity)((Object)BeanMapper.map((Object)((Object)changeVo), ChangeEntity.class));
            operateType = "add";
        }
        if (changeVo.getId() != null && changeVo.getId() > 0L && this.changeService.getById(changeVo.getId()) != null) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ChangeEntity::getBillCode, (Object)changeVo.getBillCode());
            lambda.eq(BaseEntity::getDr, (Object)0);
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)changeVo.getId());
            lambda.ne(ChangeEntity::getContractId, (Object)changeVo.getContractId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BaseEntity::getDr, (Object)0);
            lambda.eq(ChangeEntity::getBillCode, (Object)changeVo.getBillCode());
            lambda.ne(ChangeEntity::getContractId, (Object)changeVo.getContractId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("bill_code", new Parameter("eq", (Object)changeVo.getBillCode()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)changeVo.getContractId()));
        List entitiesc = this.contractService.queryList(queryParam, false);
        if (entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        super.saveOrUpdate((Object)entity);
        List<ChangeDetailVo> detailsVos = changeVo.getCheckList();
        ArrayList<ChangeDetailEntity> saveOrUpldates = new ArrayList<ChangeDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        if (operateType.equals("add")) {
            for (ChangeDetailVo changeDetailVo : detailsVos) {
                detailslist = (ChangeDetailEntity)((Object)BeanMapper.map((Object)changeDetailVo, ChangeDetailEntity.class));
                detailslist.setChangeId(entity.getId());
                detailslist.setContractId(entity.getContractId());
                detailslist.setContractDetailId(changeDetailVo.getId());
                detailslist.setId(null);
                detailslist.setBeforeChangeMny(changeDetailVo.getMny());
                detailslist.setBeforeChangePrice(changeDetailVo.getPrice());
                detailslist.setBeforeChangeNum(changeDetailVo.getNum());
                saveOrUpldates.add(detailslist);
            }
        } else {
            for (ChangeDetailVo changeDetailVo : detailsVos) {
                if ("add".equals(changeDetailVo.getRowState())) {
                    detailslist = (ChangeDetailEntity)((Object)BeanMapper.map((Object)changeDetailVo, ChangeDetailEntity.class));
                    detailslist.setChangeId(entity.getId());
                    detailslist.setContractId(entity.getContractId());
                    detailslist.setContractDetailId(changeDetailVo.getId());
                    detailslist.setId(null);
                    saveOrUpldates.add(detailslist);
                    continue;
                }
                if ("edit".equals(changeDetailVo.getRowState())) {
                    detailslist = (ChangeDetailEntity)((Object)BeanMapper.map((Object)changeDetailVo, ChangeDetailEntity.class));
                    saveOrUpldates.add(detailslist);
                    continue;
                }
                if (!"del".equals(changeDetailVo.getRowState())) continue;
                deleteIds.add(changeDetailVo.getId());
            }
        }
        if (saveOrUpldates.size() > 0) {
            this.changeDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ChangeDetailEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ChangeDetailEntity cdEntity : saveOrUpldates) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.changeDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.changeDetailService.removeByIds(deleteIds, false);
        }
        List<ChangeClauseVo> clauseVos = changeVo.getClauseList();
        ArrayList<ChangeClauseEntity> arrayList = new ArrayList<ChangeClauseEntity>();
        ArrayList<Long> deleteClauseIds = new ArrayList<Long>();
        for (ChangeClauseVo clauseVo : clauseVos) {
            if ("add".equals(clauseVo.getRowState())) {
                ChangeClauseEntity detailslist2 = (ChangeClauseEntity)((Object)BeanMapper.map((Object)((Object)clauseVo), ChangeClauseEntity.class));
                detailslist2.setChangeId(entity.getId());
                detailslist2.setContractId(entity.getContractId());
                detailslist2.setId(null);
                arrayList.add(detailslist2);
                continue;
            }
            if ("edit".equals(clauseVo.getRowState())) {
                ChangeClauseEntity detailslist2 = (ChangeClauseEntity)((Object)BeanMapper.map((Object)((Object)clauseVo), ChangeClauseEntity.class));
                arrayList.add(detailslist2);
                continue;
            }
            if (!"del".equals(clauseVo.getRowState())) continue;
            deleteClauseIds.add(clauseVo.getId());
        }
        if (arrayList.size() > 0) {
            this.changeClauseService.saveOrUpdateBatch(arrayList, arrayList.size(), false);
        }
        if (deleteClauseIds.size() > 0) {
            this.changeClauseService.removeByIds(deleteClauseIds, false);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getChangingTaxMny, (Object)changeVo.getContractTaxMny());
        updateWrapper.set(ContractEntity::getChangingMny, (Object)changeVo.getContractMny());
        updateWrapper.set(ContractEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(ContractEntity::getChangeStatus, (Object)2);
        updateWrapper.set(ContractEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getContractId());
        this.contractService.update((Wrapper)updateWrapper);
        return CommonResponse.success((Object)((Object)this.queryDetail(entity.getId())));
    }

    @Override
    public ChangeVo queryDetail(Long id) {
        ChangeEntity entity = (ChangeEntity)((Object)super.selectById((Serializable)id));
        ChangeVo changeVo = (ChangeVo)((Object)BeanMapper.map((Object)((Object)entity), ChangeVo.class));
        List<ChangeDetailVo> checkList = changeVo.getCheckList();
        if (checkList != null && checkList.size() > 0) {
            for (ChangeDetailVo cdEntity : checkList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            changeVo.setCheckList(TreeNodeBUtil.buildTree(checkList));
        }
        return changeVo;
    }

    @Override
    public void deleteChange(List<ChangeVo> vos) {
        for (ChangeVo vo : vos) {
            ChangeEntity changeEntity = (ChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(ContractEntity::getChangingTaxMny, (Object)BigDecimal.ZERO);
            updateWrapper.set(ContractEntity::getChangingMny, (Object)BigDecimal.ZERO);
            if (changeEntity.getChangeVersion() == 1) {
                updateWrapper.set(ContractEntity::getChangeStatus, (Object)1);
            } else {
                updateWrapper.set(ContractEntity::getChangeStatus, (Object)3);
            }
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            this.contractService.update((Wrapper)updateWrapper);
            super.removeById((Serializable)((Object)vo), false);
        }
    }

    @Override
    public ChangeHistoryVo queryChangeHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List changeEntities = this.changeMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object)"used_time"));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        ChangeHistoryVo vo = new ChangeHistoryVo();
        vo.setContractId(id);
        vo.setContractStatus(contractEntity.getContractStatus());
        vo.setChangeStatus(contractEntity.getChangeStatus());
        vo.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        vo.setBaseTaxMoney(contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney());
        BigDecimal changeMny = vo.getContractTaxMny().subtract(vo.getBaseTaxMoney());
        vo.setSumChangeMny(changeMny);
        BigDecimal sumChangeRate = BigDecimal.ZERO;
        if (vo.getBaseTaxMoney().compareTo(BigDecimal.ZERO) != 0) {
            sumChangeRate = changeMny.divide(vo.getBaseTaxMoney(), 8, 4).multiply(new BigDecimal(100));
        }
        vo.setSumScale(sumChangeRate);
        if (null != changeEntities && changeEntities.size() > 0) {
            List changeVos = BeanMapper.mapList((Iterable)changeEntities, ChangeVo.class);
            for (ChangeVo cvo : changeVos) {
                String changeTime = new SimpleDateFormat("yyyyMMdd").format(cvo.getChangeTime());
                String historyBillCode = cvo.getBeforeContractName() + "-" + changeTime + "-" + cvo.getChangeVersion();
                cvo.setHistoryBillCode(historyBillCode);
                BigDecimal subtract = cvo.getContractTaxMny().subtract(cvo.getBeforeChangeTaxMny());
                BigDecimal changeRate = BigDecimal.ZERO;
                if (cvo.getBeforeChangeTaxMny().compareTo(BigDecimal.ZERO) != 0) {
                    changeRate = subtract.divide(cvo.getBeforeChangeTaxMny(), 8, 4).multiply(new BigDecimal(100));
                }
                cvo.setScale(changeRate);
                cvo.setbChangeMny(subtract);
            }
            vo.setChangeRecord(changeVos);
        }
        return vo;
    }

    @Override
    public ContractVo queryDetailChange(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.contractMapper.selectById(id));
        if (entity != null) {
            ContractVo contractVo = (ContractVo)((Object)BeanMapper.map((Object)((Object)entity), ContractVo.class));
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractVo.getId()));
            queryParam.getParams().put("change_type", new Parameter("ne", (Object)5));
            List purchaseDetailss = this.detailsService.queryList(queryParam, false);
            if (purchaseDetailss != null && purchaseDetailss.size() > 0) {
                for (ContractDetailEntity cdEntity : purchaseDetailss) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)purchaseDetailss, ContractDetailVo.class);
                Collections.sort(resultMapList, new ContractDetailComparatorVo());
                contractVo.setCheckList(TreeNodeBUtil.buildTree(resultMapList));
            }
            QueryParam query = new QueryParam();
            query.getParams().put("contractId", new Parameter("eq", (Object)contractVo.getId()));
            query.getOrderMap().put("createTime", "desc");
            List clauses = this.clauseService.queryList(query, false);
            if (clauses != null && clauses.size() > 0) {
                List clauseVoList = BeanMapper.mapList((Iterable)clauses, ContractClauseVo.class);
                for (ContractClauseVo ccv : clauseVoList) {
                    ccv.setRowState("add");
                }
                contractVo.setClauseList(clauseVoList);
            }
            contractVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
            contractVo.setBillState(null);
            contractVo.setCreateUserCode(null);
            contractVo.setCreateTime(null);
            contractVo.setUpdateUserCode(null);
            contractVo.setUpdateTime(null);
            contractVo.setChangeReason(null);
            contractVo.setId(IdWorker.getId());
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "BT200528000000002", "incomeContractBill", String.valueOf(contractVo.getId()), "BT200605000000002", "incomeContractBill");
            return contractVo;
        }
        return null;
    }
}

