package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ContractFinishSettleEntity;
import com.ejianc.business.income.mapper.ContractFinishSettleMapper;
import com.ejianc.business.income.service.IContractFinishSettleService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.vo.ContractFinishSettleVO;
import com.ejianc.business.income.vo.FinishHistoryVo;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 竣工结算实体
 * 
 * @author generator
 * 
 */
@Service("contractFinishSettleService")
public class ContractFinishSettleServiceImpl extends BaseServiceImpl<ContractFinishSettleMapper, ContractFinishSettleEntity> implements IContractFinishSettleService{
    @Autowired
    private ContractFinishSettleMapper contractFinishSettleMapper;
    @Autowired
    private IContractService contractService;
    @Override
    public ContractFinishSettleVO queryByContractId(Long contractId) {
        ContractFinishSettleVO resp = null;
        QueryWrapper<ContractFinishSettleEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        ContractFinishSettleEntity entity = contractFinishSettleMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, ContractFinishSettleVO.class);
        }
        return resp;
    }

    @Override
    public FinishHistoryVo queryFinishHistory(Long id) {
        QueryWrapper<ContractFinishSettleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", id);
        queryWrapper.orderByDesc( "create_time");
        List<ContractFinishSettleEntity> finishSettleEntities = contractFinishSettleMapper.selectList(queryWrapper);
        ContractEntity contractEntity = contractService.selectById(id);
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        FinishHistoryVo vo = new FinishHistoryVo();
        vo.setContractId(id);
        vo.setChangeStatus(contractEntity.getChangeStatus());
        vo.setContractStatus(contractEntity.getContractStatus());
        vo.setContractTaxMny(contractTaxMny);
        BigDecimal endSettleMny = finishSettleEntities.stream().filter(item -> item.getEndSettleMny() != null).map(ContractFinishSettleEntity::getEndSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setEndSettleMny(endSettleMny);
        vo.setFinishSettleVOList(BeanMapper.mapList(finishSettleEntities, ContractFinishSettleVO.class));
        return vo;
    }
}
