package com.ejianc.business.sync.vo;

import com.ejianc.business.cost.vo.PreBidCostCalcDetailVO;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目同步数据
 * 
 * @author generator
 * 
 */
public class SyncProjectVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String projectId; // OA项目唯一键
    private String projectCode; // 项目名称
    private String projectOrgId; // 项目所属组织ID
    private String projectOrgName; // 项目所属组织名称
    private String projectType; // 项目类型（公开招投标、询比价、竞争性谈判、直接委托、单一来源采购、竞争性磋商）
    private String projectSource; // 项目来源（官网、搜索引擎推广、人脉介绍、合作伙伴、展会活动、线索、个人开发、总局推荐、领导交办）
    private String internalCooperationProject; // 是否内部合作项目（是、否）
    private String firstBusiness; // 一级业务
    private String secondBusiness; // 二级业务
    private String projectOverview; // 项目简介
    private String projectAddress; // 项目所在地
    private String projectContractCode; // 经营合同编码
    private String projectContractName; // 经营合同名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private BigDecimal contractMny;//合同额

    /************客户****************/
    private String customerId; // 客户档案id
    private String customerCode; // 客户编码
    private String customerName; // 客户名称
    private String socialCreditCode; // 社会信用代码
    private String taxType; // 纳税人类型（1：一般纳税人，2：小规模纳税人，3：其他）
    private String customerType; // 客户类型（党政机关/事业单位/中央企业/民营企业/地方国有企业/境外企业/外资企业/个人/其他/军队）
    private String customerAddress; // 客户地址
    private String bankAccount; // 账户名
    private String bankCode; // 银行账号
    private String bankName; // 开户行名称
    private String linker; // 联系人姓名
    private String cellphone; // 联系人联系方式
    /************客户****************/

    private Integer state; // 状态（1：启用，0：停用）
    private List<PreBidCostCalcDetailVO> preBidCostCalcDetailList = new ArrayList<>();

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(String projectOrgId) {
        this.projectOrgId = projectOrgId;
    }

    public String getProjectOrgName() {
        return projectOrgName;
    }

    public void setProjectOrgName(String projectOrgName) {
        this.projectOrgName = projectOrgName;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public String getProjectSource() {
        return projectSource;
    }

    public void setProjectSource(String projectSource) {
        this.projectSource = projectSource;
    }

    public String getInternalCooperationProject() {
        return internalCooperationProject;
    }

    public void setInternalCooperationProject(String internalCooperationProject) {
        this.internalCooperationProject = internalCooperationProject;
    }

    public String getFirstBusiness() {
        return firstBusiness;
    }

    public void setFirstBusiness(String firstBusiness) {
        this.firstBusiness = firstBusiness;
    }

    public String getSecondBusiness() {
        return secondBusiness;
    }

    public void setSecondBusiness(String secondBusiness) {
        this.secondBusiness = secondBusiness;
    }

    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public String getProjectContractCode() {
        return projectContractCode;
    }

    public void setProjectContractCode(String projectContractCode) {
        this.projectContractCode = projectContractCode;
    }

    public String getProjectContractName() {
        return projectContractName;
    }

    public void setProjectContractName(String projectContractName) {
        this.projectContractName = projectContractName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public String getCustomerId() {
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }

    public String getTaxType() {
        return taxType;
    }

    public void setTaxType(String taxType) {
        this.taxType = taxType;
    }

    public String getCustomerType() {
        return customerType;
    }

    public void setCustomerType(String customerType) {
        this.customerType = customerType;
    }

    public String getCustomerAddress() {
        return customerAddress;
    }

    public void setCustomerAddress(String customerAddress) {
        this.customerAddress = customerAddress;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getLinker() {
        return linker;
    }

    public void setLinker(String linker) {
        this.linker = linker;
    }

    public String getCellphone() {
        return cellphone;
    }

    public void setCellphone(String cellphone) {
        this.cellphone = cellphone;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public List<PreBidCostCalcDetailVO> getPreBidCostCalcDetailList() {
        return preBidCostCalcDetailList;
    }

    public void setPreBidCostCalcDetailList(List<PreBidCostCalcDetailVO> preBidCostCalcDetailList) {
        this.preBidCostCalcDetailList = preBidCostCalcDetailList;
    }
}
