/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.bean.QuoteClaimEntity;
import com.ejianc.business.income.bean.QuoteDetailEntity;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.bean.QuoteOtherEntity;
import com.ejianc.business.income.history.QuoteHistoryVo;
import com.ejianc.business.income.mapper.QuoteMapper;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.service.IQuoteClaimService;
import com.ejianc.business.income.service.IQuoteDetailService;
import com.ejianc.business.income.service.IQuoteOtherService;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.utils.BigDecimalUtils;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.income.utils.ExcelImportUtil;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.QuoteClaimVo;
import com.ejianc.business.income.vo.QuoteDetailVo;
import com.ejianc.business.income.vo.QuoteOtherVo;
import com.ejianc.business.income.vo.QuoteVo;
import com.ejianc.business.income.vo.comparator.QuoteDetailComparatorVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="QuoteService")
public class QuoteServiceImpl
extends BaseServiceImpl<QuoteMapper, QuoteEntity>
implements IQuoteService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String QUOTE_BILL_CODE = "INCOME_QUOTE";
    @Autowired
    private QuoteMapper quoteMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IQuoteDetailService quoteDetailService;
    @Autowired
    private IQuoteClaimService quoteClaimService;
    @Autowired
    private IQuoteOtherService quoteOtherService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IProductionService productionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<QuoteVo> saveOrUpdate(QuoteVo quoteVo) {
        List entities;
        LambdaQueryWrapper lambda;
        ContractEntity contractEntity;
        block52: {
            contractEntity = (ContractEntity)((Object)this.contractService.selectById(quoteVo.getContractId()));
            Jedis jedis = this.jedisPool.getResource();
            boolean locked = false;
            try {
                CommonResponse param;
                List<QuoteClaimVo> claimVos;
                List<QuoteDetailVo> checkVos;
                locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(quoteVo.getContractId()), (String)"saveOrUpdate", (int)1000);
                this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                if (quoteVo.getContractVersion() != null && quoteVo.getContractVersion() != 0) {
                    if (locked) {
                        Integer conVersion;
                        Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                        if (!version.equals(conVersion = quoteVo.getContractVersion())) {
                            CommonResponse commonResponse = CommonResponse.error((String)"\u65bd\u5de5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                            return commonResponse;
                        }
                    } else {
                        CommonResponse version = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                        return version;
                    }
                }
                if ((checkVos = quoteVo.getCheckList()) != null && checkVos.size() > 0) {
                    HashMap<Long, Integer> versionMap = new HashMap<Long, Integer>();
                    for (QuoteDetailVo detailVo : checkVos) {
                        if (detailVo.getProductionVersion() == null || detailVo.getProductionVersion() == 0) continue;
                        versionMap.put(detailVo.getProductionId(), detailVo.getProductionVersion());
                    }
                    if (versionMap != null && versionMap.size() > 0) {
                        CommonResponse param2;
                        if (locked) {
                            param2 = new QueryParam();
                            param2.getParams().put("id", new Parameter("in", new ArrayList(versionMap.keySet())));
                            List productionEntityList = this.productionService.queryList((QueryParam)param2, false);
                            Iterator iterator = productionEntityList.iterator();
                            while (iterator.hasNext()) {
                                Object productionEntity = (ProductionEntity)((Object)iterator.next());
                                if ((productionEntity.getVersion() == null ? 0 : productionEntity.getVersion()) == (Integer)versionMap.get(productionEntity.getId())) continue;
                                CommonResponse commonResponse = CommonResponse.error((String)"\u4ea7\u503c\u8fdb\u5ea6\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                                return commonResponse;
                            }
                        } else {
                            param2 = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                            return param2;
                        }
                    }
                }
                if ((claimVos = quoteVo.getClaimList()) == null || claimVos.size() <= 0) break block52;
                HashMap<Long, Integer> versionMap = new HashMap<Long, Integer>();
                for (QuoteClaimVo claimVo : claimVos) {
                    if (claimVo.getClaimVersion() == null || claimVo.getClaimVersion() == 0) continue;
                    versionMap.put(claimVo.getClaimId(), claimVo.getClaimVersion());
                }
                if (versionMap == null || versionMap.size() <= 0) break block52;
                if (locked) {
                    param = new QueryParam();
                    param.getParams().put("id", new Parameter("in", new ArrayList(versionMap.keySet())));
                    List claimEntities = this.claimService.queryList((QueryParam)param, false);
                    for (ClaimEntity claimEntity : claimEntities) {
                        if ((claimEntity.getVersion() == null ? 0 : claimEntity.getVersion()) == (Integer)versionMap.get(claimEntity.getId())) continue;
                        CommonResponse commonResponse = CommonResponse.error((String)"\u53d8\u66f4\u7b7e\u8bc1\u6d3d\u5546\u7d22\u8d54\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                        return commonResponse;
                    }
                    break block52;
                }
                param = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return param;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (locked) {
                    RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(quoteVo.getContractId()), (String)"saveOrUpdate");
                }
                jedis.close();
            }
        }
        Date signDate = contractEntity.getSignDate();
        if (null != signDate && quoteVo.getQuoteDate().getTime() < signDate.getTime()) {
            throw new BusinessException("\u62a5\u91cf\u65f6\u95f4\u53ea\u80fd\u662f\u5927\u4e8e\u7b49\u4e8e\u65bd\u5de5\u5408\u540c\u7684\u7b7e\u7ea6\u65e5\u671f");
        }
        Date lastDate = this.quoteMapper.getLastDate(quoteVo.getContractId());
        if (null != lastDate && quoteVo.getQuoteDate().getTime() < lastDate.getTime()) {
            throw new BusinessException("\u62a5\u91cf\u65f6\u95f4\u8981\u5927\u4e8e\u7b49\u4e8e\u8be5\u5408\u540c\u4e0b\u7684\u62a5\u91cf\u65f6\u95f4");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        QuoteEntity entity = null;
        String operateType = null;
        if (quoteVo.getId() != null && quoteVo.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)quoteVo.getBillCode())) {
                quoteVo.setBillCode(null);
            }
            entity = (QuoteEntity)((Object)BeanMapper.map((Object)((Object)quoteVo), QuoteEntity.class));
            operateType = "edit";
        } else {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)quoteVo.getContractId()));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(0);
            billStatus.add(2);
            billStatus.add(5);
            queryParam.getParams().put("bill_state", new Parameter("in", billStatus));
            List entities2 = super.queryList(queryParam, false);
            if (null != entities2 && entities2.size() > 0) {
                throw new BusinessException("\u5408\u540c\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58");
            }
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(QUOTE_BILL_CODE, tenantId);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            quoteVo.setBillCode((String)billCode.getData());
            entity = (QuoteEntity)((Object)BeanMapper.map((Object)((Object)quoteVo), QuoteEntity.class));
            operateType = "add";
        }
        if (quoteVo.getId() != null && quoteVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(QuoteEntity::getBillCode, (Object)quoteVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)quoteVo.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(QuoteEntity::getBillCode, (Object)quoteVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        super.saveOrUpdate((Object)entity);
        List<QuoteDetailVo> detailsVos = quoteVo.getCheckList();
        ArrayList<QuoteDetailEntity> saveOrUpldates = new ArrayList<QuoteDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (QuoteDetailVo quoteDetailVo : detailsVos) {
            QuoteDetailEntity detailslist;
            if ("add".equals(quoteDetailVo.getRowState())) {
                detailslist = (QuoteDetailEntity)((Object)BeanMapper.map((Object)quoteDetailVo, QuoteDetailEntity.class));
                detailslist.setQuoteId(entity.getId());
                detailslist.setId(null);
                saveOrUpldates.add(detailslist);
                continue;
            }
            if ("edit".equals(quoteDetailVo.getRowState())) {
                detailslist = (QuoteDetailEntity)((Object)BeanMapper.map((Object)quoteDetailVo, QuoteDetailEntity.class));
                saveOrUpldates.add(detailslist);
                continue;
            }
            if (!"del".equals(quoteDetailVo.getRowState())) continue;
            deleteIds.add(quoteDetailVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.quoteDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (QuoteDetailEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (QuoteDetailEntity cdEntity : saveOrUpldates) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.quoteDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.quoteDetailService.removeByIds(deleteIds, false);
        }
        List<QuoteClaimVo> clauseVos = quoteVo.getClaimList();
        ArrayList<QuoteClaimEntity> arrayList = new ArrayList<QuoteClaimEntity>();
        ArrayList<Long> deleteClauseIds = new ArrayList<Long>();
        for (QuoteClaimVo clauseVo : clauseVos) {
            QuoteClaimEntity detailslist;
            if ("add".equals(clauseVo.getRowState())) {
                detailslist = (QuoteClaimEntity)((Object)BeanMapper.map((Object)((Object)clauseVo), QuoteClaimEntity.class));
                detailslist.setQuoteId(entity.getId());
                detailslist.setId(null);
                arrayList.add(detailslist);
                continue;
            }
            if ("edit".equals(clauseVo.getRowState())) {
                detailslist = (QuoteClaimEntity)((Object)BeanMapper.map((Object)((Object)clauseVo), QuoteClaimEntity.class));
                arrayList.add(detailslist);
                continue;
            }
            if (!"del".equals(clauseVo.getRowState())) continue;
            deleteClauseIds.add(clauseVo.getId());
        }
        if (arrayList.size() > 0) {
            this.quoteClaimService.saveOrUpdateBatch(arrayList, arrayList.size(), false);
        }
        if (deleteClauseIds.size() > 0) {
            this.quoteClaimService.removeByIds(deleteClauseIds, false);
        }
        List<QuoteOtherVo> otherVos = quoteVo.getOtherList();
        ArrayList<QuoteOtherEntity> otherList = new ArrayList<QuoteOtherEntity>();
        ArrayList<Long> deleteOtherIds = new ArrayList<Long>();
        for (QuoteOtherVo otherVo : otherVos) {
            QuoteOtherEntity detailslist;
            if ("add".equals(otherVo.getRowState())) {
                detailslist = (QuoteOtherEntity)((Object)BeanMapper.map((Object)((Object)otherVo), QuoteOtherEntity.class));
                detailslist.setQuoteId(entity.getId());
                detailslist.setId(null);
                otherList.add(detailslist);
                continue;
            }
            if ("edit".equals(otherVo.getRowState())) {
                detailslist = (QuoteOtherEntity)((Object)BeanMapper.map((Object)((Object)otherVo), QuoteOtherEntity.class));
                otherList.add(detailslist);
                continue;
            }
            if (!"del".equals(otherVo.getRowState())) continue;
            deleteOtherIds.add(otherVo.getId());
        }
        if (otherList.size() > 0) {
            this.quoteOtherService.saveOrUpdateBatch(otherList, otherList.size(), false);
        }
        if (deleteOtherIds.size() > 0) {
            this.quoteOtherService.removeByIds(deleteOtherIds, false);
        }
        return CommonResponse.success((Object)((Object)this.queryDetail(entity.getId())));
    }

    @Override
    public QuoteVo queryDetail(Long id) {
        QuoteEntity entity = (QuoteEntity)((Object)this.quoteMapper.selectById(id));
        if (entity != null) {
            this.setCustomField((Object)entity);
            QuoteVo vo = (QuoteVo)((Object)BeanMapper.map((Object)((Object)entity), QuoteVo.class));
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("quoteId", new Parameter("eq", (Object)vo.getId()));
            List details = this.quoteDetailService.queryList(queryParam, false);
            if (details != null && details.size() > 0) {
                for (QuoteDetailEntity cdEntity : details) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)details, QuoteDetailVo.class);
                Collections.sort(resultMapList, new QuoteDetailComparatorVo());
                vo.setCheckList(TreeNodeBUtil.buildTree(resultMapList));
            }
            QueryParam parm = new QueryParam();
            parm.getParams().put("quoteId", new Parameter("eq", (Object)vo.getId()));
            List claimEntities = this.quoteClaimService.queryList(parm, false);
            vo.setClaimList(BeanMapper.mapList((Iterable)claimEntities, QuoteClaimVo.class));
            List otherEntities = this.quoteOtherService.queryList(parm, false);
            vo.setOtherList(BeanMapper.mapList((Iterable)otherEntities, QuoteOtherVo.class));
            return vo;
        }
        return null;
    }

    @Override
    public void deleteQuote(List<QuoteVo> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public QuoteHistoryVo queryQuoteHistory(Long id) {
        BigDecimal sumQuoteTaxMny;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)id)).orderByDesc((Object[])new String[]{"quote_date", "create_time"});
        List quoteEntitiesAllState = this.quoteMapper.selectList((Wrapper)queryWrapper);
        queryWrapper.in((Object)"bill_state", billStatus);
        List quoteEntities = this.quoteMapper.selectList((Wrapper)queryWrapper);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        QuoteHistoryVo vo = new QuoteHistoryVo();
        vo.setContractId(id);
        vo.setChangeStatus(contractEntity.getChangeStatus());
        vo.setContractStatus(contractEntity.getContractStatus());
        vo.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        vo.setSumQuoteTaxMny(contractEntity.getSumQuoteTaxMny());
        BigDecimal bigDecimal = sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
        if (contractEntity.getContractTaxMny() == null || contractEntity.getContractTaxMny().compareTo(BigDecimal.ZERO) == 0) {
            vo.setSumQuoteRate(BigDecimal.ZERO);
        } else {
            vo.setSumQuoteRate(sumQuoteTaxMny.divide(contractEntity.getContractTaxMny(), 8, 4).multiply(new BigDecimal(100)));
        }
        BigDecimal sumShouldReceive = quoteEntities.stream().filter(item -> item.getShouldReceive() != null).map(QuoteEntity::getShouldReceive).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setSumShouldReceive(sumShouldReceive);
        vo.setQuoteRecord(BeanMapper.mapList((Iterable)quoteEntitiesAllState, QuoteVo.class));
        return vo;
    }

    @Override
    public QuoteDetailVo queryNumAndPriceSum(Map<String, Object> map) {
        return this.quoteMapper.queryNumAndPriceSum(map);
    }

    @Override
    public BigDecimal totalQuoteMoney(Integer range, String year, List<Long> orgIds, Long tenantId) {
        return this.quoteMapper.totalQuoteMoney(range, year, orgIds, tenantId);
    }

    @Override
    public JSONObject queryQuoteDetailHistory(QuoteDetailVo quoteDetailVo) {
        BigDecimal sumQuoteNumEndthis = new BigDecimal(0);
        if (quoteDetailVo.getContractDetailId() != null) {
            quoteDetailVo.setSourceType(1);
            List<QuoteDetailVo> list = ((QuoteMapper)this.baseMapper).queryQuoteDetailHistory(quoteDetailVo);
            if (CollectionUtils.isNotEmpty(list)) {
                for (QuoteDetailVo vo : list) {
                    sumQuoteNumEndthis = BigDecimalUtils.safeAdd(sumQuoteNumEndthis, vo.getQuoteNum());
                }
            }
        }
        JSONObject jo = new JSONObject();
        jo.put("sumQuoteNumEndthis", (Object)sumQuoteNumEndthis);
        return jo;
    }

    @Override
    public void updateQuoteDetailHistory() {
        QuoteDetailVo quoteDetailVo = new QuoteDetailVo();
        List<QuoteDetailVo> quoteDetailList = ((QuoteMapper)this.baseMapper).queryQuoteDetailList(quoteDetailVo);
        for (QuoteDetailVo vo : quoteDetailList) {
            QuoteDetailVo vo_tmp = new QuoteDetailVo();
            vo_tmp.setContractDetailId(vo.getContractDetailId());
            vo_tmp.setCreateTime(vo.getQuoteCreateTime());
            String quoteNumSum = ((QuoteMapper)this.baseMapper).queryQuoteDetailSum(vo_tmp);
            if (StringUtils.isEmpty((CharSequence)quoteNumSum)) {
                quoteNumSum = "0";
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            BigDecimal sumQuoteNumEndthis = BigDecimalUtils.safeAdd(new BigDecimal(quoteNumSum), vo.getQuoteNum());
            updateWrapper.set(QuoteDetailEntity::getSumQuoteNumEndthis, (Object)sumQuoteNumEndthis);
            updateWrapper.set(QuoteDetailEntity::getSumQuoteNum, (Object)quoteNumSum);
            updateWrapper.set(QuoteDetailEntity::getSurplusNum, (Object)BigDecimalUtils.safeSub(vo.getNum(), sumQuoteNumEndthis));
            updateWrapper.eq(BaseEntity::getId, (Object)vo.getId());
            boolean update = this.quoteDetailService.update((Wrapper)updateWrapper);
            System.out.println("update:id=" + vo.getId() + ",sumQuoteNumEndthis=" + BigDecimalUtils.safeAdd(new BigDecimal(quoteNumSum), vo.getQuoteNum()) + ",quoteNumSum=" + quoteNumSum);
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<QuoteDetailVo> detailVoList = new ArrayList<QuoteDetailVo>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                QuoteDetailVo vo = new QuoteDetailVo();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setDetailIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setCode(null);
                    warnType = warnType + "\u6e05\u5355\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setName(null);
                    warnType = warnType + "\u6e05\u5355\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName((String)datas.get(2));
                }
                vo.setUnit((String)datas.get(3));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setQuoteNum(null);
                    warnType = warnType + "\u672c\u671f\u62a5\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setQuoteNum(new BigDecimal((String)datas.get(4)));
                    }
                    catch (Exception e) {
                        vo.setQuoteNum(null);
                        warnType = warnType + "\u672c\u671f\u62a5\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setPrice(null);
                    warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setPrice(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        vo.setPrice(null);
                        warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (!flag) {
                    BigDecimal multiply = ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(vo.getQuoteNum(), vo.getPrice()));
                    vo.setQuoteMny(multiply);
                }
                vo.setMemo((String)datas.get(7));
                vo.setImportFlag(!flag);
                vo.setParentWarn(parentWarn);
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setSourceType(2);
                detailVoList.add(vo);
            }
            for (QuoteDetailVo tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
            resp.put("successList", allList.get(0));
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }
}

