package com.ejianc.business.asset.service.impl;

import com.ejianc.business.asset.bean.AssetInDetailEntity;
import com.ejianc.business.asset.bean.AssetInEntity;
import com.ejianc.business.asset.bean.AssetOutDetailEntity;
import com.ejianc.business.asset.bean.AssetOutEntity;
import com.ejianc.business.asset.pub.ReceiveState;
import com.ejianc.business.asset.service.IAssetInService;
import com.ejianc.business.asset.service.IAssetOutService;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.material.pub.MessageUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("assetOut") 
public class AssetOutBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Value("${common.env.base-host}")
	private String baseHost;

	@Autowired
	MessageUtil messageUtil;

	@Autowired
	private IAssetOutService assetOutService;
	@Autowired
	private IAssetInService assetInService;

	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IBillCodeApi billCodeApi;
	private static final String BILL_CODE = "ZY_ASSET_IN";//此处需要根据实际修改
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("审批通过后的回调开始-------------------");
		AssetOutEntity entity = assetOutService.selectById(billId);

		AssetInEntity assetInEntity = new AssetInEntity();
		CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
		if(billCode.isSuccess()) {
			assetInEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
		}else{
			throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
		}
		assetInEntity.setId(IdWorker.getId());

		assetInEntity.setOutId(entity.getId());
		assetInEntity.setOutOrgId(entity.getOrgId());
		assetInEntity.setOutOrgName(entity.getOrgName());
		assetInEntity.setOrgId(entity.getInOrgId());
		assetInEntity.setOrgName(entity.getInOrgName());
		assetInEntity.setOutProjectId(entity.getProjectId());
		assetInEntity.setOutProjectCode(entity.getProjectCode());
		assetInEntity.setOutProjectName(entity.getProjectName());
		assetInEntity.setProjectId(entity.getInProjectId());
		assetInEntity.setProjectName(entity.getInProjectName());
		assetInEntity.setProjectCode(entity.getInProjectCode());
		assetInEntity.setBillState(1);
		assetInEntity.setReceiveDate(entity.getOutDate());
		assetInEntity.setReceivePersonId(entity.getReceivePersonId());
		assetInEntity.setReceivePersonName(entity.getReceivePersonName());
		assetInEntity.setOutDate(entity.getOutDate());
		assetInEntity.setOutMny(entity.getOutMny());
		assetInEntity.setOutDependOnProject(entity.getDependOnProject());
		assetInEntity.setDependOnProject(entity.getInDependOnProject());

		assetInEntity.setReceiveState(ReceiveState.TO_RECEIVING.getCode());
		assetInEntity.setMemo(entity.getMemo());

		entity.setReceiveState(ReceiveState.TO_RECEIVING.getCode());

		List<AssetInDetailEntity> inDetailList = assetInEntity.getDetailList();
		List<AssetOutDetailEntity> outDetailList =entity.getDetailList();

		if(!ListUtil.isEmpty(outDetailList)){
			outDetailList.forEach(o->{
				AssetInDetailEntity inDetailEntity = BeanMapper.map(o,AssetInDetailEntity.class);
				inDetailEntity.setId(null);
				inDetailEntity.setVersion(null);
				inDetailEntity.setAssetInId(assetInEntity.getId());
				inDetailList.add(inDetailEntity);
			});
		}
		assetInService.saveOrUpdate(assetInEntity, false);
		assetOutService.saveOrUpdate(entity, false);
		sendMessageToReceivePerson(entity.getReceivePersonId(), assetInEntity.getBillCode(), assetInEntity.getId());

		return CommonResponse.success();
	}

	private void sendMessageToReceivePerson(Long receivePersonId, String billCode, Long id) {
		if(receivePersonId!=null){
			List<String> messageType = new ArrayList<>();
			List<String> receivers = new ArrayList<>();
			messageType.add("sys");
			receivers.add(receivePersonId.toString());
			String formUrl = baseHost +"ejc-zypms-frontend/#/assetIn/card?id=" + id;
			String subject = "固定资产调入提醒";
			String content = "收到固定资产调入单【"+billCode+"】请及时处理！。<a href=" + '"' + formUrl + '"' + ">立即处理</a>";
			messageUtil.sendMsg(messageType, receivers, "notice", subject, content);
		}
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		AssetOutEntity entity = assetOutService.selectById(billId);
		if(entity == null){
			return CommonResponse.error("没有找到当前单据信息，无法弃审！");
		}
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		if(!resp.isSuccess()) {
			logger.info("出库单单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}",billId,billTypeCode, resp.getMsg());
			return CommonResponse.error(resp.getMsg());
		}
		return CommonResponse.error("当前单据已被下游固定资产调入引用，不能撤回！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
