package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("contract")
public class ContractBpmService implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IContractService contractService;

    /**
     * 终审审核完回调
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ContractEntity contractEntity =  contractService.selectById(billId);
        CommonResponse<ProjectRegisterVO> response = projectApi.saveContractMny(contractEntity.getProjectId(),contractEntity.getContractTaxMny(),contractEntity.getContractMny(),billId);
        logger.info("合同终审审核完回调，billId:{},state:{},billTypeCode:{}，ProjectId:{},ContractTaxMny:{},ContractMny:{},推送响应：{}", billId, state, billTypeCode,contractEntity.getProjectId(),contractEntity.getContractTaxMny(),contractEntity.getContractMny(), JSONObject.toJSONString(response));
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //合同是否被其他单据引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }
}
