package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/1  采购结算单 物资明细表
 * @Description PurchaseSettlementMaterialDetailEntity
 */
@TableName("ejc_zypms_material_purchase_settlement_material_detail")
public class PurchaseSettlementMaterialDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 主表id
     */
    @TableField(value = "pid")
    private Long pid;

    /**
     * 物资分类名称
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;


    /**
     * 物资分类id
     */
    @TableField(value = "material_type_id")
    private Long materialTypeId;

    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 物资id
     */
    @TableField(value = "material_id")
    private Long materialId;

    /**
     * 规格型号
     */
    @TableField(value = "spec")
    private String spec;

    /**
     * 计量单位
     */
    @TableField(value = "unit")
    private String unit;

    /**
     * 结算数量
     */
    @TableField(value = "num")
    private BigDecimal num;

    /**
     * 结算单价
     */
    @TableField(value = "price")
    private BigDecimal price;

    /**
     * 金额
     */
    @TableField(value = "money")
    private BigDecimal money;

    @TableField(value = "this_add_settle_num")
    private BigDecimal thisAddSettleNum;//已结算量(含本次)
    @TableField(value = "settle_num")
    private BigDecimal settleNum;//已结算量(不含本次)
    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    /**
     * 数据来源类型
     */
    @TableField(value = "source_type")
    private String sourceType;

    /**
     * 数据来源类型名称
     */
    @TableField(value = "source_type_name")
    private String sourceTypeName;

    /**
     * 数据来源主表id
     */
    @TableField(value = "source_main_id")
    private String sourceMainId;

    /**
     * 数据来源子表id
     */
    @TableField(value = "source_sub_id")
    private String sourceSubId;

    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;

    /**
     * 成本科目名称
     */
    @TableField(value = "subject_name")
    private String subjectName;

    /**
     * 税率
     */
    @TableField(value = "tax_rate")
    private BigDecimal taxRate;

    @TableField(value="material_info")
    private String materialInfo; // 采购物资名称
    @TableField(value="brand_id")
    private Long brandId; // 供应商品牌id
    @TableField(value="brand_name")
    private String brandName; // 供应商品牌
    @TableField(value="model_id")
    private Long modelId; // 规格型号id
    @TableField(value="thickness")
    private String thickness; // 厚度
    @TableField(value="colour")
    private String colour; // 色号/容重


    /**
     * 物资编码
     */
    @TableField(value = "material_code")
    private String materialCode;
    @TableField(value="fixed_material")
    private String fixedMaterial;//是否固定资产1是0否

    public String getFixedMaterial() {
        return fixedMaterial;
    }

    public void setFixedMaterial(String fixedMaterial) {
        this.fixedMaterial = fixedMaterial;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public BigDecimal getThisAddSettleNum() {
        return thisAddSettleNum;
    }

    public void setThisAddSettleNum(BigDecimal thisAddSettleNum) {
        this.thisAddSettleNum = thisAddSettleNum;
    }

    public BigDecimal getSettleNum() {
        return settleNum;
    }

    public void setSettleNum(BigDecimal settleNum) {
        this.settleNum = settleNum;
    }



    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public String getSourceMainId() {
        return sourceMainId;
    }

    public void setSourceMainId(String sourceMainId) {
        this.sourceMainId = sourceMainId;
    }

    public String getSourceSubId() {
        return sourceSubId;
    }

    public void setSourceSubId(String sourceSubId) {
        this.sourceSubId = sourceSubId;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getMaterialInfo() {
        return materialInfo;
    }

    public void setMaterialInfo(String materialInfo) {
        this.materialInfo = materialInfo;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Long getModelId() {
        return modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public String getThickness() {
        return thickness;
    }

    public void setThickness(String thickness) {
        this.thickness = thickness;
    }

    public String getColour() {
        return colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
    }
}
