/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.service.impl.InstoreMaterialService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="straightInout")
public class StraightInoutBpmService
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String OUT_STORE_BILL_CODE = "ZYDX_MATERIAL-OUTSTORE";
    @Autowired
    IInstoreService iInstoreService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    private InstoreMaterialService instoreMaterialService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    IUseApplyService useApplyService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5ba1\u6279\u901a\u8fc7\u540e\u7684\u56de\u8c03\u5f00\u59cb-------------------billId\uff1a{}\uff0cstate\uff1a{}\uff0cbillTypeCode\uff1a{}", new Object[]{billId, state, billTypeCode});
        InstoreEntity entity = (InstoreEntity)((Object)this.iInstoreService.selectById(billId));
        if (entity == null) {
            CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u5165\u5e93\u5355\uff01");
        }
        this.logger.info("\u5ba1\u6279\u901a\u8fc7\u540e\u7684\u56de\u8c03\uff0c\u4fee\u6539InstoreEntity\u72b6\u6001------" + entity.getBillState());
        ArrayList<OutStoreSubEntity> outStoreSubEntities = new ArrayList<OutStoreSubEntity>();
        if (!ListUtil.isEmpty(entity.getInstoreMaterialList())) {
            OutStoreSubEntity subEntity = new OutStoreSubEntity();
            for (InstoreMaterialEntity sub : entity.getInstoreMaterialList()) {
                sub.setStoreState(MaterialStoreState.STORED.getCode());
                subEntity = (OutStoreSubEntity)((Object)BeanMapper.map((Object)((Object)sub), OutStoreSubEntity.class));
                subEntity.setStoreState(MaterialStoreState.USED.getCode());
                subEntity.setId(null);
                subEntity.setOutStoreNumber(sub.getInstoreNumber());
                subEntity.setSourceMainId(entity.getId());
                subEntity.setSourceSubId(sub.getId());
                subEntity.setStoreType(MaterialStoreType.STRAIGHT_OUT_STORE.getCode());
                subEntity.setOutDate(entity.getInstoreDate());
                subEntity.setInstallFlag(0);
                outStoreSubEntities.add(subEntity);
            }
        }
        this.processCostState(entity, 1);
        this.iInstoreService.saveOrUpdate((Object)entity, false);
        OutStoreEntity outentity = (OutStoreEntity)((Object)BeanMapper.map((Object)((Object)entity), OutStoreEntity.class));
        outentity.setStraightInId(entity.getId());
        outentity.setId(null);
        outentity.setOutStoreSubEntities(outStoreSubEntities);
        outentity.setOutDate(entity.getInstoreDate());
        outentity.setOutMoney(entity.getTotalAmount());
        outentity.setOutNum(entity.getTotalCount());
        outentity.setMaterialNames(entity.getMaterialName());
        outentity.setStoreType(MaterialStoreType.STRAIGHT_OUT_STORE.getCode());
        outentity.setSupplierId(entity.getLabourArmyId());
        outentity.setSupplierName(entity.getLabourArmy());
        this.logger.info("\u76f4\u5165\u76f4\u51fa \u4fdd\u5b58 \u51fa\u5e93\u5355\u8be6\u60c5--------------->outentity.getBillState(){}", (Object)outentity.getBillState());
        this.iOutStoreService.saveOrUpdate((Object)outentity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp;
        this.logger.info("\u5f03\u5ba1\u540e\u7684\u56de\u8c03\u5f00\u59cb-------------------");
        InstoreEntity entity = (InstoreEntity)((Object)this.iInstoreService.selectById(billId));
        if (entity == null) {
            CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u5165\u5e93\u5355\uff01");
        }
        if (!(resp = this.billTypeApi.checkQuote(billTypeCode, billId)).isSuccess()) {
            this.logger.info("\u76f4\u5165\u76f4\u51fa\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", new Object[]{billId, billTypeCode, resp.getMsg()});
            return CommonResponse.error((String)resp.getMsg());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"straight_in_id", (Object)billId);
        List vos = this.iOutStoreService.list((Wrapper)queryWrapper);
        List outStoreIds = vos.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"source_type", (Object)"pickReturn");
        wrapper.in((Object)"source_main_id", outStoreIds);
        List<InstoreMaterialVO> pickReturn = this.instoreMaterialService.querylist((QueryWrapper<InstoreMaterialEntity>)wrapper);
        if (pickReturn != null && pickReturn.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u5355\u636e\uff08\u9886\u6599\u9000\u5e93\u5f15\u7528\uff09");
        }
        if (!ListUtil.isEmpty(entity.getInstoreMaterialList())) {
            entity.getInstoreMaterialList().forEach(sub -> sub.setStoreState(MaterialStoreState.STORING.getCode()));
        }
        this.processCostState(entity, 0);
        this.iInstoreService.saveOrUpdate((Object)entity, false);
        this.logger.info("\u5220\u9664\u51fa\u5e93\u6570\u636e--------");
        this.iOutStoreService.removeByIds(outStoreIds, true);
        this.logger.info("\u5220\u9664\u51fa\u5e93\u6570\u636e\u6210\u529f--------");
        return CommonResponse.success();
    }

    public void processCostState(InstoreEntity entity, Integer process) {
        if (process == 1) {
            this.iInstoreService.processCost(entity);
        } else {
            entity.setRelationFlag("0");
        }
    }
}

