package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.MaterialContractItemEntity;
import com.ejianc.business.material.mapper.MaterialContractItemMapper;
import com.ejianc.business.material.service.IMaterialContractItemService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/9 16:09
 */
@Service("materialContractItemService")
public class MaterialContractItemServiceImpl extends BaseServiceImpl<MaterialContractItemMapper, MaterialContractItemEntity>
    implements IMaterialContractItemService {


    @Autowired
    private MaterialContractItemMapper materialContractItemMapper;

    @Override
    public void deleteByContractId(Long materialContractId) {
        QueryWrapper<MaterialContractItemEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("material_contract_id", materialContractId);
        materialContractItemMapper.delete(deleteWrapper);
    }
}
