package com.ejianc.business.sub.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.sub.bean.SubFinishEntity;
import com.ejianc.business.sub.vo.SubFinishRecordVO;
import com.ejianc.business.sub.vo.SubFinishVO;
import com.ejianc.business.sub.vo.SubParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 分包完工结算表 服务类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
public interface ISubFinishService extends IBaseService<SubFinishEntity> {

    SubFinishVO insertOrUpdate(SubFinishVO finishVO);

    SubFinishVO queryDetail(Long id);

    CommonResponse<IPage<SubFinishVO>> queryListVOs(QueryParam param);

    CommonResponse<String> deleteByIds(List<SubFinishVO> vos);

    SubFinishRecordVO queryDetailRecord(Long id);

    SubFinishVO queryDetailAdd(Long contractId);

    List<SubFinishVO> queryExportList(QueryParam param);

    SubParamsCheckVO checkParams(Integer purchaseType, BigDecimal settleTaxMny, BigDecimal contractTaxMny, Long orgId);

}
