package com.ejianc.business.material.controller.api;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.vo.InstoreVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/instore/")
public class InstoreApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IInstoreService instoreService;

    /**
     * @Author liyongjia
     * @Date 2020/6/2 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.InstoreVO>
     */
    @RequestMapping(value = "queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InstoreVO> queryDetail(@RequestParam(value = "id") Long id) {
        InstoreEntity entity = instoreService.selectById(id);
        InstoreVO vo = BeanMapper.map(entity, InstoreVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Author liyongjia
     * @Date 2020/6/10  修改是否付款
     * @Description updatePayment
     * @Param [vos]
     * @Return 
     */
    @RequestMapping(value = "updatePayment", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updatePayment(@RequestBody List<InstoreVO> vos) {
    	for(InstoreVO vo : vos){
    		InstoreEntity entity = instoreService.selectById(vo.getId());
    		entity.setPaymentFlag(vo.getPaymentFlag());
            entity.setQuoteFor(vo.getQuoteFor());
            instoreService.saveOrUpdate(entity,false);
    	}
        return CommonResponse.success("保存或修改单据成功！","");
    }


    /**
     * @description: 零星付款参照入库单回写累计申请金额
     *
     * @param map
     * @return {@link CommonResponse< String>}
     * @author songlx
     * @date: 2025/1/23
     */
    @RequestMapping(value = "updateSumApplyMny", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateSumApplyMny(@RequestBody Map<Long, BigDecimal> map) {
        if (MapUtils.isNotEmpty(map)) {
            for (Long id : map.keySet()) {
                LambdaUpdateWrapper<InstoreEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.eq(InstoreEntity::getId, id);
                wrapper.set(InstoreEntity::getSumApplyMny, ComputeUtil.nullToZero(map.get(id)));
                instoreService.update(wrapper);
            }
        }
        return CommonResponse.success("零星付款参照入库单回写累计申请金额成功！", "");
    }

}
