package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.*;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.mapper.SubChangeMapper;
import com.ejianc.business.sub.service.*;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * <p>
 * 分包变更表 服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("SubChangeServiceImpl")
public class SubChangeServiceImpl extends BaseServiceImpl<SubChangeMapper, SubChangeEntity> implements IChangeService {

    private static final String SUB_CHANGE_BILL_CODE = "SUB_CHANGE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IContractService contractService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IChangeDetailService changeDetailService;
    @Autowired
    private ISubSettleService settleService;
    @Autowired
    private ISubSettleDetailService settleDetailService;

    @Override
    public SubChangeVO insertOrUpdate(SubChangeVO changeVO) {
        if(checkFinishContract(changeVO)){
            throw new BusinessException("该合同在相同组织下已经完工，不允许变更！");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        SubChangeEntity entity = null;
        List<SubContractEntity> entitiesc = null;
        List<SubChangeEntity> entities = null;
        int count = 0;

        //变更合同只能存在一条未生效的
        LambdaQueryWrapper<SubChangeEntity> lambdachange = Wrappers.<SubChangeEntity>lambdaQuery();
        lambdachange.eq(SubChangeEntity::getTenantId, tenantId);
        lambdachange.eq(SubChangeEntity::getContractId,changeVO.getContractId());
        if(changeVO.getId() != null && changeVO.getId() > 0) {
            lambdachange.ne(SubChangeEntity::getId,changeVO.getId());
        }
        lambdachange.ne(SubChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(SubChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }
        if(StringUtils.isEmpty(changeVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(SUB_CHANGE_BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                changeVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(changeVO.getId() != null && changeVO.getId() > 0 && changeService.getById(changeVO.getId())!=null) {
            //修改 校验合同编号唯一，变更单除去本单，采购合同  同时唯一
            LambdaQueryWrapper<SubChangeEntity> lambda = Wrappers.<SubChangeEntity>lambdaQuery();
            lambda.eq(SubChangeEntity::getBillCode, changeVO.getBillCode());
            lambda.eq(SubChangeEntity::getTenantId, tenantId);
            lambda.ne(SubChangeEntity::getContractId,changeVO.getContractId());
            entities = super.list(lambda);

            LambdaQueryWrapper<SubContractEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(SubContractEntity::getTenantId, tenantId);
            queryWrapper.eq(SubContractEntity::getBillCode, changeVO.getBillCode());
            queryWrapper.ne(SubContractEntity::getId, changeVO.getContractId());
            count = contractService.count(queryWrapper);

        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<SubChangeEntity> lambda = Wrappers.<SubChangeEntity>lambdaQuery();
            lambda.eq(SubChangeEntity::getTenantId, tenantId);
            lambda.eq(SubChangeEntity::getBillCode, changeVO.getBillCode());
            lambda.ne(SubChangeEntity::getContractId,changeVO.getContractId());
            entities = super.list(lambda);
            LambdaQueryWrapper<SubContractEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(SubContractEntity::getTenantId, tenantId);
            queryWrapper.eq(SubContractEntity::getBillCode, changeVO.getBillCode());
            queryWrapper.ne(SubContractEntity::getId, changeVO.getContractId());
            count = contractService.count(queryWrapper);
            //新增即点变更按钮穿透过来，此时ID为合同id
//            changeVO.setMakeTime(new Date());
        }

        if(entities != null && entities.size() > 0  && count > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        SubChangeEntity changeEntity = BeanMapper.map(changeVO, SubChangeEntity.class);
        //保存前清空主键和父主键，重新生成
        List<SubChangeDetailEntity> beforeDetails = changeEntity.getDetailList();
        if((CollectionUtils.isNotEmpty(beforeDetails) && null == changeEntity.getId())||(CollectionUtils.isNotEmpty(beforeDetails) && changeService.getById(changeVO.getId())==null)){
            for(SubChangeDetailEntity cdEntity : beforeDetails){
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        super.saveOrUpdate(changeEntity, false);

        List<SubChangeDetailEntity> changeDetailEntities = changeEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(changeDetailEntities)){
            Map<String,Long> idMap=new HashMap<>();
            for(SubChangeDetailEntity cdEntity : changeDetailEntities){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(SubChangeDetailEntity cdEntity : changeDetailEntities){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            changeDetailService.saveOrUpdateBatch(changeDetailEntities, changeDetailEntities.size(), false);
        }

        saveWriteContract(changeEntity);

        return queryDetail(changeEntity.getId());
    }

    private Boolean checkSameBillCode(SubChangeVO changeVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<SubChangeEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SubChangeEntity::getBillCode, changeVO.getBillCode());
        lambda.eq(SubChangeEntity::getTenantId, tenantId);
        if(null != changeVO.getId() && changeVO.getId() > 0){
            lambda.ne(SubChangeEntity::getContractId,changeVO.getContractId());
        }
        Boolean changeCheckFlag = super.list(lambda).size() > 0;

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
        queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,changeVO.getBillCode()));
        queryParam.getParams().put("id", new Parameter(QueryParam.NE, changeVO.getContractId()));
        Boolean contCheckFlag = contractService.queryList(queryParam,false).size() > 0;

        return changeCheckFlag || contCheckFlag;

    }

    /**
     * 保存回写合同
     * @param changeEntity
     */
    private void saveWriteContract(SubChangeEntity changeEntity){
        LambdaUpdateWrapper<SubContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(SubContractEntity::getChangeId, changeEntity.getId());
        updateWrapper.set(SubContractEntity::getChangeCode, changeEntity.getBillCode());
        updateWrapper.set(SubContractEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWrapper.set(SubContractEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
        updateWrapper.set(SubContractEntity::getChangingMny, changeEntity.getContractMny());
        updateWrapper.set(SubContractEntity::getChangingTaxMny, changeEntity.getContractTaxMny());
        updateWrapper.eq(SubContractEntity::getId, changeEntity.getContractId());
        contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
    }

    @Override
    public SubChangeVO queryDetail(Long id) {
        SubChangeEntity changeEntity = super.selectById(id);
        SubChangeVO changeVO =  BeanMapper.map(changeEntity, SubChangeVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("changeId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<SubChangeDetailEntity> detailEntityList = changeDetailService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(SubChangeDetailEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                cdEntity.setRowState("edit");
            }
            List<SubChangeDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, SubChangeDetailVO.class);
            resultMapList = checkDetailSettle(resultMapList);
            changeVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
        }
        changeVO.setChangeMny(ComputeUtil.safeSub(changeVO.getContractTaxMny(), changeVO.getBeforeChangeTaxMny()));
        changeVO.setChangeMnyScale(ComputeUtil.bigDecimalPercent(changeVO.getChangeMny(), changeVO.getBeforeChangeTaxMny(), 2));
        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<SubChangeVO> vos) {
        SubChangeVO changeVo = vos.get(0);
        SubChangeEntity entity = super.selectById(changeVo.getId());
        //合同变更只有详情页有删除
        SubContractEntity pcentity = contractService.selectById(entity.getContractId());
        //会写合同表
        pcentity.setId(entity.getContractId());
        pcentity.setChangeVersion(pcentity.getChangeVersion()-1);
        pcentity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        pcentity.setChangingMny(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangingTaxMny(BigDecimal.ZERO);
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        contractService.update(pcentity, new QueryWrapper<SubContractEntity>().eq("id",pcentity.getId()),false);
        super.removeByIds(vos.stream().map(SubChangeVO::getId).collect(Collectors.toList()),false);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse<IPage<SubChangeVO>> queryListVOs(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        IPage<SubChangeEntity> page = queryPage(param, false);
        List<SubChangeVO> changeVOList = BeanMapper.mapList(page.getRecords(), SubChangeVO.class);
        IPage<SubChangeVO> changeVOIPage = new Page<>();
        changeVOIPage.setCurrent(page.getCurrent());
        changeVOIPage.setRecords(changeVOList);
        changeVOIPage.setSize(page.getSize());
        changeVOIPage.setTotal(page.getTotal());
        changeVOIPage.setPages(page.getPages());
        return CommonResponse.success("查询成功！", changeVOIPage);
    }

    @Override
    public SubChangeVO addConvertByConId(Long contractId) {
        SubContractVO contractVO = contractService.queryDetail(contractId, false);
        SubChangeVO changeVO = BeanMapper.map(contractVO, SubChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeContractName(contractVO.getContractName());
        changeVO.setBeforeChangeMny(contractVO.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractVO.getContractTaxMny());
        changeVO.setContractId(changeVO.getId());
        changeVO.setChangeVersion(contractVO.getChangeVersion() == null ? 1 : contractVO.getChangeVersion()+ 1);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(IdWorker.getId());

        List<SubChangeDetailVO> changeDetailList = changeVO.getDetailList();
        if(CollectionUtils.isNotEmpty(changeDetailList)){
            changeDetailList.forEach(changeDetailVO ->{
                changeDetailVO.setSrcBid(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(changeDetailVO.getNum());
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getPrice());
                changeDetailVO.setBeforeChangeMny(changeDetailVO.getMoney());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setChangeType(null);
            });
            changeDetailList = checkDetailSettle(changeDetailList);
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree(changeDetailList));

        List<SubChangeClauseVO> changeClauseList = changeVO.getClauseList();
        if(CollectionUtils.isNotEmpty(changeClauseList)){
            changeClauseList.forEach(changeClauseVO ->{
                changeClauseVO.setRowState("add");
            });
        }

        List<SubChangeStageVO> changeStageVOList = changeVO.getStageList();
        if(CollectionUtils.isNotEmpty(changeStageVOList)){
            changeStageVOList.forEach(changeStageVO ->{
                changeStageVO.setRowState("add");
            });
        }
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractId),"BT200529000000001","subContractBill", String.valueOf(changeVO.getId()), "BT200610000000003","subContractBill");
        return changeVO;
    }

    @Override
    public SubChangeRecordVO queryDetailRecord(Long id) {
        SubContractEntity contractEntity = contractService.selectById(id);
        SubChangeRecordVO changeRecordVO = new SubChangeRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney();
        changeRecordVO.setContractId(id);
        changeRecordVO.setContractTaxMny(contractTaxMny);
        changeRecordVO.setBaseTaxMoney(baseTaxMny);
        changeRecordVO.setFinishFlag(contractEntity.getFinishFlag());
        changeRecordVO.setContractStatus(contractEntity.getContractStatus());
        changeRecordVO.setChangeStatus(contractEntity.getChangeStatus());
        changeRecordVO.setSumChangeMny(contractTaxMny.subtract(baseTaxMny));
        BigDecimal sumChangeMny = changeRecordVO.getSumChangeMny() ==null ? BigDecimal.ZERO : changeRecordVO.getSumChangeMny();
        if(sumChangeMny.compareTo(BigDecimal.ZERO)!=0&&baseTaxMny.compareTo(BigDecimal.ZERO)!=0){
            BigDecimal sumScale = (sumChangeMny.divide(baseTaxMny, 8,ROUND_HALF_DOWN)).multiply(new BigDecimal(100));
            changeRecordVO.setSumScale(sumScale);
        }
        if(null != contractEntity.getChangeVersion() && contractEntity.getChangeVersion()>0){
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<SubChangeEntity> lambda = Wrappers.<SubChangeEntity>lambdaQuery();
            lambda.eq(SubChangeEntity::getContractId,id);
            lambda.in(SubChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
            List<SubChangeEntity> entities = super.list(lambda);
            entities.forEach(changevo -> {
                        if(changevo.getChangeVersion()<10){
                            changevo.setBillCode(changevo.getBillCode()+"-0"+changevo.getChangeVersion());
                        }else{
                            changevo.setBillCode(changevo.getBillCode()+"-"+changevo.getChangeVersion());
                        }
                    }
            );
            changeRecordVO.setDetailList(BeanMapper.mapList(entities, SubChangeRecordDetailVO.class));
        }
        return changeRecordVO;
    }

    @Override
    public List<SubChangeDetailVO> checkDetailSettle(List<SubChangeDetailVO> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)){
            Long contractId = detailList.get(0).getContractId();
            QueryWrapper<SubSettleEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("contract_id",contractId);
            queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
            List<SubSettleEntity> list = settleService.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(list)){
                List<Long> ids = list.stream().map(SubSettleEntity::getId).collect(Collectors.toList());
                List<Long> detailIdsList = detailList.stream().map(SubChangeDetailVO::getSrcBid).collect(Collectors.toList());
                QueryWrapper<SubSettleDetailEntity> queryDetailWrapper = new QueryWrapper<>();
                queryDetailWrapper.in("settle_id",ids);
                queryDetailWrapper.in("contract_detail_id",detailIdsList);
                queryDetailWrapper.select("IFNULL(SUM(settle_num),0) AS sum_settle_num,contract_detail_id");
                queryDetailWrapper.groupBy("contract_detail_id");
                List<SubSettleDetailEntity> settleNumList = settleDetailService.list(queryDetailWrapper);
                if (CollectionUtils.isNotEmpty(settleNumList)){
                    Map<Long, BigDecimal> settleMap = settleNumList.stream().collect(Collectors.toMap(SubSettleDetailEntity::getContractDetailId, SubSettleDetailEntity::getSumSettleNum));
                        for (SubChangeDetailVO changeDetailVO : detailList) {
                            Long id = changeDetailVO.getSrcBid();
                            if (settleMap.get(id)!=null){
                                changeDetailVO.setSettleType(1);
                                BigDecimal settleMum = settleMap.get(id);
                                changeDetailVO.setSettleNum(settleMum);
                            }else {
                                changeDetailVO.setSettleType(0);
                                changeDetailVO.setSettleNum(BigDecimal.ZERO);
                            }
                        }
                    }
                }
            }
        return detailList;
    }

    @Override
    public List<SubChangeDetailVO> checkChangeDetailSettle(List<SubChangeDetailVO> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)){
            Long contractId = detailList.get(0).getContractId();
            QueryWrapper<SubSettleEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("contract_id",contractId);
            queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
            List<SubSettleEntity> list = settleService.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(list)){
                List<Long> ids = list.stream().map(SubSettleEntity::getId).collect(Collectors.toList());
                List<Long> detailIdsList = detailList.stream().map(SubChangeDetailVO::getSrcBid).collect(Collectors.toList());
                QueryWrapper<SubSettleDetailEntity> queryDetailWrapper = new QueryWrapper<>();
                queryDetailWrapper.in("settle_id",ids);
                queryDetailWrapper.in("contract_detail_id",detailIdsList);
                queryDetailWrapper.select("IFNULL(SUM(settle_num),0) AS sum_settle_num,contract_detail_id");
                queryDetailWrapper.groupBy("contract_detail_id");
                List<SubSettleDetailEntity> settleNumList = settleDetailService.list(queryDetailWrapper);
                if (CollectionUtils.isNotEmpty(settleNumList)){
                    Map<Long, BigDecimal> settleMap = settleNumList.stream().collect(Collectors.toMap(SubSettleDetailEntity::getContractDetailId, SubSettleDetailEntity::getSumSettleNum));
                    for (SubChangeDetailVO changeDetailVO : detailList) {
                        Long id = changeDetailVO.getSrcBid();
                        if (settleMap.get(id)!=null){
                            changeDetailVO.setSettleType(1);
                            BigDecimal settleMum = settleMap.get(id);
                            changeDetailVO.setSettleNum(settleMum);
                        }else {
                            changeDetailVO.setSettleType(0);
                            changeDetailVO.setSettleNum(BigDecimal.ZERO);
                        }
                    }
                }
            }
        }
        return detailList;
    }

    private Boolean checkFinishContract(SubChangeVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<SubContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SubContractEntity::getId, finishVO.getContractId());
        lambda.eq(SubContractEntity::getTenantId, tenantId);
        lambda.eq(SubContractEntity::getFinishFlag, true);
        return contractService.list(lambda).size() > 0;
    }
}
