/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.income.bean.ClaimDetailEntity;
import com.ejianc.business.income.mapper.ClaimDetailMapper;
import com.ejianc.business.income.service.IClaimDetailService;
import com.ejianc.business.income.utils.ExcelImportUtil;
import com.ejianc.business.income.vo.ClaimDetailVo;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="ClaimDetailService")
public class ClaimDetailServiceImpl
extends BaseServiceImpl<ClaimDetailMapper, ClaimDetailEntity>
implements IClaimDetailService {
    @Override
    public void deleteByClaimId(Long id) {
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.eq((Object)"claim_id", (Object)id);
        ((ClaimDetailMapper)this.baseMapper).delete((Wrapper)deleteWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<ClaimDetailVo> detailVoList = new ArrayList<ClaimDetailVo>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ClaimDetailVo vo = new ClaimDetailVo();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setDetailIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setCode(null);
                    warnType = warnType + "\u6e05\u5355\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setName(null);
                    warnType = warnType + "\u6e05\u5355\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName((String)datas.get(2));
                }
                vo.setUnit((String)datas.get(3));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setOccurNum(null);
                    warnType = warnType + "\u53d1\u751f\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setOccurNum(new BigDecimal((String)datas.get(4)));
                    }
                    catch (Exception e) {
                        vo.setOccurNum(null);
                        warnType = warnType + "\u53d1\u751f\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    vo.setOccurMny(null);
                    warnType = warnType + "\u53d1\u751f\u5408\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setOccurMny(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        vo.setOccurMny(null);
                        warnType = warnType + "\u53d1\u751f\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (null == vo.getOccurNum() || null == vo.getOccurMny()) {
                    vo.setOccurPrice(null);
                } else {
                    vo.setOccurPrice(vo.getOccurMny().divide(vo.getOccurNum(), 20, 6));
                }
                if (null == vo.getOccurNum() || null == vo.getOccurPrice()) {
                    vo.setOccurMny(null);
                } else {
                    vo.setOccurMny(vo.getOccurNum().multiply(vo.getOccurPrice()));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    vo.setReplyNum(null);
                    warnType = warnType + "\u5ba1\u6838\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setReplyNum(new BigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        vo.setReplyNum(null);
                        warnType = warnType + "\u5ba1\u6838\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(9)))) {
                    vo.setReplyMny(null);
                    warnType = warnType + "\u5ba1\u6838\u5408\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setReplyMny(new BigDecimal((String)datas.get(9)));
                    }
                    catch (Exception e) {
                        vo.setReplyMny(null);
                        warnType = warnType + "\u5ba1\u6838\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (null == vo.getReplyNum() || null == vo.getReplyMny()) {
                    vo.setReplyPrice(null);
                } else {
                    vo.setReplyPrice(vo.getReplyMny().divide(vo.getReplyNum(), 20, 6));
                }
                if (null == vo.getReplyNum() || null == vo.getReplyPrice()) {
                    vo.setReplyMny(null);
                } else {
                    vo.setReplyMny(vo.getReplyNum().multiply(vo.getReplyPrice()));
                }
                vo.setMemo((String)datas.get(10));
                vo.setImportFlag(!flag);
                vo.setParentWarn(parentWarn);
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setSourceType(2);
                detailVoList.add(vo);
            }
            for (ClaimDetailVo tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
            resp.put("successList", allList.get(0));
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - 1 - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }
}

