/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISubFinishService;
import com.ejianc.business.sub.vo.SubFinishVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subFinish")
public class SubFinishBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubFinishService finishService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SubFinishVO finishEntity = this.finishService.queryDetail(billId);
        SubContractEntity contractEntity = (SubContractEntity)((Object)this.contractService.getById(finishEntity.getContractId()));
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = finishEntity.getShouldPayTaxMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayTaxMny();
        BigDecimal settleMny = finishEntity.getShouldPayMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayMny();
        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = finishEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobTaxMny();
        BigDecimal jobMny = finishEntity.getOddjobMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobMny();
        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = finishEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOtherTaxMny();
        BigDecimal otherMny = finishEntity.getOtherMny() == null ? BigDecimal.ZERO : finishEntity.getOtherMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(SubContractEntity::getSumSettleTaxMny, (Object)sumSettleTaxMny.add(settleTaxMny));
        updateWrapper.set(SubContractEntity::getSumSettleMny, (Object)sumSettleMny.add(settleMny));
        updateWrapper.set(SubContractEntity::getSumOddjobSettleTaxMny, (Object)sumOddjobSettleTaxMny.add(jobTaxMny));
        updateWrapper.set(SubContractEntity::getSumOddjobSettleMny, (Object)sumOddjobSettleMny.add(jobMny));
        updateWrapper.set(SubContractEntity::getSumOtherTaxMny, (Object)sumOtherTaxMny.add(otherTaxMny));
        updateWrapper.set(SubContractEntity::getSumOtherMny, (Object)sumOtherMny.add(otherMny));
        updateWrapper.eq(BaseEntity::getId, (Object)finishEntity.getContractId());
        this.contractService.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SubFinishVO finishEntity = this.finishService.queryDetail(billId);
        SubContractEntity contractEntity = (SubContractEntity)((Object)this.contractService.getById(finishEntity.getContractId()));
        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = finishEntity.getShouldPayTaxMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayTaxMny();
        BigDecimal settleMny = finishEntity.getShouldPayMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayMny();
        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = finishEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobTaxMny();
        BigDecimal jobMny = finishEntity.getOddjobMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobMny();
        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = finishEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOtherTaxMny();
        BigDecimal otherMny = finishEntity.getOtherMny() == null ? BigDecimal.ZERO : finishEntity.getOtherMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(SubContractEntity::getSumSettleTaxMny, (Object)sumSettleTaxMny.subtract(settleTaxMny));
        updateWrapper.set(SubContractEntity::getSumSettleMny, (Object)sumSettleMny.subtract(settleMny));
        updateWrapper.set(SubContractEntity::getSumOddjobSettleTaxMny, (Object)sumOddjobSettleTaxMny.subtract(jobTaxMny));
        updateWrapper.set(SubContractEntity::getSumOddjobSettleMny, (Object)sumOddjobSettleMny.subtract(jobMny));
        updateWrapper.set(SubContractEntity::getSumOtherTaxMny, (Object)sumOtherTaxMny.subtract(otherTaxMny));
        updateWrapper.set(SubContractEntity::getSumOtherMny, (Object)sumOtherMny.subtract(otherMny));
        updateWrapper.eq(BaseEntity::getId, (Object)finishEntity.getContractId());
        this.contractService.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }
}

