package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.cost.bean.PrjcontractCostsDetailEntity;

/**
 * 项目合同造价表
 * 
 * @author generator
 * 
 */
@TableName("ejc_zypms_cost_prjcontract_costs")
public class PrjcontractCostsEntity extends BaseEntity {
	private static final long serialVersionUID = 1L;

	@TableField(value = "prjcontract_targetcost_ids")
	private String projectTargetcostIds; // 项目目标成本
	@TableField(value = "bill_state")
	private Integer billState; // 单据审批状态
	@TableField(value = "bill_code")
	private String billCode; // 单据编码
	@TableField(value = "`project_id`")
	private Long projectId; // 项目id
	@TableField(value = "project_name")
	private String projectName; // 项目名称
	@TableField(value = "project_department_id")
	private Long projectDepartmentId; // 项目部id
	@TableField(value = "org_id")
	private Long orgId; // 组织ID
	@TableField(value="org_name")
	private String orgName; // 所属单位
	@TableField(value = "prebid_id")
	private Long prebidId; // 标前测算ID
	@TableField(value = "prebid_cost")
	private BigDecimal prebidCost; // 标前测算金额
	@TableField(value = "pub_unit_name")
	private String pubUnitName; // 发包单位名称
	@TableField(value = "contract_unit_name")
	private String contractUnitName; // 承包单位名称
	@TableField(value = "contract_tax_mny")
	private BigDecimal contractTaxMny; // 含税合同额
	@TableField(value = "contract_mny")
	private BigDecimal contractMny; // 不含税合同额
	@TableField(value = "start_date")
	private Date startDate; // 项目开工时间
	@TableField(value = "finish_date")
	private Date finishDate; // 项目完工时间
	@TableField(value = "address")
	private String address; // 施工地点
	@TableField(value = "establishment_org_id")
	private Long establishmentOrgId; // 编制单位ID
	@TableField(value = "establishment_org_name")
	private String establishmentOrgName; // 编制单位名称
	@TableField(value = "establishment_user_id")
	private Long establishmentUserId; // 编制人ID
	@TableField(value = "establishment_user_name")
	private String establishmentUserName; // 编制人名称
	@TableField(value = "establishment_date")
	private Date establishmentDate; // 编制日期
	@TableField(value = "construction_cost")
	private BigDecimal constructionCost; // 造价金额
	@TableField(value = "prjcost_total")
	private BigDecimal prjcostTotal; // 全部项目直接成本
	@TableField(value = "prjcost_gross_profit")
	private BigDecimal prjcostGrossProfit; // 项目毛利润
	@TableField(value = "prjcost_rate")
	private String prjcostRate; // 项目毛利率
	@TableField(value = "prjsale_cost")
	private BigDecimal prjsaleCost; // 工程部销售费用
	@TableField(value = "manage_cost")
	private BigDecimal manageCost; // 公司管理、销售费用等
	@TableField(value = "tax_cost")
	private BigDecimal taxCost; // 税金及附加
	@TableField(value = "prjcost_profit")
	private BigDecimal prjcostProfit; // 项目利润
	@TableField(value = "remark")
	private String remark; // 备注

	@TableField(exist = false)
	@SubEntity(serviceName = "prjcontractCostsDetailService", pidName="costsId")
	private List<PrjcontractCostsDetailEntity> prjcontractCostsDetailList = new ArrayList<>(); // 项目合同造价表明细


	public BigDecimal getConstructionCost() {
		return constructionCost;
	}

	public void setConstructionCost(BigDecimal constructionCost) {
		this.constructionCost = constructionCost;
	}
	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public Long getProjectDepartmentId() {
		return projectDepartmentId;
	}

	public void setProjectDepartmentId(Long projectDepartmentId) {
		this.projectDepartmentId = projectDepartmentId;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getPrebidId() {
		return prebidId;
	}

	public void setPrebidId(Long prebidId) {
		this.prebidId = prebidId;
	}

	public BigDecimal getPrebidCost() {
		return prebidCost;
	}

	public void setPrebidCost(BigDecimal prebidCost) {
		this.prebidCost = prebidCost;
	}

	public String getContractUnitName() {
		return contractUnitName;
	}

	public void setContractUnitName(String contractUnitName) {
		this.contractUnitName = contractUnitName;
	}

	public String getPubUnitName() {
		return pubUnitName;
	}

	public void setPubUnitName(String pubUnitName) {
		this.pubUnitName = pubUnitName;
	}

	public BigDecimal getContractTaxMny() {
		return contractTaxMny;
	}

	public void setContractTaxMny(BigDecimal contractTaxMny) {
		this.contractTaxMny = contractTaxMny;
	}

	public BigDecimal getContractMny() {
		return contractMny;
	}

	public void setContractMny(BigDecimal contractMny) {
		this.contractMny = contractMny;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getFinishDate() {
		return finishDate;
	}

	public void setFinishDate(Date finishDate) {
		this.finishDate = finishDate;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public Long getEstablishmentOrgId() {
		return establishmentOrgId;
	}

	public void setEstablishmentOrgId(Long establishmentOrgId) {
		this.establishmentOrgId = establishmentOrgId;
	}

	public String getEstablishmentOrgName() {
		return establishmentOrgName;
	}

	public void setEstablishmentOrgName(String establishmentOrgName) {
		this.establishmentOrgName = establishmentOrgName;
	}

	public Long getEstablishmentUserId() {
		return establishmentUserId;
	}

	public void setEstablishmentUserId(Long establishmentUserId) {
		this.establishmentUserId = establishmentUserId;
	}

	public String getEstablishmentUserName() {
		return establishmentUserName;
	}

	public void setEstablishmentUserName(String establishmentUserName) {
		this.establishmentUserName = establishmentUserName;
	}

	public Date getEstablishmentDate() {
		return establishmentDate;
	}

	public void setEstablishmentDate(Date establishmentDate) {
		this.establishmentDate = establishmentDate;
	}

	public BigDecimal getPrjcostTotal() {
		return prjcostTotal;
	}

	public void setPrjcostTotal(BigDecimal prjcostTotal) {
		this.prjcostTotal = prjcostTotal;
	}

	public BigDecimal getPrjcostGrossProfit() {
		return prjcostGrossProfit;
	}

	public void setPrjcostGrossProfit(BigDecimal prjcostGrossProfit) {
		this.prjcostGrossProfit = prjcostGrossProfit;
	}

	public String getPrjcostRate() {
		return prjcostRate;
	}

	public void setPrjcostRate(String prjcostRate) {
		this.prjcostRate = prjcostRate;
	}

	public BigDecimal getPrjsaleCost() {
		return prjsaleCost;
	}

	public void setPrjsaleCost(BigDecimal prjsaleCost) {
		this.prjsaleCost = prjsaleCost;
	}

	public BigDecimal getManageCost() {
		return manageCost;
	}

	public void setManageCost(BigDecimal manageCost) {
		this.manageCost = manageCost;
	}

	public BigDecimal getTaxCost() {
		return taxCost;
	}

	public void setTaxCost(BigDecimal taxCost) {
		this.taxCost = taxCost;
	}

	public BigDecimal getPrjcostProfit() {
		return prjcostProfit;
	}

	public void setPrjcostProfit(BigDecimal prjcostProfit) {
		this.prjcostProfit = prjcostProfit;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public List<PrjcontractCostsDetailEntity> getPrjcontractCostsDetailList() {
		return prjcontractCostsDetailList;
	}

	public void setPrjcontractCostsDetailList(List<PrjcontractCostsDetailEntity> prjcontractCostsDetailList) {
		this.prjcontractCostsDetailList = prjcontractCostsDetailList;
	}

	public String getProjectTargetcostIds() {
		return projectTargetcostIds;
	}

	public void setProjectTargetcostIds(String projectTargetcostIds) {
		this.projectTargetcostIds = projectTargetcostIds;
	}
}
