package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.PrjcontractCostsEntity;
import com.ejianc.business.cost.service.IPrjcontractCostsService;
import com.ejianc.business.cost.vo.PrjcontractCostsDetailVO;
import com.ejianc.business.cost.vo.PrjcontractCostsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目合同造价表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("prjcontractCosts")
public class PrjcontractCostsController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "zydxPrjcontractCosts";//此处需要根据实际修改

    @Autowired
    private IPrjcontractCostsService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PrjcontractCostsVO> saveOrUpdate(@RequestBody PrjcontractCostsVO saveOrUpdateVO) {
    	PrjcontractCostsEntity entity = BeanMapper.map(saveOrUpdateVO, PrjcontractCostsEntity.class);
        QueryWrapper checkWrapper = new QueryWrapper();
        checkWrapper.eq("project_id", entity.getProjectId());
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else{
            checkWrapper.ne("id", entity.getId());
        }
        List check = service.list(checkWrapper);
        if(check.size()>0){
            throw new BusinessException("项目【"+entity.getProjectName()+"】下已存在合同造价表");
        }

        if(entity.getPrjcontractCostsDetailList()!=null && entity.getPrjcontractCostsDetailList().size()>0){
            Map<String, Long> map = new HashMap<>();
            entity.getPrjcontractCostsDetailList().forEach(item -> {
                if("add".equals(item.getRowState())){
                    item.setId(IdWorker.getId());
                    item.setCostsId(entity.getId());
                }
                if(!"del".equals(item.getRowState())){
                    map.put(item.getCode(), item.getId());
                }
            });
            entity.getPrjcontractCostsDetailList().forEach(item -> {
                if("add".equals(item.getRowState()) && item.getCode().indexOf(".")!=-1){
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid(map.get(code));
                }
            });
        }
    	service.saveOrUpdate(entity, false);
    	PrjcontractCostsVO vo = BeanMapper.map(entity, PrjcontractCostsVO.class);

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getPrjcontractCostsDetailList())) {
            sortIntMethod(vo.getPrjcontractCostsDetailList());
            List<PrjcontractCostsDetailVO> detailVOS = createTreeData(vo.getPrjcontractCostsDetailList());
            vo.setPrjcontractCostsDetailList(detailVOS);
        }
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PrjcontractCostsVO> queryDetail(Long id) {
    	PrjcontractCostsEntity entity = service.selectById(id);
    	PrjcontractCostsVO vo = BeanMapper.map(entity, PrjcontractCostsVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getPrjcontractCostsDetailList())) {
            sortIntMethod(vo.getPrjcontractCostsDetailList());
            List<PrjcontractCostsDetailVO> detailVOS = createTreeData(vo.getPrjcontractCostsDetailList());
            vo.setPrjcontractCostsDetailList(detailVOS);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PrjcontractCostsVO> vos) {
        service.removeByIds(vos.stream().map(PrjcontractCostsVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PrjcontractCostsVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PrjcontractCostsEntity> page = service.queryPage(param,false);
        IPage<PrjcontractCostsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PrjcontractCostsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PrjcontractCostsEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PrjcontractCosts-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPrjcontractCostsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PrjcontractCostsVO>> refPrjcontractCostsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);

        }

        IPage<PrjcontractCostsEntity> page = service.queryPage(param,false);
        IPage<PrjcontractCostsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PrjcontractCostsVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    private static void sortIntMethod(List<PrjcontractCostsDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                PrjcontractCostsDetailVO o1Detail = objectMapper.convertValue(o1, PrjcontractCostsDetailVO.class);
                PrjcontractCostsDetailVO o2Detail = objectMapper.convertValue(o2, PrjcontractCostsDetailVO.class);
                String[] strs1 = o1Detail.getCode().split("\\.");
                String[] strs2 = o2Detail.getCode().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }

    public static List<PrjcontractCostsDetailVO> createTreeData(List<PrjcontractCostsDetailVO> list) {
        List<PrjcontractCostsDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, PrjcontractCostsDetailVO> listMap = new HashMap<>();
        for(PrjcontractCostsDetailVO item:list) {
            listMap.put(item.getId().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            PrjcontractCostsDetailVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            PrjcontractCostsDetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<PrjcontractCostsDetailVO> child = (List<PrjcontractCostsDetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<PrjcontractCostsDetailVO> children = new ArrayList<PrjcontractCostsDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

}
