package com.ejianc.business.income.vo;

import com.ejianc.framework.core.util.ComputeUtil;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @description:
 * @author songlx
 * @date 2023/11/9
 * @version 1.0
 */
public class TableRowDataVO implements Serializable {

    //利润表
    public static Map<Integer, String> PROFIT_FEE_TYPE_MAP = new LinkedHashMap<>();

    //现金表
    public static Map<Integer, String> CASH_FEE_TYPE_MAP = new LinkedHashMap<>();

    static {
        PROFIT_FEE_TYPE_MAP.put(101, "实际完成产值");
        PROFIT_FEE_TYPE_MAP.put(102, "废品收入");
        PROFIT_FEE_TYPE_MAP.put(103, "分包安全文明押金");
        PROFIT_FEE_TYPE_MAP.put(104, "代收水电费");
        PROFIT_FEE_TYPE_MAP.put(105, "其它收入");
        PROFIT_FEE_TYPE_MAP.put(199, "收入小计");
        PROFIT_FEE_TYPE_MAP.put(201, "材料费");
        PROFIT_FEE_TYPE_MAP.put(202, "劳务费");
        PROFIT_FEE_TYPE_MAP.put(203, "专业分包费");
        PROFIT_FEE_TYPE_MAP.put(204, "机械费");
        PROFIT_FEE_TYPE_MAP.put(205, "措施项目费");
        PROFIT_FEE_TYPE_MAP.put(206, "管理费用");
        PROFIT_FEE_TYPE_MAP.put(207, "平台管理费");
        PROFIT_FEE_TYPE_MAP.put(208, "税金");
        PROFIT_FEE_TYPE_MAP.put(209, "资金利息");
        PROFIT_FEE_TYPE_MAP.put(210, "其它费用");
        PROFIT_FEE_TYPE_MAP.put(299, "成本小计");
        PROFIT_FEE_TYPE_MAP.put(301, "利润");


        CASH_FEE_TYPE_MAP.put(106, "上期余额");
        CASH_FEE_TYPE_MAP.put(107, "工程款收入");
        CASH_FEE_TYPE_MAP.put(102, "废品收入");
        CASH_FEE_TYPE_MAP.put(108, "履约保证金收入");
        CASH_FEE_TYPE_MAP.put(103, "分包安全文明押金");
        CASH_FEE_TYPE_MAP.put(104, "代收水电费");
        CASH_FEE_TYPE_MAP.put(109, "往来款收入");
        CASH_FEE_TYPE_MAP.put(105, "其它收入");
        CASH_FEE_TYPE_MAP.put(199, "经营活动流入小计");
        CASH_FEE_TYPE_MAP.put(201, "材料费");
        CASH_FEE_TYPE_MAP.put(202, "劳务费");
        CASH_FEE_TYPE_MAP.put(203, "专业分包费");
        CASH_FEE_TYPE_MAP.put(204, "机械费");
        CASH_FEE_TYPE_MAP.put(205, "措施项目费");
        CASH_FEE_TYPE_MAP.put(206, "管理费用");
        CASH_FEE_TYPE_MAP.put(207, "平台管理费");
        CASH_FEE_TYPE_MAP.put(208, "税金");
        CASH_FEE_TYPE_MAP.put(209, "资金利息");
        CASH_FEE_TYPE_MAP.put(210, "其它费用");
        CASH_FEE_TYPE_MAP.put(299, "经营活动流出小计");
        CASH_FEE_TYPE_MAP.put(301, "经营活动产生的现金流量净额");
    }


    private Integer feeType;

    private String feeTypeName;

    private BigDecimal taxMny0;
    private BigDecimal mny0;
    private BigDecimal tax0;
    private BigDecimal taxMny1;
    private BigDecimal mny1;
    private BigDecimal tax1;
    private BigDecimal taxMny2;
    private BigDecimal mny2;
    private BigDecimal tax2;
    private BigDecimal taxMny3;
    private BigDecimal mny3;
    private BigDecimal tax3;
    private BigDecimal taxMny4;
    private BigDecimal mny4;
    private BigDecimal tax4;
    private BigDecimal taxMny5;
    private BigDecimal mny5;
    private BigDecimal tax5;
    private BigDecimal taxMny6;
    private BigDecimal mny6;
    private BigDecimal tax6;
    private BigDecimal taxMny7;
    private BigDecimal mny7;
    private BigDecimal tax7;
    private BigDecimal taxMny8;
    private BigDecimal mny8;
    private BigDecimal tax8;
    private BigDecimal taxMny9;
    private BigDecimal mny9;
    private BigDecimal tax9;
    private BigDecimal taxMny10;
    private BigDecimal mny10;
    private BigDecimal tax10;
    private BigDecimal taxMny11;
    private BigDecimal mny11;
    private BigDecimal tax11;
    private BigDecimal taxMny12;
    private BigDecimal mny12;
    private BigDecimal tax12;

    //利润表-合计
    private BigDecimal taxMnyTotal;
    private BigDecimal mnyTotal;
    private BigDecimal taxTotal;



    //资金表
    //年累数
    private BigDecimal yearTotal;
    //开累数
    private BigDecimal startTotal;

    public Integer getFeeType() {
        return feeType;
    }

    public void setFeeType(Integer feeType, Map<Integer, String> map) {
        this.feeType = feeType;
        this.feeTypeName = map.get(feeType);
    }

    public String getFeeTypeName() {
        return feeTypeName;
    }

    public void setFeeTypeName(String feeTypeName) {
        this.feeTypeName = feeTypeName;
    }

    public BigDecimal getTaxMny0() {
        return taxMny0;
    }

    public void setTaxMny0(BigDecimal taxMny0) {
        this.taxMny0 = taxMny0;
    }

    public BigDecimal getMny0() {
        return mny0;
    }

    public void setMny0(BigDecimal mny0) {
        this.mny0 = mny0;
    }

    public BigDecimal getTax0() {
        return tax0;
    }

    public void setTax0(BigDecimal tax0) {
        this.tax0 = tax0;
    }

    public BigDecimal getTaxMny1() {
        return taxMny1;
    }

    public void setTaxMny1(BigDecimal taxMny1) {
        this.taxMny1 = taxMny1;
    }

    public BigDecimal getMny1() {
        return mny1;
    }

    public void setMny1(BigDecimal mny1) {
        this.mny1 = mny1;
    }

    public BigDecimal getTax1() {
        return tax1;
    }

    public void setTax1(BigDecimal tax1) {
        this.tax1 = tax1;
    }

    public BigDecimal getTaxMny2() {
        return taxMny2;
    }

    public void setTaxMny2(BigDecimal taxMny2) {
        this.taxMny2 = taxMny2;
    }

    public BigDecimal getMny2() {
        return mny2;
    }

    public void setMny2(BigDecimal mny2) {
        this.mny2 = mny2;
    }

    public BigDecimal getTax2() {
        return tax2;
    }

    public void setTax2(BigDecimal tax2) {
        this.tax2 = tax2;
    }

    public BigDecimal getTaxMny3() {
        return taxMny3;
    }

    public void setTaxMny3(BigDecimal taxMny3) {
        this.taxMny3 = taxMny3;
    }

    public BigDecimal getMny3() {
        return mny3;
    }

    public void setMny3(BigDecimal mny3) {
        this.mny3 = mny3;
    }

    public BigDecimal getTax3() {
        return tax3;
    }

    public void setTax3(BigDecimal tax3) {
        this.tax3 = tax3;
    }

    public BigDecimal getTaxMny4() {
        return taxMny4;
    }

    public void setTaxMny4(BigDecimal taxMny4) {
        this.taxMny4 = taxMny4;
    }

    public BigDecimal getMny4() {
        return mny4;
    }

    public void setMny4(BigDecimal mny4) {
        this.mny4 = mny4;
    }

    public BigDecimal getTax4() {
        return tax4;
    }

    public void setTax4(BigDecimal tax4) {
        this.tax4 = tax4;
    }

    public BigDecimal getTaxMny5() {
        return taxMny5;
    }

    public void setTaxMny5(BigDecimal taxMny5) {
        this.taxMny5 = taxMny5;
    }

    public BigDecimal getMny5() {
        return mny5;
    }

    public void setMny5(BigDecimal mny5) {
        this.mny5 = mny5;
    }

    public BigDecimal getTax5() {
        return tax5;
    }

    public void setTax5(BigDecimal tax5) {
        this.tax5 = tax5;
    }

    public BigDecimal getTaxMny6() {
        return taxMny6;
    }

    public void setTaxMny6(BigDecimal taxMny6) {
        this.taxMny6 = taxMny6;
    }

    public BigDecimal getMny6() {
        return mny6;
    }

    public void setMny6(BigDecimal mny6) {
        this.mny6 = mny6;
    }

    public BigDecimal getTax6() {
        return tax6;
    }

    public void setTax6(BigDecimal tax6) {
        this.tax6 = tax6;
    }

    public BigDecimal getTaxMny7() {
        return taxMny7;
    }

    public void setTaxMny7(BigDecimal taxMny7) {
        this.taxMny7 = taxMny7;
    }

    public BigDecimal getMny7() {
        return mny7;
    }

    public void setMny7(BigDecimal mny7) {
        this.mny7 = mny7;
    }

    public BigDecimal getTax7() {
        return tax7;
    }

    public void setTax7(BigDecimal tax7) {
        this.tax7 = tax7;
    }

    public BigDecimal getTaxMny8() {
        return taxMny8;
    }

    public void setTaxMny8(BigDecimal taxMny8) {
        this.taxMny8 = taxMny8;
    }

    public BigDecimal getMny8() {
        return mny8;
    }

    public void setMny8(BigDecimal mny8) {
        this.mny8 = mny8;
    }

    public BigDecimal getTax8() {
        return tax8;
    }

    public void setTax8(BigDecimal tax8) {
        this.tax8 = tax8;
    }

    public BigDecimal getTaxMny9() {
        return taxMny9;
    }

    public void setTaxMny9(BigDecimal taxMny9) {
        this.taxMny9 = taxMny9;
    }

    public BigDecimal getMny9() {
        return mny9;
    }

    public void setMny9(BigDecimal mny9) {
        this.mny9 = mny9;
    }

    public BigDecimal getTax9() {
        return tax9;
    }

    public void setTax9(BigDecimal tax9) {
        this.tax9 = tax9;
    }

    public BigDecimal getTaxMny10() {
        return taxMny10;
    }

    public void setTaxMny10(BigDecimal taxMny10) {
        this.taxMny10 = taxMny10;
    }

    public BigDecimal getMny10() {
        return mny10;
    }

    public void setMny10(BigDecimal mny10) {
        this.mny10 = mny10;
    }

    public BigDecimal getTax10() {
        return tax10;
    }

    public void setTax10(BigDecimal tax10) {
        this.tax10 = tax10;
    }

    public BigDecimal getTaxMny11() {
        return taxMny11;
    }

    public void setTaxMny11(BigDecimal taxMny11) {
        this.taxMny11 = taxMny11;
    }

    public BigDecimal getMny11() {
        return mny11;
    }

    public void setMny11(BigDecimal mny11) {
        this.mny11 = mny11;
    }

    public BigDecimal getTax11() {
        return tax11;
    }

    public void setTax11(BigDecimal tax11) {
        this.tax11 = tax11;
    }

    public BigDecimal getTaxMny12() {
        return taxMny12;
    }

    public void setTaxMny12(BigDecimal taxMny12) {
        this.taxMny12 = taxMny12;
    }

    public BigDecimal getMny12() {
        return mny12;
    }

    public void setMny12(BigDecimal mny12) {
        this.mny12 = mny12;
    }

    public BigDecimal getTax12() {
        return tax12;
    }

    public void setTax12(BigDecimal tax12) {
        this.tax12 = tax12;
    }


    public BigDecimal getTaxMnyTotal() {
        return taxMnyTotal;
    }

    public void setTaxMnyTotal(BigDecimal taxMnyTotal) {
        this.taxMnyTotal = taxMnyTotal;
    }

    public BigDecimal getMnyTotal() {
        return mnyTotal;
    }

    public void setMnyTotal(BigDecimal mnyTotal) {
        this.mnyTotal = mnyTotal;
    }

    public BigDecimal getTaxTotal() {
        return taxTotal;
    }

    public void setTaxTotal(BigDecimal taxTotal) {
        this.taxTotal = taxTotal;
    }

    public BigDecimal getYearTotal() {
        return yearTotal;
    }

    public void setYearTotal(BigDecimal yearTotal) {
        this.yearTotal = yearTotal;
    }

    public BigDecimal getStartTotal() {
        return startTotal;
    }

    public void setStartTotal(BigDecimal startTotal) {
        this.startTotal = startTotal;
    }

    public TableRowDataVO sumTotal() {
        this.taxMnyTotal = ComputeUtil.safeAdd(this.taxMny0, this.taxMny1, this.taxMny2, this.taxMny3, this.taxMny4, this.taxMny5, this.taxMny6, this.taxMny7, this.taxMny8, this.taxMny9, this.taxMny10, this.taxMny11, this.taxMny12);
        this.mnyTotal = ComputeUtil.safeAdd(this.mny0, this.mny1, this.mny2, this.mny3, this.mny4, this.mny5, this.mny6, this.mny7, this.mny8, this.mny9, this.mny10, this.mny11, this.mny12);
        this.taxTotal = ComputeUtil.safeAdd(this.tax0, this.tax1, this.tax2, this.tax3, this.tax4, this.tax5, this.tax6, this.tax7, this.tax8, this.tax9, this.tax10, this.tax11, this.tax12);
        return this;
    }

    public TableRowDataVO sumYearTotalAndStartTotal() {
        //上期余额、经营活动产生的现金流量净额不需要年累和开累吧，没什么意义
        if (!Integer.valueOf(106).equals(this.feeType) && !Integer.valueOf(301).equals(this.feeType)) {
            this.yearTotal = ComputeUtil.safeAdd(this.taxMny1, this.taxMny2, this.taxMny3, this.taxMny4, this.taxMny5, this.taxMny6, this.taxMny7, this.taxMny8, this.taxMny9, this.taxMny10, this.taxMny11, this.taxMny12);
            this.startTotal = ComputeUtil.safeAdd(this.taxMny0, this.taxMny1, this.taxMny2, this.taxMny3, this.taxMny4, this.taxMny5, this.taxMny6, this.taxMny7, this.taxMny8, this.taxMny9, this.taxMny10, this.taxMny11, this.taxMny12);
        }
        return this;
    }


}
