package com.ejianc.business.labprice.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labprice.vo.LaborPicketageVO;
import com.ejianc.business.othprice.bean.PicketageEntity;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.labprice.bean.LaborPicketageEntity;

/**
 * 定标
 * 
 * @author generator
 * 
 */
public interface ILaborPicketageService extends IBaseService<LaborPicketageEntity> {

    boolean insertOrUpdate(LaborPicketageEntity entity);

    boolean insertOrUpdateRef(LaborPicketageEntity entity);

    void  checkRefSave(LaborPicketageEntity entity);
    void pushPicketage(Long billId);

    void rollBackPicketage(Long billId);

    /**
     *  根据询价单 id 查询 询价清单 和报价记录
     * @param inquiryId
     * @return 询价清单--{purchaseList、rentList} 报价记录--{quoteList} 清单数量统计--{totalMap}
     */
    CommonResponse<JSONObject> queryByInquiryToDetailAndQuote(String inquiryId);

    LaborPicketageVO queryMaterialPicketageDetail(Long id);

    LaborPicketageVO queryMaterialPriceArea(LaborPicketageVO vo);
    void sendMsg(Long id);

    JSONObject queryDetailToRef(Long id);
}
