package com.ejianc.business.sub.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.sub.bean.SubContractEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISubFinishService;
import com.ejianc.business.sub.vo.SubFinishRecordVO;
import com.ejianc.business.sub.vo.SubFinishVO;
import com.ejianc.business.sub.vo.SubParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 分包完工结算表 前端控制器
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@RestController
@RequestMapping("subFinish")
public class SubFinishController implements Serializable {

    @Autowired
    private IContractService contractService;

    @Autowired
    private ISubFinishService finishService;

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增或者修改
     * @param finishVO
     * @Return com.ejianc.framework.core.response.CommonResponse<FinishVO>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubFinishVO> saveOrUpdate(@RequestBody SubFinishVO finishVO) {
        SubFinishVO vo = finishService.insertOrUpdate(finishVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询变更记录详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<FinishVO>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubFinishVO> queryDetail(Long id) {
        SubFinishVO vo = finishService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @description: 查询打印数据
     *
     * @param id
     * @return {@link CommonResponse< JSONObject>}
     * @author songlx
     * @date: 2024/3/20
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        CommonResponse<SubFinishVO> response = this.queryDetail(id);
        SubFinishVO finishVO = response.getData();
        finishVO.setFinishDetail(finishVO.getFinishDetailList());
        finishVO.setPaidMoney(ComputeUtil.nullToZero(finishVO.getPaidMoney()));
        finishVO.setUnPaidMoney(ComputeUtil.nullToZero(finishVO.getUnPaidMoney()));

        JSONObject vo = (JSONObject) JSONObject.toJSON(finishVO);
        Long contractId = finishVO.getContractId();
        SubContractEntity contractEntity = contractService.getById(contractId);
        vo.put("contractId", contractEntity);
        json.put("Finish", vo);
        return CommonResponse.success("查询打印数据成功！", json);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubFinishVO>> queryList(@RequestBody QueryParam param) {
        return finishService.queryListVOs(param);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubFinishVO> vos) {
        return finishService.deleteByIds(vos);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description queryDetailRecord 查询记录
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<FinishRecordVO>
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubFinishRecordVO> queryDetailRecord(Long id) {
        SubFinishRecordVO vo = finishService.queryDetailRecord(id);
        return CommonResponse.success("查询记录数据成功！", vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description queryDetailAdd 新增查询合同转化为完工结算
     * @param contractId
     * @Return com.ejianc.framework.core.response.CommonResponse<FinishVO>
     */
    @RequestMapping(value = "/queryDetailAdd", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubFinishVO> queryDetailAdd(Long contractId) {
        SubFinishVO vo = finishService.queryDetailAdd(contractId);
        return CommonResponse.success("新增查询合同转化为完工结算成功！", vo);
    }

    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<SubFinishVO> list = finishService.queryExportList(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("sub-finish-export.xlsx", beans, response);
    }

    /*
     *
     * @description:
     * @author: 曹鹏辉
     * @date: 2021/5/20 17:52
     * @param: purchaseType
     * @param: settleTaxMny
     * @param: contractTaxMny
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.finance.vo.ParamsCheckVO>
     */
    @RequestMapping(value = "/checkParams", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubParamsCheckVO> checkParams(@RequestParam(value = "purchaseType") Integer purchaseType
            , @RequestParam(value = "settleTaxMny") BigDecimal settleTaxMny
            , @RequestParam(value = "contractTaxMny") BigDecimal contractTaxMny
            , @RequestParam(value = "orgId") Long orgId) {

        return CommonResponse.success("参数校验成功！", finishService.checkParams(purchaseType, settleTaxMny, contractTaxMny, orgId));
    }


}
