/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.ProjectTaskBookEntity;
import com.ejianc.business.cost.service.IProjectTaskBookDetailService;
import com.ejianc.business.cost.service.IProjectTaskBookService;
import com.ejianc.business.cost.vo.ProjectTaskBookDetailVO;
import com.ejianc.business.cost.vo.ProjectTaskBookVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectTaskBook"})
public class ProjectTaskBookController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "zydxProjectTaskBook";
    @Autowired
    private IProjectTaskBookService service;
    @Autowired
    private IProjectTaskBookDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectTaskBookVO> saveOrUpdate(@RequestBody ProjectTaskBookVO saveOrUpdateVO) {
        ProjectTaskBookEntity entity = (ProjectTaskBookEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ProjectTaskBookEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getProjectTaskBookDetailList() != null && entity.getProjectTaskBookDetailList().size() > 0) {
            HashMap map = new HashMap();
            entity.getProjectTaskBookDetailList().forEach(item -> {
                if ("add".equals(item.getRowState())) {
                    item.setId(IdWorker.getId());
                    item.setTaskbookId(entity.getId());
                }
                if (!"del".equals(item.getRowState())) {
                    map.put(item.getCode(), item.getId());
                }
            });
            entity.getProjectTaskBookDetailList().forEach(item -> {
                if ("add".equals(item.getRowState()) && item.getCode().indexOf(".") != -1) {
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid((Long)map.get(code));
                }
            });
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectTaskBookVO vo = (ProjectTaskBookVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectTaskBookVO.class));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getProjectTaskBookDetailList())) {
            ProjectTaskBookController.sortIntMethod(vo.getProjectTaskBookDetailList());
            List<ProjectTaskBookDetailVO> detailVOS = ProjectTaskBookController.createTreeData(vo.getProjectTaskBookDetailList());
            vo.setProjectTaskBookDetailList(detailVOS);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectTaskBookVO> queryDetail(Long id) {
        ProjectTaskBookEntity entity = (ProjectTaskBookEntity)((Object)this.service.selectById(id));
        ProjectTaskBookVO vo = (ProjectTaskBookVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectTaskBookVO.class));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getProjectTaskBookDetailList())) {
            ProjectTaskBookController.sortIntMethod(vo.getProjectTaskBookDetailList());
            List<ProjectTaskBookDetailVO> detailVOS = ProjectTaskBookController.createTreeData(vo.getProjectTaskBookDetailList());
            vo.setProjectTaskBookDetailList(detailVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail4ProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectTaskBookVO> queryDetail4ProjectId(Long projectId) {
        ProjectTaskBookVO vo = new ProjectTaskBookVO();
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(ProjectTaskBookEntity::getProjectId, (Object)projectId)).eq(BaseEntity::getDr, (Object)0)).orderByDesc(BaseEntity::getCreateTime)).in(ProjectTaskBookEntity::getBillState, Arrays.asList(1, 3));
        List list = this.service.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo = (ProjectTaskBookVO)((Object)BeanMapper.map(list.get(0), ProjectTaskBookVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectTaskBookVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectTaskBookVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectTaskBookVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectTaskBook-export.xlsx", beans, response);
    }

    private static void sortIntMethod(List<ProjectTaskBookDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                ProjectTaskBookDetailVO o1Detail = (ProjectTaskBookDetailVO)((Object)objectMapper.convertValue(o1, ProjectTaskBookDetailVO.class));
                ProjectTaskBookDetailVO o2Detail = (ProjectTaskBookDetailVO)((Object)objectMapper.convertValue(o2, ProjectTaskBookDetailVO.class));
                String[] strs1 = o1Detail.getCode().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getCode().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    public static List<ProjectTaskBookDetailVO> createTreeData(List<ProjectTaskBookDetailVO> list) {
        ArrayList<ProjectTaskBookDetailVO> resp = new ArrayList<ProjectTaskBookDetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ProjectTaskBookDetailVO> listMap = new HashMap<String, ProjectTaskBookDetailVO>();
        for (ProjectTaskBookDetailVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            ProjectTaskBookDetailVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            ProjectTaskBookDetailVO parent = (ProjectTaskBookDetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<ProjectTaskBookDetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<ProjectTaskBookDetailVO> children = new ArrayList<ProjectTaskBookDetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((ProjectTaskBookDetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/refProjectTaskBookData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectTaskBookVO>> refProjectTaskBookData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectTaskBookVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refProjectTaskBookDataTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProjectTaskBookVO> refProjectTaskBookDataTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Boolean productionFlag = false;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"projectId") != null) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.get((Object)"productionFlag") != null) {
                productionFlag = true;
            }
        }
        List page = this.service.queryList(param, false);
        ArrayList<ProjectTaskBookVO> list = new ArrayList<ProjectTaskBookVO>();
        List<Object> haveSurNumIds = new ArrayList();
        if (productionFlag.booleanValue() && CollectionUtils.isNotEmpty((Collection)page)) {
            QueryParam queryApplySubParam = new QueryParam();
            queryApplySubParam.getParams().put("taskbookId", new Parameter("in", page.stream().map(BaseEntity::getId).collect(Collectors.toList())));
            queryApplySubParam.getParams().put("sql", new Parameter("sql", (Object)" id not in (SELECT d.pid FROM ejc_zypms_cost_project_task_book_detail d where d.dr = 0 and d.pid is not null)"));
            List<ProjectTaskBookDetailVO> detailList = this.service.queryApplySubCount(queryApplySubParam);
            haveSurNumIds = detailList.stream().map(ProjectTaskBookDetailVO::getTaskbookId).collect(Collectors.toList());
        }
        if (page != null && page.size() > 0) {
            for (ProjectTaskBookEntity entity : page) {
                if (productionFlag.booleanValue() && !haveSurNumIds.contains(entity.getId())) continue;
                ProjectTaskBookVO vo = (ProjectTaskBookVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectTaskBookVO.class));
                vo.setProduceContent(null);
                vo.setQualityContent(null);
                vo.setSafeContent(null);
                vo.setCostConent(null);
                vo.setOtherContent(null);
                vo.setRemark(null);
                list.add(vo);
            }
        }
        return list;
    }

    @RequestMapping(value={"/refProjectTaskBookDataDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectTaskBookDetailVO>> refProjectTaskBookDataDetail(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String relyNode, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        Object projectTaskBookId;
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<Object> haveSurNumIds = new ArrayList();
        Boolean productionFlag = false;
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            JSONObject _con;
            projectTaskBookId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("taskbookId", new Parameter("eq", projectTaskBookId));
            if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"productionFlag") != null) {
                productionFlag = true;
            }
            if (productionFlag.booleanValue()) {
                QueryParam queryApplySubParam = new QueryParam();
                queryApplySubParam.getParams().put("taskbookId", new Parameter("eq", projectTaskBookId));
                queryApplySubParam.getParams().put("detailsql", new Parameter("sql", (Object)" id not in (SELECT d.pid FROM ejc_zypms_cost_project_task_book_detail d where d.dr = 0 and d.pid is not null)"));
                List<ProjectTaskBookDetailVO> detailList = this.service.queryApplySubCount(queryApplySubParam);
                haveSurNumIds = detailList.stream().map(BaseVO::getId).collect(Collectors.toList());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            projectTaskBookId = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("sql", new Parameter("sql", (Object)" id not in (SELECT d.pid FROM ejc_zypms_cost_project_task_book_detail d where d.dr = 0 and d.pid is not null)"));
        if (productionFlag.booleanValue()) {
            param.getParams().put("id", new Parameter("in", haveSurNumIds));
        }
        IPage page = this.detailService.queryPage(param, false);
        List detailVOS = new ArrayList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            detailVOS = BeanMapper.mapList((Iterable)page.getRecords(), ProjectTaskBookDetailVO.class);
            for (ProjectTaskBookDetailVO vo : detailVOS) {
                vo.setChildren(null);
            }
        }
        Page pageData = new Page((long)pageNumber, (long)pageSize, page.getTotal());
        pageData.setRecords(detailVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

