/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.OutProductionEntity;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IOutProductionService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outProduction")
public class OutProductionBpmService
implements ICommonBusinessService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IOutProductionService productionService;
    @Autowired
    private IClaimService claimService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutProductionEntity productionEntity = (OutProductionEntity)((Object)this.productionService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(productionEntity.getContractId()));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.select(new String[]{"IFNULL(sum(finish_tax_mny),0) as sumFinishTaxMny, IFNULL(sum(finish_mny),0) as sumFinishMny"}).eq((Object)"contract_id", (Object)productionEntity.getContractId())).in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()))).ne((Object)"id", (Object)billId);
        Map map = this.productionService.getMap((Wrapper)queryWrapper);
        BigDecimal sumFinishTaxMny = ComputeUtil.toBigDecimal(map.get("sumFinishTaxMny"));
        BigDecimal sumFinishMny = ComputeUtil.toBigDecimal(map.get("sumFinishMny"));
        contractEntity.setSumProductionTaxMny(ComputeUtil.safeAdd((BigDecimal)sumFinishTaxMny, (BigDecimal)productionEntity.getFinishTaxMny()));
        contractEntity.setSumProductionMny(ComputeUtil.safeAdd((BigDecimal)sumFinishMny, (BigDecimal)productionEntity.getFinishMny()));
        this.contractService.updateById((Object)contractEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutProductionEntity productionEntity = (OutProductionEntity)((Object)this.productionService.selectById(billId));
        if (productionEntity == null) {
            return CommonResponse.error((String)"\u8be5\u4ea7\u503c\u8fdb\u5ea6\u5355\u4e0d\u5b58\u5728\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(OutProductionEntity::getContractId, (Object)productionEntity.getContractId());
        queryWrapper.gt(BaseEntity::getCreateTime, (Object)productionEntity.getCreateTime());
        List productionEntities = this.productionService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)productionEntities)) {
            return CommonResponse.error((String)("\u8be5\u4ea7\u503c\u8fdb\u5ea6\u5355\u5b58\u5728\u540c\u4e00\u5408\u540c\u4e0b\u7f16\u53f7\u4e3a\u3010" + ((OutProductionEntity)((Object)productionEntities.get(0))).getBillCode() + "\u3011\u7684\u540e\u7eed\u5355\u636e\uff0c\u65e0\u6cd5\u64a4\u56de\uff01"));
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            this.callBackProduction(billId, state, billTypeCode);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    private void callBackProduction(Long billId, Integer state, String billTypeCode) {
        OutProductionEntity productionEntity = (OutProductionEntity)((Object)this.productionService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(productionEntity.getContractId()));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.select(new String[]{"IFNULL(sum(finish_tax_mny),0) as sumFinishTaxMny, IFNULL(sum(finish_mny),0) as sumFinishMny"}).eq((Object)"contract_id", (Object)productionEntity.getContractId())).in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()))).ne((Object)"id", (Object)billId);
        Map map = this.productionService.getMap((Wrapper)queryWrapper);
        BigDecimal sumFinishTaxMny = ComputeUtil.toBigDecimal(map.get("sumFinishTaxMny"));
        BigDecimal sumFinishMny = ComputeUtil.toBigDecimal(map.get("sumFinishMny"));
        contractEntity.setSumProductionTaxMny(sumFinishTaxMny);
        contractEntity.setSumProductionMny(sumFinishMny);
        this.contractService.updateById((Object)contractEntity);
    }
}

