/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageService;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.material.bean.MaterialContractDetailSubEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.MaterialContractOtherCostSubEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.business.utils.ListSplitUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="materialService")
public class MaterialContractServiceImpl
extends BaseServiceImpl<MaterialContractMapper, MaterialContractEntity>
implements IMaterialContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String DEFAULT_RULE_CODE = "zydx_materialContract";
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IContractService contractService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Autowired
    private IMaterialPicketageService picketageService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PARAM_TOTAL_MNY = "P-t58ih142";
    private static final String PARAM_NUM = "P-uFOcn644";
    private static final String PARAM_TAX_MNY = "P-14dTg745";
    private static String PARAM_PLAN_COUNT = "P-8N9Au207";
    private static String PARAM_PLAN_PRICE = "P-2Ux27w08";
    private static String PARAM_PRICE_AREA = "P-126hYD10";

    @Override
    public List<MaterialContractVO> queryContractTaxWarnContract(List<SqlParam> sqlParamList) {
        ArrayList<MaterialContractVO> result = new ArrayList<MaterialContractVO>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(this.materialContractMapper.queryContractTaxWarnContract(list));
        }
        return result;
    }

    @Override
    public MaterialContractVO save(MaterialContractVO materialContractVO) {
        boolean b;
        MaterialContractEntity saveEntity = null;
        UserContext userContext = this.sessionManager.getUserContext();
        materialContractVO.setBaseMoney(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBaseTaxMoney(materialContractVO.getAmountWithTax());
        materialContractVO.setBeforeChangeMny(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBeforeChangeTaxMny(materialContractVO.getAmountWithTax());
        BigDecimal totalAmountWith = new BigDecimal(0).setScale(8, 4);
        if (null != materialContractVO.getId()) {
            MaterialContractEntity dbEntity = (MaterialContractEntity)((Object)super.selectById((Serializable)materialContractVO.getId()));
            saveEntity = (MaterialContractEntity)((Object)BeanMapper.map((Object)((Object)materialContractVO), MaterialContractEntity.class));
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setCreateUserName(dbEntity.getCreateUserName());
            saveEntity.setModifyUserName(userContext.getUserName());
        } else {
            materialContractVO.setCreateUserName(userContext.getUserName());
            materialContractVO.setChangeVersion(1);
            materialContractVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            materialContractVO.setChangeState(MaterialContractVO.CONTRACT_CHANGE_STATE_UNCHANGED);
            saveEntity = (MaterialContractEntity)((Object)BeanMapper.map((Object)((Object)materialContractVO), MaterialContractEntity.class));
        }
        if (CollectionUtils.isNotEmpty(saveEntity.getMaterialDetailList())) {
            totalAmountWith = totalAmountWith.add(saveEntity.getMaterialDetailList().stream().filter(detail -> !"del".equals(detail.getRowState()) && null != detail.getTotalAmount()).map(MaterialContractDetailSubEntity::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty(saveEntity.getOtherCostList())) {
            totalAmountWith = totalAmountWith.add(saveEntity.getOtherCostList().stream().filter(cost -> !"del".equals(cost.getRowState()) && null != cost.getCostAmount()).map(MaterialContractOtherCostSubEntity::getCostAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            saveEntity.getOtherCostList().stream().filter(cost -> null == cost.getCostAmount()).forEach(cost -> cost.setCostAmount(new BigDecimal(0)));
        }
        if (b = super.saveOrUpdate((Object)saveEntity, false)) {
            this.countContractNumAndMnyByEnquiry(saveEntity.getEnquiryPriceBillId());
        }
        return (MaterialContractVO)((Object)BeanMapper.map((Object)((Object)saveEntity), MaterialContractVO.class));
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_tax_money) as originalAmount, sum(amount_with_tax) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("originalAmount", 0);
            resp.put("curAmount", 0);
        }
        return resp;
    }

    @Override
    public boolean codeCheck(Long id, String code) {
        QueryParam check = new QueryParam();
        if (id != null) {
            check.getParams().put("id", new Parameter("ne", (Object)id));
        }
        check.getParams().put("code", new Parameter("eq", (Object)code));
        check.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List contractEntityList = super.queryList(check, false);
        if (CollectionUtils.isNotEmpty((Collection)contractEntityList)) {
            return false;
        }
        check.getParams().remove("id");
        check.getParams().put("material_contract_id", new Parameter("ne", (Object)id));
        check.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.PASSED_STATE.getBillStateCode()));
        List changeList = this.contractChangeService.queryList(check, false);
        return !CollectionUtils.isNotEmpty((Collection)changeList);
    }

    @Override
    public void checkContract(Long id) {
        MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)super.selectById((Serializable)id));
        if (contractEntity == null) {
            throw new BusinessException("\u6240\u9009\u5408\u540c\u4e0d\u5b58\u5728\uff01");
        }
        if (contractEntity.getBillState() != 1 && contractEntity.getBillState() != 3) {
            throw new BusinessException("\u6240\u9009\u5408\u540c\u672a\u751f\u6548\uff01");
        }
    }

    @Override
    public List<Map<String, Object>> queryAllWarnContracts(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(this.materialContractMapper.queryAllWarnContracts(list));
        }
        return result;
    }

    @Override
    public List<MaterialWarnVo> materialProjectOutMny(List<Long> tenantIds) {
        return ((MaterialContractMapper)this.baseMapper).materialProjectOutMny(tenantIds);
    }

    @Override
    public List<MaterialReportVo> getMonthMaterialMny(Long projectId, Integer lastDay) {
        return ((MaterialContractMapper)this.baseMapper).getMonthMaterialMny(projectId, lastDay);
    }

    @Override
    public MaterialReportVo getMaterialContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal settleMny = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(MaterialContractEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(MaterialContractEntity::getBillState, billStatus);
        List quoteEntities = super.list((Wrapper)lambda);
        for (MaterialContractEntity ce : quoteEntities) {
            mny = mny.add(ce.getAmountWithTax() == null ? BigDecimal.ZERO : ce.getAmountWithTax());
        }
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(PurchaseSettlementEntity::getProjectId, (Object)projectId);
        lambda2.eq(BaseEntity::getDr, (Object)0);
        lambda2.in(PurchaseSettlementEntity::getBillState, billStatus);
        List purchaseSettlementEntities = this.purchaseSettlementService.list((Wrapper)lambda2);
        for (PurchaseSettlementEntity ce : purchaseSettlementEntities) {
            settleMny = settleMny.add(ce.getCurrentSettlementAmountTax() == null ? BigDecimal.ZERO : ce.getCurrentSettlementAmountTax());
        }
        MaterialReportVo vo = new MaterialReportVo();
        vo.setMny(mny);
        vo.setNum(quoteEntities.size());
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<MaterialContractVO> queryWarnContracts(List<Long> tenantAllIds) {
        return this.materialContractMapper.queryWarnContracts(tenantAllIds);
    }

    @Override
    public List<MaterialContractVO> queryWarnPrePayContracts(List<Long> tenantAllIds) {
        return this.materialContractMapper.queryWarnPrePayContracts(tenantAllIds);
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public MaterialPriceVO queryPrice(Integer isJc, Long contractId, MaterialPriceVO vo) {
        Long projectId = vo.getProjectId();
        List<MaterialPriceVO> detail = vo.getDetail();
        if (CollectionUtils.isNotEmpty(detail)) {
            List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
            List<MaterialPriceVO> materialPrices = this.materialContractMapper.querySettlePriceByTenantId(InvocationInfoProxy.getTenantid(), materialIds);
            if (CollectionUtils.isNotEmpty(materialPrices)) {
                Map<Long, MaterialPriceVO> priceVO = materialPrices.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (MaterialPriceVO v : detail) {
                    Long materialId = v.getMaterialId();
                    MaterialPriceVO p = priceVO.get(materialId);
                    if (null == p) continue;
                    v.setMinPrice(p.getMinPrice());
                    v.setMaxPrice(p.getMaxPrice());
                    v.setPriceArea(p.getMinPrice().setScale(2, 4) + "~" + p.getMaxPrice().setScale(2, 4));
                    v.setBuyPrice(p.getBuyPrice());
                }
            }
        }
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(Integer isJc, Long contractId, MaterialPriceVO vo) {
        List billParamVOS;
        CommonResponse sghtkzc;
        BigDecimal roleValue;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        List<MaterialPriceVO> detailList = vo.getDetail();
        HashMap numMap = new HashMap();
        if (CollectionUtils.isNotEmpty(detailList) && (int)detailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            CommonResponse response1;
            detailList = detailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());
            detailList.forEach(detail -> {
                MaterialPriceVO numVO = (MaterialPriceVO)((Object)((Object)numMap.get(detail.getMaterialId())));
                if (numVO != null) {
                    numVO.setNum(ComputeUtil.safeAdd(numVO.getNum(), detail.getNum()));
                    numVO.setPrice(ComputeUtil.isLessThan(detail.getPrice(), numVO.getPrice()) ? detail.getPrice() : numVO.getPrice());
                    numVO.setTotalAmount(ComputeUtil.safeAdd(numVO.getTotalAmount(), detail.getTotalAmount()));
                } else {
                    numMap.put(detail.getMaterialId(), detail);
                }
            });
            vo.setDetail(new ArrayList<MaterialPriceVO>(numMap.values()));
            List<MaterialPriceVO> detail2 = vo.getDetail();
            if (isJc == 0) {
                CommonResponse response12;
                List subIds = detail2.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_COUNT, curOrgId);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u3010\u7269\u8d44\u603b\u8ba1\u5212\u91cf\u3011\u63a7\u5236\u3010\u7269\u8d44\u5408\u540c\u91cf\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                }
                List billParamVOS2 = (List)response.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS2)) {
                    for (BillParamVO billParamVO : billParamVOS2) {
                        if (0 == billParamVO.getControlType()) continue;
                        List materialIds = detail2.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                        List<Object> vos = new ArrayList();
                        vos = this.materialContractMapper.queryMaterialContractCount(contractId, vo.getProjectId(), materialIds);
                        Map<Long, BigDecimal> priceVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                        BigDecimal roleValue2 = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue2.divide(BigDecimal.valueOf(100L));
                        for (MaterialPriceVO d : detail2) {
                            BigDecimal num = d.getNum();
                            BigDecimal planNum = d.getPlanNum().multiply(divide);
                            BigDecimal hasNum = priceVOMap.get(d.getMaterialId()) != null ? priceVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                            BigDecimal allNum = hasNum.add(num);
                            if (allNum.compareTo(planNum) <= 0) continue;
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "count");
                            paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u5408\u540c\u6570\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u6570\u91cf");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u5408\u540c\u6570\u91cf\uff1a").append(num.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\uff0c\u5df2\u7b7e\u8ba2\u6570\u91cf\uff1a").append(hasNum.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(roleValue2.setScale(8, 4).stripTrailingZeros().toPlainString()).append("%: ").append(planNum.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(allNum.subtract(planNum).setScale(4, 4).stripTrailingZeros().toPlainString());
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            MaterialContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
                if (!(response12 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_PRICE, curOrgId)).isSuccess()) {
                    throw new BusinessException("\u603b\u8ba1\u5212\u4ef7\u683c\u3010\u7269\u8d44\u603b\u8ba1\u5212\u4ef7\u3011\u63a7\u5236\u3010\u7269\u8d44\u5408\u540c\u4ef7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response12.getMsg());
                }
                List billParamVOS1 = (List)response12.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
                    for (BillParamVO billParamVO : billParamVOS1) {
                        if (0 == billParamVO.getControlType()) continue;
                        BigDecimal roleValue3 = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue3.divide(BigDecimal.valueOf(100L));
                        for (MaterialPriceVO d : detail2) {
                            BigDecimal planPrice;
                            BigDecimal _planPrice;
                            BigDecimal price = d.getPrice();
                            if (price.compareTo(_planPrice = (planPrice = d.getPlanPrice()).multiply(divide)) <= 0) continue;
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "unitPrice");
                            paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u5408\u540c\u5355\u4ef7\u5927\u4e8e\u603b\u8ba1\u5212\u5355\u4ef7");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u5408\u540c\u5355\u4ef7\uff1a").append(price.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\uff0c\u603b\u8ba1\u5212\u5355\u4ef7*").append(roleValue3.setScale(8, 4).stripTrailingZeros().toPlainString()).append("%: ").append(_planPrice.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\u3002\u8d85\u51fa\u5355\u4ef7\uff1a").append(price.subtract(_planPrice).setScale(4, 4).stripTrailingZeros().toPlainString());
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            MaterialContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
            if (!(response1 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PRICE_AREA, curOrgId)).isSuccess()) {
                throw new BusinessException("\u7ed3\u7b97\u5386\u53f2\u4ef7\u683c\u533a\u95f4\u3010\u5386\u53f2\u4ef7\u3011\u63a7\u5236\u3010\u7269\u8d44\u5408\u540c\u4ef7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response1.getMsg());
            }
            List billParamVOS1 = (List)response1.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
                for (BillParamVO billParamVO : billParamVOS1) {
                    if (0 == billParamVO.getControlType()) continue;
                    roleValue = billParamVO.getRoleValue();
                    BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                    for (MaterialPriceVO d : detail2) {
                        BigDecimal price = d.getPrice();
                        BigDecimal maxPrice = d.getMaxPrice() == null ? BigDecimal.ZERO : d.getMaxPrice();
                        BigDecimal minPrice = d.getMinPrice();
                        if (maxPrice.compareTo(BigDecimal.ZERO) <= 0) continue;
                        BigDecimal _maxPrice = maxPrice.multiply(divide);
                        BigDecimal _minPrice = minPrice.multiply(divide);
                        if (price.compareTo(_maxPrice) <= 0) continue;
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "unitPrice");
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                        paramsCheckDsVO.setWarnName("\u5408\u540c\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u4ef7");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u5408\u540c\u5355\u4ef7\uff1a").append(price.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\uff0c\u7269\u8d44\u5386\u53f2\u4ef7*").append(roleValue.setScale(8, 4).stripTrailingZeros().toPlainString()).append("%: ").append(_minPrice.setScale(4, 4).stripTrailingZeros().toPlainString()).append("~").append(_maxPrice.setScale(4, 4).stripTrailingZeros().toPlainString()).append("\u3002\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(price.subtract(_maxPrice).setScale(4, 4).stripTrailingZeros().toPlainString());
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        MaterialContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                    }
                }
            }
        }
        if (isJc.equals(0) && (sghtkzc = this.paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId)).isSuccess() && null != sghtkzc.getData() && CollectionUtils.isNotEmpty((Collection)(billParamVOS = (List)sghtkzc.getData()))) {
            BigDecimal sght = this.contractService.fetchSghtzje(vo.getProjectId());
            for (BillParamVO billParamVO : billParamVOS) {
                if (0 == billParamVO.getControlType()) continue;
                roleValue = billParamVO.getRoleValue();
                BigDecimal scale = NumberUtil.div((Number)roleValue, (Number)new BigDecimal("100"), (int)8);
                BigDecimal bigDecimal = ComputeUtil.scaleTwo(NumberUtil.mul((Number)sght, (Number)scale));
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public BigDecimal fetchAmountWithTax(Long projectId) {
        return this.materialContractMapper.sumLastTotalAmountWithTax(projectId, null);
    }

    @Override
    public MaterialPicketageVO countContractNumAndMnyByEnquiry(Long ... enquiryPriceBillIds) {
        if (enquiryPriceBillIds != null) {
            for (Long enquiryPriceBillId : enquiryPriceBillIds) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.select(new String[]{"count(1) as num, IFNULL(sum(amount_with_tax),0) as money"}).eq((Object)"enquiry_price_bill_id", (Object)enquiryPriceBillId);
                Map map = this.getMap((Wrapper)queryWrapper);
                MaterialPicketageVO materialPicketageVO = new MaterialPicketageVO();
                if (MapUtils.isNotEmpty((Map)map)) {
                    Integer num = map.get("num") != null ? Integer.valueOf(map.get("num").toString()) : 0;
                    BigDecimal money = ComputeUtil.toBigDecimal(map.get("money"));
                    materialPicketageVO.setId(enquiryPriceBillId);
                    materialPicketageVO.setContractSign(num);
                    materialPicketageVO.setContractSignMny(money);
                } else {
                    materialPicketageVO.setId(enquiryPriceBillId);
                    materialPicketageVO.setContractSign(0);
                    materialPicketageVO.setContractSignMny(BigDecimal.ZERO);
                }
                this.picketageService.updateContractSignMny(materialPicketageVO);
            }
        }
        return null;
    }

    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        return ((MaterialContractMapper)this.baseMapper).fetchSjzcje(projectId, null);
    }
}

