package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.EngdepartRespcostEntity;
import com.ejianc.business.cost.bean.PrjcontractCostsEntity;
import com.ejianc.business.cost.service.IEngdepartRespcostService;
import com.ejianc.business.cost.service.IPrjcontractCostsService;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service("engdepartRespcost") 
public class EngdepartRespcostBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IEngdepartRespcostService service;
	@Autowired
	private IProjectApi projectApi;

	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IPrjcontractCostsService prjcontractCostsService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//回写项目合同造价表中的工程部销售费用 及 造价金额
		EngdepartRespcostEntity entity = service.selectById(billId);
		Long projectId = entity.getProjectId();
		Long proId = entity.getProjectId();
		List<Long> pIds = new ArrayList<>();
		pIds.add(projectId);
		CommonResponse<List<ProjectRegisterVO>> pvos = projectApi.queryProjectByIds(pIds);
		List<Long> projectIds = new ArrayList<>();
		if(pvos.isSuccess() && pvos.getData()!=null && pvos.getData().size()>0) {
			ProjectRegisterVO pvo = pvos.getData().get(0);
			if (pvo.getParentId()!=null){
				proId = pvo.getParentId();
				//获取
				CommonResponse<List<ProjectRegisterVO>> listResponse = projectApi.queryProjectByPid(pvo.getParentId());
				if(listResponse.isSuccess() && listResponse.getData()!=null && listResponse.getData().size()>0){
					for(ProjectRegisterVO vo : listResponse.getData()){
						projectIds.add(vo.getId());
					}
				}
			}else{
				projectIds.add(projectId);
			}
		}

		QueryWrapper<EngdepartRespcostEntity> wrapper = new QueryWrapper<>();
		wrapper.in("project_id", projectIds);
		List<EngdepartRespcostEntity> lsit = service.list(wrapper);
		BigDecimal all =  new BigDecimal(0);
		for(EngdepartRespcostEntity vo : lsit){
			BigDecimal prjsaleCost = vo.getPrjsaleCost()!=null?vo.getPrjsaleCost():new BigDecimal(0);
			all = all.add(prjsaleCost);
		}

		QueryWrapper<PrjcontractCostsEntity> wrapperPreBidCostCalc = new QueryWrapper<>();
		wrapperPreBidCostCalc.eq("project_id", proId);
		PrjcontractCostsEntity prjcontractCostsEntity = prjcontractCostsService.getOne(wrapperPreBidCostCalc);
		if(prjcontractCostsEntity!=null){
			BigDecimal prjsaleCosto = prjcontractCostsEntity.getPrjsaleCost()!=null ? prjcontractCostsEntity.getPrjsaleCost() : new BigDecimal(0);
			BigDecimal constructionCost = prjcontractCostsEntity.getConstructionCost()!=null ? prjcontractCostsEntity.getConstructionCost() : new BigDecimal(0);
			constructionCost = constructionCost.subtract(prjsaleCosto).add(all);
			prjcontractCostsEntity.setPrjsaleCost(all);
			prjcontractCostsEntity.setConstructionCost(constructionCost);
			prjcontractCostsService.saveOrUpdate(prjcontractCostsEntity, false);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		if(!resp.isSuccess()){
			return CommonResponse.error("操作失败！"+resp.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
