package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.PickRegisterEntity;
import com.ejianc.business.material.mapper.PickRegisterMapper;
import com.ejianc.business.material.service.IPickRegisterService;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 领料登记
 * 
 * @author generator
 * 
 */
@Service("pickRegisterService")
public class PickRegisterServiceImpl extends BaseServiceImpl<PickRegisterMapper, PickRegisterEntity> implements IPickRegisterService{

    /**
     * 校验项目+供应商是否存在单据
     * @param projectId
     * @param supplierId
     * @param id
     * @return
     */
    @Override
    public List<PickRegisterEntity> queryByProjectAndSupplier(Long projectId, Long supplierId, Long id) {
        QueryWrapper<PickRegisterEntity> query = new QueryWrapper<>();
        if(id!=null){
            query.notIn("id", id);
        }
        query.eq("project_id", projectId);
        query.eq("supplier_id", supplierId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        List<PickRegisterEntity> list = this.list(query);
        return list;
    }

    @Override
    public Map<Long, BigDecimal> queryLaborLimitMaterialCount(Long projectId, Long supplierId, List<Long> materialIds) {
        Map<Long, BigDecimal> map = new HashMap<>();
        List<MaterialPriceVO> materialPriceVOS = baseMapper.queryLaborLimitMaterialCount(projectId, supplierId, materialIds);
        if (CollectionUtils.isNotEmpty(materialPriceVOS)) {
            map = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
        }
        return map;
    }
}
