package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.vo.MaterialContractDetailSubVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.business.plan.bean.BatchPlanEntity;
import com.ejianc.business.plan.bean.BatchPlanSubEntity;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.bean.MaterialMasterPlanSubEntity;
import com.ejianc.business.plan.mapper.BatchPlanMapper;
import com.ejianc.business.plan.mapper.BatchPlanSubMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.service.IBatchPlanService;
import com.ejianc.business.plan.vo.BatchPlanSubVO;
import com.ejianc.business.plan.vo.BatchPlanVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 批次计划主实体
 * 
 * @author generator
 * 
 */
@Service("batchPlanService")
public class BatchPlanServiceImpl extends BaseServiceImpl<BatchPlanMapper, BatchPlanEntity> implements IBatchPlanService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private BatchPlanMapper batchPlanMapper;
    @Autowired
    private BatchPlanSubMapper batchPlanSubMapper;
    @Autowired
    private UseApplyMapper useApplyMapper;
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;

    private static String PARAM_PLAN_ALL_COUNT = "P-sa751728";

    @Override
    public BatchPlanVO queryByCode(String billCode) {
        BatchPlanVO resp = null;
        QueryWrapper<BatchPlanEntity> query = new QueryWrapper<>();
        query.eq("bill_code", billCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        BatchPlanEntity entity = batchPlanMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity,BatchPlanVO.class);
        }
        return resp;
    }

    /**
     * 校验项目是否可保存为批次计划
     * @param projectId
     * @return
     */
    @Override
    public List<BatchPlanEntity> queryByProjectId(Long projectId,Long id) {
        BatchPlanVO resp = null;
        QueryWrapper<BatchPlanEntity> query = new QueryWrapper<>();
        if(id != null){
            query.notIn("id", id);
        }
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<BatchPlanEntity> entitys = batchPlanMapper.selectList(query);
        return entitys;
    }

    /**
     * 查询剩余数量 由于主查询关联查，此方法目前没用上
     * @return
     */
    public BigDecimal getSurplusNum(BatchPlanSubVO vo){
        //查询审批通过
        List<Integer> approvedBillState = new ArrayList<>();
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());

        //查询该物资用料申请已生效的申请量
        Map<String, Object> queryParam = new HashMap<>();
        queryParam.put("materialId", vo.getMaterialId());
        queryParam.put("materialTypeId", vo.getMaterialCategoryId());
        queryParam.put("sourceId", vo.getId());

        List<UseApplySubVO> applylist = useApplyMapper.queryListByMaterial(queryParam);
        List<MaterialContractDetailSubVO> contractList = materialContractMapper.queryListByMaterial(queryParam);

        //该物资的申请量
        BigDecimal applyNum = applylist.stream().map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        //该物资的合同量
        BigDecimal contractNum = contractList.stream().map(MaterialContractDetailSubVO::getCount).reduce(BigDecimal.ZERO, BigDecimal::add);
        // 剩余数量 = 计划量-申请量-合同量
        BigDecimal num_temp = ComputeUtil.safeSub(vo.getNum(), applyNum);
        BigDecimal surplusNum = ComputeUtil.safeSub(num_temp, contractNum);
        return surplusNum;
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkAllParams(BatchPlanVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        List<BatchPlanSubVO> batchPlanSubList = vo.getBatchPlanSubList();
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());

        if (CollectionUtils.isNotEmpty(batchPlanSubList) && (int) batchPlanSubList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            batchPlanSubList = batchPlanSubList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());

            // 【物资总计划量】控【批次计划量】
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_ALL_COUNT, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("【物资总计划量】控【批次计划量】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            List<BillParamVO> billParamVOS = response.getData();

            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    // 管理费率
                    BigDecimal manageRate = billParamVO.getRoleValue();
                    // 根据项目取得总计划数据
                    Long projectId = vo.getProjectId();
                    QueryWrapper<MaterialMasterPlanEntity> wrapper = new QueryWrapper<>();
                    wrapper.eq("project_id", projectId);
                    wrapper.eq("dr", 0);
                    List<MaterialMasterPlanEntity> materialMasterPlanEntities = materialMasterPlanMapper.selectList(wrapper);

                    QueryWrapper<MaterialMasterPlanSubEntity> planSubWrapper = new QueryWrapper<>();
                    List<Long> ids = new ArrayList<>();
                    materialMasterPlanEntities.forEach(item -> {
                        ids.add(item.getId());
                    });
                    // list添加一个数据，防止数据为空时，in查询sql拼接错误。
                    ids.add(000001L);
                    planSubWrapper.in("material_master_plan_id", ids);
                    planSubWrapper.eq("dr", 0);
                    List<MaterialMasterPlanSubEntity> materialMasterPlanSubEntities = materialMasterPlanSubMapper.selectList(planSubWrapper);
                    Map<Long, BigDecimal> planMap = new HashMap<>();
                    materialMasterPlanSubEntities.forEach(item -> {
                        Double num = item.getNum();
                        //物资计划物资id是重复的所以需要按照物资id合计
                        if (planMap.containsKey(item.getMaterialId())){
                            planMap.put(item.getMaterialId(), ComputeUtil.safeAdd(planMap.get(item.getMaterialId()),BigDecimal.valueOf(num)));
                        }else {
                            planMap.put(item.getMaterialId(), BigDecimal.valueOf(num));
                        }
                    });

                    // 根据项目id取得批次计划数据。
                    QueryWrapper<BatchPlanEntity> appWrapper = new QueryWrapper<>();
                    appWrapper.eq("project_id", projectId);
                    appWrapper.eq("dr", 0);
                    List<BatchPlanEntity> batchPlanEntities = batchPlanMapper.selectList(appWrapper);
                    ids.clear();
                    batchPlanEntities.forEach(item -> {
                        ids.add(item.getId());
                    });
                    // 查询旧数据时，剔除掉本次申请的物资
                    List<Long> noIds = new ArrayList<>();
                    batchPlanSubList.forEach(item -> {
                        if (item.getId() != null) {
                            noIds.add(item.getId());
                        }
                    });
                    // list添加一个数据，防止数据为空时，in查询sql拼接错误。
                    ids.add(000001L);
                    QueryWrapper<BatchPlanSubEntity> appSubWrapper = new QueryWrapper<>();
                    appSubWrapper.in("plan_id", ids);
                    appSubWrapper.notIn("id", noIds);
                    appSubWrapper.eq("dr", 0);
                    List<BatchPlanSubEntity> batchPlanSubEntities1 = batchPlanSubMapper.selectList(appSubWrapper);
                    List<BatchPlanSubEntity> batchPlanSubEntities2 = BeanMapper.mapList(batchPlanSubList, BatchPlanSubEntity.class);
                    Map<Long, BatchPlanSubEntity> thisMap = new HashMap<>();
                    batchPlanSubEntities2.forEach(item -> {
                        if (thisMap.containsKey(item.getMaterialId())) {
                            BatchPlanSubEntity batchPlanSubEntity = thisMap.get(item.getMaterialId());
                            batchPlanSubEntity.setNum(batchPlanSubEntity.getNum().add(item.getNum()));
                        } else {
                            thisMap.put(item.getMaterialId(), item);
                        }
                    });
                    Map<Long, BigDecimal> oldAppMap = new HashMap<>();
                    batchPlanSubEntities1.forEach(item -> {
                        BigDecimal applyNum = item.getNum();
                        if (oldAppMap.containsKey(item.getMaterialId())) {
                            BigDecimal bigDecimal = oldAppMap.get(item.getMaterialId());
                            oldAppMap.put(item.getMaterialId(), applyNum.add(bigDecimal));
                        } else {
                            oldAppMap.put(item.getMaterialId(), applyNum);
                        }
                    });

                    thisMap.forEach((k, item) -> {
                        Long materialId = item.getMaterialId();
                        //本次批次计划数量
                        BigDecimal batNum = item.getNum();
                        //原有的数量 如果为空取0
                        BigDecimal oldBatNum = oldAppMap.get(materialId) == null ? BigDecimal.ZERO : oldAppMap.get(materialId);
                        //总计划数量 如果为空 则表示未做计划，取0
                        BigDecimal planNum = planMap.get(materialId) == null ? BigDecimal.ZERO : planMap.get(materialId);

                        BigDecimal planNumber = planNum.multiply(manageRate).divide(BigDecimal.valueOf(100));
                        BigDecimal batNumber = ComputeUtil.nullToZero(ComputeUtil.safeAdd(oldBatNum, batNum));

                        if (planNumber.compareTo(batNumber) == -1) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty(item.getSpec()) ? " [" + item.getSpec() + "]" : ""));
                            paramsCheckDsVO.setWarnName("累计批次计划量大于总计划量");
                            paramsCheckDsVO.setContent("本次计划数量:" + batNum.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString()
                                    + ",含本次累计计划数量:" + batNumber.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString()
                                    + ",总计划数量*"+manageRate.setScale(8, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString()
                                    +"%:"+ planNumber.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString()
                                    + ",超出数量:" + ComputeUtil.safeSub(batNumber, planNumber).setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString()
                            );
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    });
                }
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }
}
