package com.ejianc.business.sub.vo;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SubCostTypeEnum {
    LABOR_COST_TYPE(1, "人工费"),
    MATERIAL_COST_TYPE(2, "材料费"),
    MAJOR_COST_TYPE(3, "专业分包费"),
    MECHANICAL_COST_TYPE(4, "机械费"),
    INDIRECTION_COST_TYPE(5, "间接费");

    private final Integer type;
    private final String name;
    private static Map<Integer, SubCostTypeEnum> enumMap = new HashMap();

    private SubCostTypeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }


    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public static SubCostTypeEnum getEnumByType(Integer type) {
        return (SubCostTypeEnum)enumMap.get(type);
    }

    static {
        enumMap = (Map) EnumSet.allOf(SubCostTypeEnum.class).stream().collect(Collectors.toMap(SubCostTypeEnum::getType, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

    public static void main(String[] args) {
        SubCostTypeEnum enumByType = SubCostTypeEnum.getEnumByType(1);
        System.out.println(enumByType.name);
    }
}
