/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labprice.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labprice.bean.LaborQuoteEntity;
import com.ejianc.business.labprice.service.ILaborQuoteService;
import com.ejianc.business.labprice.vo.LaborQuoteVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"laborQuote"})
public class LaborQuoteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RULE_CODE = "ZYDX_LABOR_QUOTE";
    private static final String BILL_CODE = "EJCBT202502000027";
    @Resource
    private IBillTypeApi billTypeApi;
    @Resource
    private IBillCodeApi billCodeApi;
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private ILaborQuoteService service;
    @Autowired
    private SessionManager sessionManager;
    @Resource
    private IAttachmentApi attachmentApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LaborQuoteVO> saveOrUpdate(@RequestBody LaborQuoteVO saveOrUpdateVO) {
        LaborQuoteEntity entity = (LaborQuoteEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), LaborQuoteEntity.class));
        this.service.checkQuoteEndDate(entity.getInquiryId());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        LaborQuoteVO vo = (LaborQuoteVO)((Object)BeanMapper.map((Object)((Object)entity), LaborQuoteVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LaborQuoteVO> queryDetail(Long id) {
        LaborQuoteEntity entity = (LaborQuoteEntity)((Object)this.service.selectById(id));
        LaborQuoteVO vo = (LaborQuoteVO)((Object)BeanMapper.map((Object)((Object)entity), LaborQuoteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LaborQuoteVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (LaborQuoteVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LaborQuoteVO>> queryList(@RequestBody QueryParam param) {
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time", "desc");
        param.getOrderMap().putAll(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List materialQuoteVOS = BeanMapper.mapList((Iterable)page.getRecords(), LaborQuoteVO.class);
        if (CollectionUtils.isNotEmpty((Collection)materialQuoteVOS)) {
            List quoteIds = materialQuoteVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            JSONObject fileParam = new JSONObject();
            fileParam.put("sourceIds", quoteIds);
            JSONArray sourceTypeArr = new JSONArray();
            sourceTypeArr.add((Object)"quote");
            fileParam.put("sourceTypeList", (Object)JSON.toJSONString((Object)sourceTypeArr));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(fileParam);
            List fileData = (List)listCommonResponse.getData();
            Map<Object, Object> fileMap = new HashMap();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)fileData)) {
                fileMap = fileData.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity(), (e1, e2) -> e1));
            }
            for (LaborQuoteVO materialQuoteVO : materialQuoteVOS) {
                if (!fileMap.containsKey(materialQuoteVO.getId())) continue;
                AttachmentVO attachmentVO = (AttachmentVO)fileMap.get(materialQuoteVO.getId());
                materialQuoteVO.setQuoteFileId(attachmentVO.getId());
                materialQuoteVO.setQuoteFileName(attachmentVO.getFileName());
            }
        }
        pageData.setRecords(materialQuoteVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/checkViewAuthority"})
    public CommonResponse<Void> checkViewAuthority(@RequestParam(value="inquiryId") Long inquiryId, @RequestParam(value="phoneNumber") String phoneNumber) {
        this.service.checkViewAuthority(inquiryId, phoneNumber);
        return CommonResponse.success();
    }

    @GetMapping(value={"/checkQuotationAuthority"})
    public CommonResponse<Void> checkQuotationAuthority(@RequestParam(value="inquiryId") Long inquiryId, @RequestParam(value="phoneNumber") String phoneNumber) {
        this.service.checkQuotationAuthority(inquiryId, phoneNumber);
        return CommonResponse.success();
    }

    @GetMapping(value={"/fetchVerifyCode"})
    public CommonResponse<Void> fetchVerifyCode(@RequestParam(value="inquiryId") Long inquiryId, @RequestParam(value="phoneNumber") String phoneNumber) throws Exception {
        this.service.fetchVerifyCode(inquiryId, phoneNumber);
        return CommonResponse.success((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u767b\u5f55")
    @GetMapping(value={"/login"})
    public CommonResponse<String> login(@RequestParam(value="phoneNumber") String phoneNumber, @RequestParam(value="validate") String validate) {
        this.service.login(phoneNumber, validate);
        return CommonResponse.success((String)"\u767b\u5f55\u6210\u529f\uff01", (Object)phoneNumber);
    }

    @ApiOperation(value="\u6536\u56de")
    @GetMapping(value={"/withdraw"})
    public CommonResponse<String> withdraw(@RequestParam(value="id") Long id) {
        this.service.withdraw(id);
        return CommonResponse.success((String)"\u6536\u56de\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4fee\u6539\u5355\u636e\u72b6\u6001")
    @GetMapping(value={"/changeStatus"})
    public CommonResponse<String> changeStatus(@RequestParam(value="id") Long id, @RequestParam(value="billState") Integer billState) {
        this.service.changeStatus(id, billState);
        return CommonResponse.success((String)"\u5355\u636e\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6700\u8fd1\u4e00\u6b21\u7684\u62a5\u4ef7\u8bb0\u5f55")
    @GetMapping(value={"/recentQuote"})
    public CommonResponse<LaborQuoteVO> recentQuote(@RequestParam(value="phoneNumber") String phoneNumber) {
        return CommonResponse.success((String)"\u5355\u636e\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01", (Object)((Object)this.service.recentQuote(phoneNumber)));
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LaborQuote-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refLaborQuoteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<LaborQuoteVO>> refLaborQuoteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LaborQuoteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

