package com.ejianc.business.bidprice.material.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialFuzzyMatchVO;
import com.ejianc.foundation.share.vo.MaterialPlusVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

@Component
public class ArchivesUtils {
    @Autowired
    private IMaterialApi materialApi;
    private final Logger logger = LoggerFactory.getLogger(getClass());

    public JSONObject  findMatch(List matchList,String categoryIdFieldName,String materialIdFieldName,String categoryFieldName,String materialFieldName,String unitFieldName,String specFieldName,String errorMessageFieldName)  {
        //校验分类是否存在vo
        MaterialFuzzyMatchVO materialFuzzyMatchVO = new MaterialFuzzyMatchVO();
        //模糊匹配vo
        MaterialFuzzyMatchVO materialNumberFuzzyMatchVO = new MaterialFuzzyMatchVO();
        HashMap<String, MaterialPlusVO> fuzzyMatchMap = new HashMap<>();
        //错误list
        List<Map<String, Object>> errorList = new ArrayList<>();
        //成功list
        List<Map<String, Object>> sourceList = new ArrayList<>();

        Map<String, Boolean> materialHashMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(matchList)) {
            List<Map<String, Object>> list = JSONObject.parseObject(JSONObject.toJSONString(matchList), List.class);
            for (Map<String, Object> map : list) {
                String categoryName = Objects.isNull(map.get(categoryFieldName)) ? null : map.get(categoryFieldName).toString();
                if (StringUtils.isNotBlank(categoryName)) {
                    materialHashMap.put(categoryName, false);
                }
            }
            materialFuzzyMatchVO.setMaterialCategoryMap(materialHashMap);
            CommonResponse<MaterialFuzzyMatchVO> commonResponse = materialApi.checkArchive(materialFuzzyMatchVO);
            if (commonResponse.isSuccess() && commonResponse.getData()!=null) {
                materialFuzzyMatchVO = commonResponse.getData();
            }
            for (Map<String, Object> map : list) {
                String categoryName = Objects.isNull(map.get(categoryFieldName)) ? null : map.get(categoryFieldName).toString();
                Map<String, Boolean> materialCategoryMap = materialFuzzyMatchVO.getMaterialCategoryMap();
                if (StringUtils.isNotBlank(categoryName)) {
                    if (!materialCategoryMap.get(categoryName)) {
                        map.put(errorMessageFieldName, "分类必须存在");
                        errorList.add(map);
                    } else {
                        MaterialPlusVO materialPlusVO = new MaterialPlusVO();
                        materialPlusVO.setType(1);
                        materialPlusVO.setCategoryName(categoryName);
                        String spec = Objects.isNull(map.get(specFieldName)) ? null : map.get(specFieldName).toString();
                        materialPlusVO.setSpec(spec);
                        String name = Objects.isNull(map.get(materialFieldName)) ? null : map.get(materialFieldName).toString();
                        materialPlusVO.setName(name);
                        materialPlusVO.setCategoryName(categoryName);
                        String unit = Objects.isNull(map.get(unitFieldName)) ? null : map.get(unitFieldName).toString();
                        materialPlusVO.setUnitName(unit);
                        fuzzyMatchMap.put(map.get("onlyKey").toString(), materialPlusVO);
                        sourceList.add(map);
                    }
                }
                //模糊匹配入参
                materialNumberFuzzyMatchVO.setFuzzyMatchMap(fuzzyMatchMap);
            }
            if (CollectionUtils.isNotEmpty(sourceList)) {
                CommonResponse<MaterialFuzzyMatchVO> materialFuzzyMatchVOCommonResponse = materialApi.fuzzyMatchNumber(materialNumberFuzzyMatchVO);
                if (materialFuzzyMatchVOCommonResponse.isSuccess() && materialFuzzyMatchVOCommonResponse.getData()!=null) {
                    MaterialFuzzyMatchVO data = materialFuzzyMatchVOCommonResponse.getData();
                    Map<String, MaterialPlusVO> matchMap = data.getFuzzyMatchMap();
                    for (Map<String, Object> map : sourceList) {
                        String onlyKey = (String) map.get("onlyKey");
                        if (matchMap != null) {
                            MaterialPlusVO materialPlusVO = matchMap.get(onlyKey);
                            if (materialPlusVO != null) {
                                Integer matchStatus = materialPlusVO.getMatchStatus();
                                if (matchStatus != null && matchStatus == 1) {
                                    map.put(categoryIdFieldName, materialPlusVO.getCategoryId());
                                    map.put(materialIdFieldName, materialPlusVO.getId());

                                    map.put(unitFieldName, materialPlusVO.getUnitName());
                                    map.put(specFieldName, materialPlusVO.getSpec());

                                    map.put(categoryFieldName, materialPlusVO.getCategoryName());
                                    map.put(materialFieldName, materialPlusVO.getName());
                                }
                                Integer matchNumber = materialPlusVO.getMatchNumber();
                                String matchStatusDescription = materialPlusVO.getMatchStatusDescription();
                                map.put("matchStatus", matchStatus);
                                map.put("matchNumber", matchNumber);
                                map.put("matchStatusDescription", matchStatusDescription);
                            }
                        }
                    }
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sourceList",sourceList);
        jsonObject.put("errorList",errorList);
        return jsonObject;
    }
    public JSONObject  batchSaveArchive(List matchList,String categoryIdFieldName,String materialIdFieldName,String categoryFieldName,String materialFieldName,String unitFieldName,String specFieldName,String errorMessageFieldName)  {
        Map<String, MaterialVO> materialVOMap=new HashMap<>();
        Map<String, MaterialVO> archiveMap=new HashMap<>();
        List<Map<String, Object>> list=new ArrayList<>();
        if (CollectionUtils.isNotEmpty(matchList)) {
             list = JSONObject.parseObject(JSONObject.toJSONString(matchList), List.class);
            for (Map<String, Object> map : list) {
                if (map.get("rowState")!=null && map.get("rowState")!="del" &&  map.get("matchStatus")!=null && !map.get("matchStatus").toString().equals("1")){
                    MaterialVO materialVO = new MaterialVO();
                    String categoryName = Objects.isNull(map.get(categoryFieldName)) ? null : map.get(categoryFieldName).toString();
                    materialVO.setCategoryName(categoryName);
                    String materialName = Objects.isNull(map.get(materialFieldName)) ? null : map.get(materialFieldName).toString();
                    materialVO.setName(materialName);
                    String spec = Objects.isNull(map.get(specFieldName)) ? null : map.get(specFieldName).toString();
                    materialVO.setSpec(spec);
                    String unit = Objects.isNull(map.get(unitFieldName)) ? null : map.get(unitFieldName).toString();
                    materialVO.setUnitName(unit);
                    materialVO.setType(1);
                    String onlyKey = map.get("onlyKey").toString();
                    materialVOMap.put(onlyKey,materialVO);
                }
            }
            if (!materialVOMap.isEmpty()){
                CommonResponse<Map<String, MaterialVO>> listCommonResponse = materialApi.batchInsertArchive(materialVOMap);
                logger.info("插入"+JSONObject.toJSONString(materialVOMap));
                if (listCommonResponse.isSuccess()){
                    Map<String, MaterialVO>data = listCommonResponse.getData();
                    if (data!=null){
                        archiveMap=data;
                    }
                }
            }
            //进行数据的补全
            for (Map<String, Object> map : list) {
                String onlyKey = map.get("onlyKey").toString();
               if(archiveMap!=null && archiveMap.get(onlyKey)!=null){
                   MaterialVO materialVO = archiveMap.get(onlyKey);
                   map.put(categoryIdFieldName, materialVO.getCategoryId());
                   map.put(materialIdFieldName, materialVO.getId());
                   map.put(unitFieldName, materialVO.getUnitName());
                   map.put(specFieldName, materialVO.getSpec());
                   map.put(categoryFieldName, materialVO.getCategoryName());
                   map.put(materialFieldName, materialVO.getName());
                   map.put("matchStatus",1);
                   map.put("matchStatusDescription","已匹配");
               }
            }

        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sourceList",list);
        return jsonObject;
    }


    public static JSONObject  findMatch1(List matchList,String categoryIdFieldName,String materialIdFieldName,String categoryFieldName,String materialFieldName,String unitFieldName,String specFieldName) throws Exception {
        JSONObject jsonObject = new JSONObject();
        List<Map<String, Object>> list = JSONObject.parseObject(JSONObject.toJSONString(matchList), List.class);
        for (Map<String, Object> map : list) {
            Object o = map.get(materialFieldName);
            System.out.println(o);
            map.put(materialFieldName,666666);
        }
        jsonObject.put("sourceList",matchList);
        return jsonObject;
    }


}
