/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labprice.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.labprice.bean.LaborInquiryEntity;
import com.ejianc.business.labprice.bean.LaborPicketageEntity;
import com.ejianc.business.labprice.service.ILaborInquiryService;
import com.ejianc.business.labprice.service.impl.LaborPicketageServiceImpl;
import com.ejianc.business.labprice.vo.LaborInquiryVO;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"laborInquiry"})
public class LaborInquiryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZYDX_LABOR_INQUIRY";
    @Autowired
    private ILaborInquiryService service;
    @Autowired
    private LaborPicketageServiceImpl picketageService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ArchivesUtil archivesUtil;
    @Autowired
    private IEmployeeApi employeeApi;
    private static final String PARAM_BID_PROCESS = "P-k8181N67";
    @Autowired
    private IParamConfigApi paramConfigApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LaborInquiryVO> saveOrUpdate(@RequestBody LaborInquiryVO saveOrUpdateVO) {
        CommonResponse byCode;
        LaborInquiryEntity entity = (LaborInquiryEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), LaborInquiryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setInquiryState(InquiryStateEnum.DEFAULT_STATE.getCode());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getBidProcess() == null && (byCode = this.paramConfigApi.getByCode(PARAM_BID_PROCESS)).isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            entity.setBidProcess(Integer.valueOf(valueData));
        }
        if (entity.getBidOpenState() == null) {
            entity.setBidOpenState(0);
        }
        this.service.saveOrUpdate((Object)entity, false);
        LaborInquiryVO vo = (LaborInquiryVO)((Object)BeanMapper.map((Object)((Object)entity), LaborInquiryVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LaborInquiryVO> queryDetail(Long id) {
        LaborInquiryEntity entity = (LaborInquiryEntity)((Object)this.service.selectById(id));
        LaborInquiryVO vo = (LaborInquiryVO)((Object)BeanMapper.map((Object)((Object)entity), LaborInquiryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/updateInquiry"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LaborInquiryVO> updateInquiry(@RequestBody LaborInquiryVO updateVo) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(LaborPicketageEntity::getInquiryId, (Object)updateVo.getId());
        List list = this.picketageService.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            return CommonResponse.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u5df2\u5b9a\u6807\uff01");
        }
        LaborInquiryVO vo = this.service.updateInquiry(updateVo);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LaborInquiryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (LaborInquiryVO laborInquiryVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LaborInquiryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseSubject");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (param.getParams().containsKey("inquiryState")) {
            Integer inquiryState = Integer.parseInt(((Parameter)param.getParams().get("inquiryState")).getValue().toString());
            if (InquiryStateEnum.QUOTATION_STATE.getCode() == inquiryState) {
                param.getParams().put("inquiryState", new Parameter("in", Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(), InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate", new Parameter("gt", (Object)new Date()));
            }
            if (InquiryStateEnum.EXPIRATION_STATE.getCode() == inquiryState) {
                param.getParams().put("inquiryState", new Parameter("in", Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(), InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate", new Parameter("lt", (Object)new Date()));
            }
            if (InquiryStateEnum.WIN_STATE.getCode() == inquiryState) {
                param.getParams().put("inquiryState", new Parameter("in", Arrays.asList(InquiryStateEnum.WIN_STATE.getCode(), InquiryStateEnum.SIGN_STATE.getCode())));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List vos = BeanMapper.mapList((Iterable)page.getRecords(), LaborInquiryVO.class);
        for (LaborInquiryVO vo : vos) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vo.setInquiryStateName(InquiryStateEnum.getTypeNameByCode(vo.getInquiryState()));
            if (InquiryStateEnum.QUOTATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) < 0) {
                vo.setInquiryStateName(InquiryStateEnum.EXPIRATION_STATE.getDescription());
            }
            if (InquiryStateEnum.EXPIRATION_STATE.getCode().equals(vo.getInquiryState()) && vo.getQuoteEndDate().compareTo(new Date()) > 0) {
                vo.setInquiryStateName(InquiryStateEnum.QUOTATION_STATE.getDescription());
            }
            if (!InquiryStateEnum.SIGN_STATE.getCode().equals(vo.getInquiryState())) continue;
            vo.setInquiryStateName(InquiryStateEnum.WIN_STATE.getDescription());
        }
        pageData.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LaborInquiry-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refLaborInquiryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<LaborInquiryVO>> refLaborInquiryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        List fuzzyFields;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchObject(searchObject);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            param.setSearchText(searchText);
            fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("purchaseSubject");
            fuzzyFields.add("projectName");
            fuzzyFields.add("orgName");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            fuzzyFields = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("inquiryState", new Parameter("in", Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(), InquiryStateEnum.EXPIRATION_STATE.getCode())));
        param.getParams().put("quoteEndDate", new Parameter("lt", (Object)new Date()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("inquiry_date", "desc");
        param.getOrderMap().putAll(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List vos = BeanMapper.mapList((Iterable)page.getRecords(), LaborInquiryVO.class);
        for (LaborInquiryVO vo : vos) {
            vo.setInquiryStateName(InquiryStateEnum.EXPIRATION_STATE.getDescription());
        }
        pageData.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u624b\u673a\u53f7")
    @RequestMapping(value={"/queryPhone"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)mobilePhone);
    }

    @ApiOperation(value="\u5f00\u6807")
    @RequestMapping(value={"/openBid"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LaborInquiryVO> openBid(@RequestParam Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(LaborInquiryEntity::getBidOpenState, (Object)1);
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u5f00\u6807\u6210\u529f\uff01");
    }
}

