/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.mapper.InstoreMaterialMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IPickRegisterService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.service.impl.StoreService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="instoreMaterialService")
public class InstoreMaterialService
extends BaseServiceImpl<InstoreMaterialMapper, InstoreMaterialEntity>
implements IInstoreMaterialService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private InstoreMaterialMapper instoreMaterialMapper;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private StoreService storeService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static String PARAM_PLAN_COUNT = "P-D80E4406";
    private static String PARAM_APPLY_COUNT = "P-Zm16p834";
    private static String PARAM_DETAIL_COUNT = "P-4bxJ4C64";
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    IInstoreService instoreService;
    @Autowired
    private IUseApplyService useApplyService;
    private static final String PARAM_TOTAL_MNY = "P-5j78wo43";
    private static final String PARAM_NUM = "P-uFOcn644";
    private static final String PARAM_TAX_MNY = "P-14dTg745";
    private static final String PARAM_MATERIAL_PRICE = "P-1N735378";
    private static String PARAM_LABOR_LIMIT_COUNT = "P-29E6rb74";
    private static String PARAM_DETAIL_PRICE = "P-Yn663f82";
    private static String PARAM_DETAIL_MNY = "P-j5u3Z80316";
    @Autowired
    private IPickRegisterService pickRegisterService;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public List<InstoreMaterialVO> querylist(QueryWrapper<InstoreMaterialEntity> queryWrapper) {
        List list = this.list((Wrapper)queryWrapper);
        return BeanMapper.mapList((Iterable)list, InstoreMaterialVO.class);
    }

    @Override
    public BigDecimal countAmount(QueryParam param) {
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        queryWrapper.eq((Object)"dr", (Object)0);
        return this.instoreMaterialMapper.countAmount((QueryWrapper<InstoreEntity>)queryWrapper);
    }

    @Override
    public IPage<InstoreMaterialVO> queryStoreCanUseNumPageData(String searchText, String searchObject, String outDate, Long storeId, Integer pageNum, Integer pageSize) {
        Page page = new Page();
        page.setCurrent((long)pageNum.intValue());
        page.setPages((long)pageSize.intValue());
        page.setSize((long)pageSize.intValue());
        String materialTypeName = "";
        String materialName = "";
        String materialSpec = "";
        String materialUnit = "";
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            if (search.get((Object)"materialCategoryName") != null) {
                materialTypeName = search.get((Object)"materialCategoryName").toString();
            }
            if (search.get((Object)"materialName") != null) {
                materialName = search.get((Object)"materialName").toString();
            }
            if (search.get((Object)"materialSpec") != null) {
                materialSpec = search.get((Object)"materialSpec").toString();
            }
            if (search.get((Object)"materialUnit") != null) {
                materialUnit = search.get((Object)"materialUnit").toString();
            }
        }
        Long count = this.instoreMaterialMapper.queryStoreCanUseNumPageDataCount(searchText, outDate, storeId, materialTypeName, materialName, materialSpec, materialUnit);
        page.setTotal(count.longValue());
        List<InstoreMaterialVO> records = this.instoreMaterialMapper.queryStoreCanUseNumPageData(searchText, outDate, storeId, (pageNum - 1) * pageSize, pageSize, materialTypeName, materialName, materialSpec, materialUnit);
        page.setRecords(records);
        return page;
    }

    @Override
    public IPage<InstoreMaterialVO> storematerialList(Long storeId, String searchText, Integer pageNumber, Integer pageSize) {
        Page page = new Page();
        Long count = this.instoreMaterialMapper.countStorematerialList(storeId, searchText);
        if (count > 0L) {
            Integer startLine = null;
            if (pageNumber != null) {
                startLine = ((pageNumber > 0 ? pageNumber : 1) - 1) * pageSize;
                page.setCurrent((long)pageNumber.intValue());
                page.setSize((long)pageSize.intValue());
            }
            List<InstoreMaterialVO> list = this.instoreMaterialMapper.storematerialList(storeId, searchText, startLine, pageSize);
            page.setRecords(list);
        }
        page.setTotal(count.longValue());
        return page;
    }

    @Override
    public InstoreMaterialVO censusStorematerial(Long storeIid) {
        return this.instoreMaterialMapper.censusStorematerial(storeIid);
    }

    @Override
    public IPage<InstoreMaterialVO> queryUsableSubMaterialList(String searchText, String outDate, Long storeId, Integer pageNumber, Integer pageSize, List<Long> materialIds, HashMap<String, String> map) {
        Page page = new Page();
        page.setCurrent((long)pageNumber.intValue());
        page.setPages((long)pageSize.intValue());
        page.setSize((long)pageSize.intValue());
        Long count = this.instoreMaterialMapper.queryUsableSubMaterialCount(searchText, outDate, storeId, materialIds, map);
        page.setTotal(count.longValue());
        List<InstoreMaterialVO> records = this.instoreMaterialMapper.queryUsableSubMaterialPageList(searchText, outDate, storeId, (pageNumber - 1) * pageSize, pageSize, materialIds, map);
        page.setRecords(records);
        return page;
    }

    @Override
    public List<InstoreMaterialVO> querySubMaterialStoreInfo(Long storeId, Date checkDate, Long materialId, double inventory) {
        return this.instoreMaterialMapper.querySubMaterialStoreInfo(storeId, checkDate, materialId, inventory);
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkParams(MaterialPriceVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap paramsCheckVOMap = new HashMap();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        List<MaterialPriceVO> detailList = vo.getDetail();
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        Integer instoreType = vo.getInstoreType();
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public List<InstoreMaterialVO> storeNumCount(Long orgId, List<Long> materialIds) {
        CommonResponse parentsOrgIds = this.orgApi.findParentsByOrgId(orgId);
        CommonResponse childrenOrgIds = this.orgApi.findChildrenByParentId(orgId);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.and(t2 -> {
            t2.in(StoreEntity::getOrgId, (Collection)((List)childrenOrgIds.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (parentsOrgIds.isSuccess() && parentsOrgIds.getData() != null) {
                t2.or(k -> (LambdaQueryWrapper)((LambdaQueryWrapper)k.in(StoreEntity::getOrgId, (Collection)((List)parentsOrgIds.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()))).eq(StoreEntity::getProjectType, (Object)"2"));
            }
            return t2;
        });
        List list = this.storeService.list((Wrapper)wrapper);
        return this.instoreMaterialMapper.storeNumCount(list.stream().map(BaseEntity::getId).collect(Collectors.toList()), materialIds);
    }
}

