/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.pub.MaterialAllocationState;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.pub.MessageUtil;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="returnGoods")
public class ReturnGoodsBpmService
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    MessageUtil messageUtil;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    IInstoreService instoreService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5ba1\u6279\u901a\u8fc7\u540e\u7684\u56de\u8c03\u5f00\u59cb-------------------");
        this.logger.info("\u5ba1\u6279\u901a\u8fc7\u540e\u7684\u56de\u8c03\uff0c\u4fee\u6539\u7684\u72b6\u6001------" + MaterialStoreState.STORED.getCode());
        return this.changeStoreState(billId, MaterialStoreState.USED.getCode());
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity entity = (OutStoreEntity)((Object)this.iOutStoreService.selectById(billId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u5355\u636e\u4fe1\u606f\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
        }
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            this.logger.info("\u51fa\u5e93\u5355\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", new Object[]{billId, billTypeCode, resp.getMsg()});
            return CommonResponse.error((String)resp.getMsg());
        }
        if (Objects.equals(entity.getStoreType(), MaterialStoreType.ALLOCATION_OUT_STORE.getCode())) {
            return CommonResponse.error((String)("\u5df2\u8c03\u5165\u3010" + entity.getInOrgName() + "\u3011\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01"));
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5f03\u5ba1\u540e\u7684\u56de\u8c03\u5f00\u59cb-------------------");
        this.logger.info("\u5f03\u5ba1\u540e\u7684\u56de\u8c03\uff0c\u4fee\u6539\u7684\u72b6\u6001------" + MaterialStoreState.STORED.getCode());
        return this.changeStoreState(billId, MaterialStoreState.OCCUPY.getCode());
    }

    public CommonResponse<String> changeStoreState(Long billId, Integer state) {
        OutStoreEntity entity = (OutStoreEntity)((Object)this.iOutStoreService.selectById(billId));
        if (entity == null) {
            CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u51fa\u5e93\u5355\uff01");
        }
        if (!ListUtil.isEmpty(entity.getOutStoreSubEntities())) {
            entity.getOutStoreSubEntities().forEach(sub -> sub.setStoreState(state));
        }
        if (Objects.equals(entity.getStoreType(), MaterialStoreType.PICKING_OUT_STORE.getCode())) {
            this.processCostState(entity, state);
        }
        if (Objects.equals(entity.getStoreType(), MaterialStoreType.ALLOCATION_OUT_STORE.getCode())) {
            this.processALLOCATION_OUT_STORE(entity, state);
        }
        this.iOutStoreService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    private void processALLOCATION_OUT_STORE(OutStoreEntity entity, Integer state) {
        InstoreEntity vo;
        if (Objects.equals(MaterialStoreState.USED.getCode(), state)) {
            vo = new InstoreEntity();
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("ZYDX_MATERIAL-INSTORE", InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8c03\u5165\u5355\u53f7\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            vo.setBillCode((String)billCode.getData());
            vo.setId(IdWorker.getId());
            vo.setMaterialName(entity.getMaterialNames());
            vo.setTotalAmount(entity.getOutMoney());
            vo.setTotalCount(entity.getOutNum());
            vo.setOutId(entity.getId());
            vo.setInstoreDate(entity.getOutDate());
            vo.setInstoreType(MaterialStoreType.ALLOCATION_IN_STORE.getCode());
            vo.setOutOrgId(entity.getOrgId());
            vo.setOutOrgName(entity.getOrgName());
            vo.setOutStoreId(entity.getStoreId());
            vo.setOutStoreName(entity.getStoreName());
            vo.setOrgId(entity.getInOrgId());
            vo.setOutProjectId(entity.getProjectId());
            vo.setOutProjectName(entity.getProjectName());
            vo.setProjectFlag(entity.getInBelongToProject());
            vo.setOrgName(entity.getInOrgName());
            vo.setProjectId(entity.getInProjectId());
            vo.setProjectName(entity.getInProjectName());
            vo.setReceiveState(MaterialAllocationState.TO_RECEIVING.getCode());
            vo.setNote(entity.getMemo());
            List<InstoreMaterialEntity> materialVOS = vo.getInstoreMaterialList();
            List<OutStoreSubEntity> outStoreSubs = entity.getOutStoreSubEntities();
            if (!ListUtil.isEmpty(outStoreSubs)) {
                outStoreSubs.forEach(o -> {
                    InstoreMaterialEntity materialVO = (InstoreMaterialEntity)((Object)((Object)BeanMapper.map((Object)o, InstoreMaterialEntity.class)));
                    materialVO.setId(null);
                    materialVO.setVersion(null);
                    materialVO.setInstoreDate(vo.getInstoreDate());
                    materialVO.setStoreState(MaterialStoreState.STORING.getCode());
                    materialVO.setInstoreNumber(o.getOutStoreNumber());
                    materialVO.setInstoreType(MaterialStoreType.ALLOCATION_IN_STORE.getCode());
                    materialVOS.add(materialVO);
                });
            }
        } else {
            throw new BusinessException("\u5df2\u8c03\u5165\u3010" + entity.getInOrgName() + "\u3011\uff0c\u65e0\u6cd5\u64a4\u56de\uff01");
        }
        this.instoreService.saveOrUpdate((Object)vo, false);
        entity.setReceiveState(MaterialAllocationState.TO_RECEIVING.getCode());
        entity.setReceivePerson(null);
        this.sendMessageToNoticePerson(entity.getNoticeToReceive(), vo.getBillCode(), vo.getId());
    }

    private void sendMessageToNoticePerson(Long receiveId, String billCode, Long billId) {
        if (receiveId != null) {
            ArrayList<String> messageType = new ArrayList<String>();
            ArrayList<String> receivers = new ArrayList<String>();
            messageType.add("sys");
            receivers.add(receiveId.toString());
            String formurl = this.baseHost + "ejc-zypms-frontend/#/allocationIn/card?id=" + billId;
            String subject = "\u6750\u6599\u8c03\u62e8\u5165\u5e93\u63d0\u9192";
            String content = "\u6536\u5230\u8c03\u62e8\u5165\u5e93\u6750\u6599\u5355\u3010" + billCode + "\u3011\u8bf7\u53ca\u65f6\u5904\u7406\uff01\u3002<a href=" + '\"' + formurl + '\"' + ">\u7acb\u5373\u5904\u7406</a>";
            this.messageUtil.sendMsg(messageType, receivers, "notice", subject, content);
        }
    }

    public void processCostState(OutStoreEntity entity, Integer process) {
        if (process == MaterialStoreState.USED.getCode()) {
            this.iOutStoreService.processCost(entity);
        } else {
            entity.setRelationFlag("0");
        }
    }
}

