/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.bean.MaterialMasterPlanSubEntity;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.bean.PlanChangeHisEntity;
import com.ejianc.business.plan.bean.PlanChangeSubEntity;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IMaterialMasterPlanSubService;
import com.ejianc.business.plan.service.IPlanChangeHisService;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanChangeSubService;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

public class PlanChangeThread
implements Runnable {
    private Logger logger;
    private Long billId;
    private Integer state;
    private IPlanChangeService planChangeService;
    private IPlanChangeSubService planChangeSubService;
    private IPlanChangeHisService planChangeHisService;
    private IMaterialMasterPlanService materialMasterPlanService;
    private IMaterialMasterPlanSubService materialMasterPlanSubService;
    private String userCode;
    private String userName;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public void setPlanChangeService(IPlanChangeService planChangeService) {
        this.planChangeService = planChangeService;
    }

    public void setPlanChangeSubService(IPlanChangeSubService planChangeSubService) {
        this.planChangeSubService = planChangeSubService;
    }

    public void setPlanChangeHisService(IPlanChangeHisService planChangeHisService) {
        this.planChangeHisService = planChangeHisService;
    }

    public void setMaterialMasterPlanService(IMaterialMasterPlanService materialMasterPlanService) {
        this.materialMasterPlanService = materialMasterPlanService;
    }

    public void setMaterialMasterPlanSubService(IMaterialMasterPlanSubService materialMasterPlanSubService) {
        this.materialMasterPlanSubService = materialMasterPlanSubService;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public void run() {
        try {
            this.doSomething();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            String infomsg = sw.toString();
            this.logger.error(infomsg);
        }
    }

    public void doSomething() {
        this.logger.info("\u7ebf\u7a0b\u5f00\u59cb----------------");
        PlanChangeEntity planChange = (PlanChangeEntity)((Object)this.planChangeService.getById(this.billId));
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"material_master_plan_id", (Object)planChange.getId());
        qw.eq((Object)"dr", (Object)0);
        planChange.setMaterialSubList(this.planChangeSubService.list((Wrapper)qw));
        MaterialMasterPlanEntity newPlanEntity = null;
        MaterialMasterPlanEntity oldPlan = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanService.getById(planChange.getSourcePlanId()));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"material_master_plan_id", (Object)oldPlan.getId());
        wrapper.eq((Object)"dr", (Object)0);
        oldPlan.setMaterialSubList(this.materialMasterPlanSubService.list((Wrapper)wrapper));
        if (this.state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            planChange.setCommitDate(new Date());
            planChange.setCommitUserCode(this.userCode);
            planChange.setCommitUserName(this.userName);
        }
        planChange.setEffectiveDate(new Date());
        PlanChangeHisEntity recordEntity = (PlanChangeHisEntity)((Object)BeanMapper.map((Object)((Object)oldPlan), PlanChangeHisEntity.class));
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u6b63\u5728\u56de\u8c03");
        recordEntity.setSourcePlanId(oldPlan.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getMaterialSubList())) {
            recordEntity.getMaterialSubList().stream().forEach(detail -> {
                detail.setTargetId(detail.getId());
                detail.setId(null);
            });
        }
        recordEntity.setCreateUserCode(planChange.getCreateUserCode());
        recordEntity.setCreateTime(planChange.getCreateTime());
        recordEntity.setCreateUserName(planChange.getCreateUserName());
        recordEntity.setModifyUserName(planChange.getModifyUserName());
        recordEntity.setUpdateTime(planChange.getUpdateTime());
        recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
        recordEntity.setCommitDate(planChange.getCommitDate());
        recordEntity.setCommitUserCode(planChange.getCommitUserCode());
        recordEntity.setCommitUserName(planChange.getCommitUserName());
        recordEntity.setEffectiveDate(planChange.getEffectiveDate());
        recordEntity.setOriginalPlanAmt(oldPlan.getTotalPlanAmt());
        recordEntity.setTotalPlanAmt(planChange.getTotalPlanAmt());
        recordEntity.setChangePlanId(oldPlan.getCurChangingPlanId());
        recordEntity.setChangeUserName(planChange.getChangeUserName());
        recordEntity.setChangeReason(planChange.getChangeReason());
        if (null == recordEntity.getTotalPlanAmt()) {
            recordEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if (null == recordEntity.getOriginalPlanAmt()) {
            recordEntity.setOriginalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        recordEntity.setChangeAmount(recordEntity.getTotalPlanAmt().subtract(recordEntity.getOriginalPlanAmt()));
        if (recordEntity.getOriginalPlanAmt().compareTo(BigDecimal.ZERO) == 0) {
            recordEntity.setChangeRatio(0.0);
        } else {
            recordEntity.setChangeRatio(recordEntity.getChangeAmount().divide(recordEntity.getOriginalPlanAmt(), 8, 4).multiply(new BigDecimal(100)).setScale(2, 4).doubleValue());
        }
        this.planChangeHisService.saveOrUpdate((Object)recordEntity, false);
        this.planChangeService.saveOrUpdate((Object)planChange, false);
        newPlanEntity = (MaterialMasterPlanEntity)((Object)BeanMapper.map((Object)((Object)planChange), MaterialMasterPlanEntity.class));
        newPlanEntity.setChangeState(MaterialMasterPlanVO.PLAN_CHANGE_STATE_CHANGED);
        newPlanEntity.setCurChangingPlanId(null);
        newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
        newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
        newPlanEntity.setCreateTime(oldPlan.getCreateTime());
        newPlanEntity.setId(oldPlan.getId());
        newPlanEntity.setVersion(oldPlan.getVersion());
        newPlanEntity.setChangeVersion(planChange.getChangeVersion());
        newPlanEntity.setBillState(oldPlan.getBillState());
        ArrayList<Long> delDetailIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(planChange.getMaterialSubList())) {
            ArrayList<MaterialMasterPlanSubEntity> list = new ArrayList<MaterialMasterPlanSubEntity>();
            MaterialMasterPlanSubEntity tmp = null;
            Map<Long, Integer> map = oldPlan.getMaterialSubList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
            for (PlanChangeSubEntity detail2 : planChange.getMaterialSubList()) {
                tmp = (MaterialMasterPlanSubEntity)((Object)BeanMapper.map((Object)((Object)detail2), MaterialMasterPlanSubEntity.class));
                if (null != detail2.getTargetId()) {
                    tmp.setId(detail2.getTargetId());
                    tmp.setVersion(map.get(detail2.getTargetId()));
                    if ("2".equals(detail2.getChangeType())) {
                        delDetailIds.add(detail2.getTargetId());
                        continue;
                    }
                    tmp.setRowState("update");
                    list.add(tmp);
                    continue;
                }
                tmp.setRowState("add");
                list.add(tmp);
            }
            newPlanEntity.setMaterialSubList(list);
        }
        if (CollectionUtils.isNotEmpty(delDetailIds)) {
            this.materialMasterPlanSubService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
        }
        if (this.materialMasterPlanService.saveOrUpdate((Object)newPlanEntity, false)) {
            this.logger.info("\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
        } else {
            this.logger.info("\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff01");
        }
    }
}

