package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.ProjectImplProtocolDetailEntity;
import com.ejianc.business.cost.bean.ProjectImplProtocolEntity;
import com.ejianc.business.cost.bean.ProjectTaskBookDetailEntity;
import com.ejianc.business.cost.bean.ProjectTaskBookEntity;
import com.ejianc.business.cost.service.IProjectImplProtocolService;
import com.ejianc.business.cost.service.IProjectTaskBookService;
import com.ejianc.business.cost.vo.ProjectTaskBookVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("projectImplProtocol") 
public class ProjectImplProtocolBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IProjectImplProtocolService projectImplProtocolService;
	@Autowired
	private IProjectTaskBookService projectTaskBookService;
	@Autowired
	private IBillCodeApi billCodeApi;
	private static final String BILL_CODE = "zydxProjectTaskBook";//
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ProjectImplProtocolEntity entity = projectImplProtocolService.selectById(billId);
		List<ProjectImplProtocolDetailEntity> detailList = entity.getProjectImplProtocolDetailList();

		ProjectTaskBookEntity en = BeanMapper.map(entity, ProjectTaskBookEntity.class);
		en.setBillCode(null);
		en.setId(IdWorker.getId());
		en.setBillState(0);
		en.setCreateTime(null);
		en.setCreateUserCode(null);
		en.setUpdateTime(null);
		en.setUpdateUserCode(null);
		en.setVersion(null);
		en.setPrjimplProtocolId(billId);
		BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),BeanMapper.map(en, ProjectTaskBookVO.class));
		CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
		if(billCode.isSuccess()) {
			en.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
		}else{
			throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
		}
		List<ProjectTaskBookDetailEntity> projectTaskBookDetailList = new ArrayList<>();
		BigDecimal prjtaskcostTotal = new BigDecimal(0);
		if(detailList!=null && detailList.size()>0){
			Map<String, Long> map = new HashMap<>();
			for(ProjectImplProtocolDetailEntity item : detailList){
				ProjectTaskBookDetailEntity e = BeanMapper.map(item, ProjectTaskBookDetailEntity.class);
				if(item.getPid()==null && item.getInnerAmount()!=null){
					prjtaskcostTotal = prjtaskcostTotal.add(item.getInnerAmount());
				}
				e.setPrjimplProtocolDetailId(item.getId());
				e.setId(IdWorker.getId());
				e.setCreateTime(null);
				e.setCreateUserCode(null);
				e.setUpdateTime(null);
				e.setUpdateUserCode(null);
				e.setVersion(null);
				e.setRowState("add");
				e.setId(IdWorker.getId());
				map.put(e.getCode(), e.getId());
				projectTaskBookDetailList.add(e);
			}
			en.setPrjtaskcostTotal(prjtaskcostTotal);
			projectTaskBookDetailList.forEach(item -> {
				if(item.getCode().indexOf(".")!=-1){
					String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
					item.setPid(map.get(code));
				}
			});
			en.setProjectTaskBookDetailList(projectTaskBookDetailList);
		}
		projectTaskBookService.saveOrUpdate(en, false);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		if(!resp.isSuccess()){
			return CommonResponse.error("操作失败！"+resp.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		QueryWrapper<ProjectTaskBookEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("prjimpl_protocol_id", billId);
		List<ProjectTaskBookEntity> list = projectTaskBookService.list(wrapper);
		if(list!=null && list.size()>0){
			for (ProjectTaskBookEntity en : list) {
				if(en.getBillState()!=0 && en.getBillState()!=4){
					//单据为非自由态单据，不允许撤回
					return CommonResponse.error("生成的项目任务书单据已提交，不支持撤回");
				}
			}
			projectTaskBookService.remove(wrapper);
		}
		return CommonResponse.success();
	}

}
