package com.ejianc.business.other.service;

import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.other.vo.ParamsCheckVO;
import com.ejianc.business.other.vo.SqlParam;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 其他支出合同实体
 * 
 * @author generator
 * 
 */
public interface IOtherContractService extends IBaseService<OtherContractEntity> {

    CommonResponse<OtherContractVO> saveOrUpdate(OtherContractVO saveorUpdateVO);

    OtherContractVO queryDetail(Long id);

    Map<String,Object> countContractAmount(QueryParam param);

    List<OtherProjectReportVo> getMonthOtherMny(Long projectId, Integer lastDay);

    OtherProjectReportVo getOtherContract(Long projectId);

    List<Map<String,Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryTaxWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryPayWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> querySettleWarnContract(List<SqlParam> sqlParamList);


    BigDecimal totalContractMny(OtherContractVO vo);

    BigDecimal fetchSjzcje(Long projectId);

    /**
     * @return {@link PicketageVO}
     *
     * @description: 根据定标单回写已签合同数量和金额
     * @author songlx
     * @date: 2023/11/8
     */
    PicketageVO countContractNumAndMnyByEnquiry(Long... enquiryPriceBillIds);
}
