package com.ejianc.business.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleDetailEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.bean.OtherSettleOtherEntity;

import com.ejianc.business.other.mapper.OtherSettleMapper;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleDetailService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.utils.ComputeUtil;
import com.ejianc.business.other.vo.OtherSettleDetailVO;
import com.ejianc.business.other.vo.OtherSettleOtherVO;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.business.other.vo.SettleHistoryVo;
import com.ejianc.business.utils.MathUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 结算
 *
 * @author generator
 */
@Service("otherSettleService")
public class OtherSettleServiceImpl extends BaseServiceImpl<OtherSettleMapper, OtherSettleEntity> implements IOtherSettleService {
    private static final String BILL_CODE = "OTHER_SETTLE_CODE";
    private static final String CHECK_PARAM_CODE = "P-NB2T3930";
    private static final String OTHER_SETTLE_BILL_CODE = "OTHER_SETTLE";
    private static final String OTHER_SETTLE_DETAIL_BILL_CODE = "OTHER_SETTLE_DETAIL";
    private static final String OTHER_SETTLE_OTHER_BILL_CODE = "OTHER_SETTLE_OTHER";

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOtherSettleDetailService otherSettleDetailService;

    @Autowired
    private IOrgApi iOrgApi;


    @Override
    public CommonResponse<OtherSettleVO> saveOrUpdate(OtherSettleVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherSettleEntity entity = null;
        String operateType = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            operateType = "edit";
            LambdaQueryWrapper<OtherSettleEntity> lambdaQuery = Wrappers.<OtherSettleEntity>lambdaQuery();
            lambdaQuery.eq(OtherSettleEntity::getTenantId, tenantId);
            lambdaQuery.ne(OtherSettleEntity::getId, saveorUpdateVO.getId());
            lambdaQuery.eq(OtherSettleEntity::getContractId, saveorUpdateVO.getContractId());
            lambdaQuery.ne(OtherSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdaQuery.ne(OtherSettleEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
            int num = super.count(lambdaQuery);
            if (num > 0) {
                throw new BusinessException("该合同已存在未生效的结算单!");
            }
        } else {
            operateType = "add";
            LambdaQueryWrapper<OtherSettleEntity> lambdaQuery = Wrappers.<OtherSettleEntity>lambdaQuery();
            lambdaQuery.eq(OtherSettleEntity::getTenantId, tenantId);
            lambdaQuery.eq(OtherSettleEntity::getContractId, saveorUpdateVO.getContractId());
            lambdaQuery.ne(OtherSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdaQuery.ne(OtherSettleEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
            int num = super.count(lambdaQuery);
            if (num > 0) {
                throw new BusinessException("该合同已存在未生效的结算单!");
            }
        }


        OtherContractEntity otherContractEntity = contractService.selectById(saveorUpdateVO.getContractId());
        if (otherContractEntity.getIsFinish() != null && otherContractEntity.getIsFinish() == 1) {
            throw new BusinessException("该合同已完工结算!");
        }
        if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                saveorUpdateVO.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveorUpdateVO, OtherSettleEntity.class);
            operateType = "edit";
        } else {
            //新增
            entity = BeanMapper.map(saveorUpdateVO, OtherSettleEntity.class);
            operateType = "add";
        }

        List<OtherSettleEntity> entities = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
            //修改 校验合同编号唯一
            LambdaQueryWrapper<OtherSettleEntity> lambda = Wrappers.<OtherSettleEntity>lambdaQuery();
            lambda.eq(OtherSettleEntity::getBillCode, saveorUpdateVO.getBillCode());
            lambda.eq(OtherSettleEntity::getTenantId, tenantId);
            lambda.ne(OtherSettleEntity::getId, saveorUpdateVO.getId());
            entities = super.list(lambda);
        } else {
            LambdaQueryWrapper<OtherSettleEntity> lambda = Wrappers.<OtherSettleEntity>lambdaQuery();
            lambda.eq(OtherSettleEntity::getBillCode, saveorUpdateVO.getBillCode());
            lambda.eq(OtherSettleEntity::getTenantId, tenantId);
            entities = super.list(lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setSumSettleAllMny(MathUtil.safeAdd(entity.getSettleTaxMny(), entity.getSumSettleTaxMny()));
        entity.setRelationFlag(getRelationFlag(saveorUpdateVO));

        super.saveOrUpdate(entity, false);

        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public OtherSettleVO queryDetail(Long id) {
        OtherSettleEntity entity = super.selectById(id);
        OtherSettleVO vo = BeanMapper.map(entity, OtherSettleVO.class);
        return vo;
    }

    @Override
    public SettleHistoryVo querySettleHistory(Long id) {
        OtherContractEntity contractEntity = contractService.selectById(id);

        SettleHistoryVo vo = new SettleHistoryVo();
        vo.setContractId(id);
        vo.setContractTaxMny(contractEntity.getContractTaxMny());
        vo.setSumSettleTaxMny(contractEntity.getSumSettleTaxMny());
        vo.setIsFinish(contractEntity.getIsFinish());
        vo.setContractStatus(contractEntity.getContractStatus());
//        BigDecimal safeDiv = MathUtil.safeDiv(contractEntity.getSumSettleTaxMny(), contractEntity.getContractTaxMny());
//        vo.setSumSettleRate(MathUtil.safeMultiply(safeDiv, new BigDecimal(100)));
        LambdaQueryWrapper<OtherSettleEntity> lambdaQuery = Wrappers.<OtherSettleEntity>lambdaQuery();
        lambdaQuery.eq(OtherSettleEntity::getContractId, id);
        Long orgId = InvocationInfoProxy.getOrgId();
        //集采查询组织本下审批通过、已提交的结算
        if(!"1".equals(contractEntity.getDependOnProject())) {

            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
            if(orgResp.isSuccess()) {
                List<Long> orgIds = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
                lambdaQuery.in(OtherSettleEntity::getOrgId, orgIds);
            }
        }
        else{
            lambdaQuery.eq(OtherSettleEntity::getOrgId, orgId);
        }
        lambdaQuery.orderByDesc(OtherSettleEntity::getCreateTime);
        List<OtherSettleEntity> listAllState = super.list(lambdaQuery);
        lambdaQuery.in(OtherSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<OtherSettleEntity> list = super.list(lambdaQuery);
        if (CollectionUtils.isNotEmpty(list)) {
            BigDecimal settleTaxMny = BigDecimal.ZERO;
            for (OtherSettleEntity otherSettleEntity : list) {
                settleTaxMny =  ComputeUtil.safeAdd(settleTaxMny,otherSettleEntity.getSettleTaxMny());
                BigDecimal ratio = ComputeUtil.safeDiv(otherSettleEntity.getSettleTaxMny(), contractEntity.getContractTaxMny());
                otherSettleEntity.setSumSettleRate(ComputeUtil.safeMultiply(ratio, new BigDecimal(100)));
            }
            BigDecimal safeDiv = MathUtil.safeDiv(settleTaxMny, contractEntity.getContractTaxMny());
            vo.setSumSettleRate(MathUtil.safeMultiply(safeDiv, new BigDecimal(100)));
            vo.setSumSettleTaxMny(settleTaxMny);
        }else {
            vo.setSumSettleRate(BigDecimal.ZERO);
            vo.setSumSettleTaxMny(BigDecimal.ZERO);
        }
        vo.setSettleRecord(BeanMapper.mapList(listAllState, OtherSettleVO.class));
        return vo;
    }



    @Override
    public CommonResponse<OtherSettleVO> pushToCost(OtherSettleVO otherSettleVO) {
        OtherSettleEntity entity = baseMapper.selectById(otherSettleVO.getId());

        if (ListUtil.isNotEmpty(otherSettleVO.getDetailVos())) {
            List<OtherSettleDetailEntity> purchaseSettleDetail = BeanMapper.mapList(otherSettleVO.getDetailVos(), OtherSettleDetailEntity.class);
            entity.setDetailVos(purchaseSettleDetail);
        }
        if (ListUtil.isNotEmpty(otherSettleVO.getOtherVos())) {
            List<OtherSettleOtherEntity> purchaseSettleFee = BeanMapper.mapList(otherSettleVO.getOtherVos(), OtherSettleOtherEntity.class);
            entity.setOtherVos(purchaseSettleFee);
        }
        String relationFlag = getRelationFlag(otherSettleVO);
        entity.setRelationFlag(relationFlag);
        super.saveOrUpdate(entity, false);
        Integer billState = entity.getBillState();
        if (relationFlag.equals("1")) {
            if (billState.equals(BillStateEnum.PASSED_STATE.getBillStateCode()) || billState.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
                processCost(entity);
            } else {
                delCost(entity.getId());
            }
        } else {
            delCost(entity.getId());
        }
        return CommonResponse.success(queryDetail(entity.getId()));
    }

    public String getRelationFlag(OtherSettleVO otherSettleVO) {
        List<OtherSettleDetailVO> detailVos = otherSettleVO.getDetailVos();
        List<OtherSettleOtherVO> otherVos = otherSettleVO.getOtherVos();
        String relationFlag = "1";
        for (OtherSettleDetailVO detailVO : detailVos) {
            if (detailVO.getSubjectId() == null || detailVO.getSubjectId() <= 0) {
                relationFlag = "0";
            }
        }
        for (OtherSettleOtherVO otherVO : otherVos) {
            if (otherVO.getOtherSubjectId() == null || otherVO.getOtherSubjectId() <= 0) {
                relationFlag = "0";
            }
        }
        return relationFlag;
    }

    // 只推送
    @Override
    public void processCost(OtherSettleEntity entity) {

    }

    // 只删除
    @Override
    public void delCost(Long id) {
    }

    @Override
    public List<OtherSettleDetailVO> settlementExcelDownload(OtherSettleVO vo) {
        List<OtherSettleDetailVO> list = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, vo.getContractId()));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        List<OtherSettleEntity> entityList = this.queryList(queryParam, false);
        for (OtherSettleEntity rentSettlementEntity : entityList) {
            queryParam = new QueryParam();
            queryParam.getParams().put("settleId", new Parameter(QueryParam.EQ, rentSettlementEntity.getId()));
            List<OtherSettleDetailEntity> detailEntityList = otherSettleDetailService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(detailEntityList)) {
                List<OtherSettleDetailVO> listTemp = BeanMapper.mapList(detailEntityList, OtherSettleDetailVO.class);
                for (int i = 0; i < listTemp.size(); i++) {
                    OtherSettleDetailVO otherSettleDetailVO = listTemp.get(i);
                    if ("1".equals(otherSettleDetailVO.getSourceType())) {
                        otherSettleDetailVO.setSourceTypeName("合同外");
                    } else if ("0".equals(otherSettleDetailVO.getSourceType())) {
                        otherSettleDetailVO.setSourceTypeName("合同内");
                    } else {
                        otherSettleDetailVO.setSourceTypeName(null);
                    }
                    otherSettleDetailVO.setSettlementCode(rentSettlementEntity.getBillCode());
                }
                list.addAll(listTemp);
            }
        }
        return list;
    }
    @Override
    public BigDecimal calculateTotalSettlement(QueryParam queryParam) {
        QueryWrapper<OtherSettleEntity> query = changeToQueryWrapper(queryParam);
        query.select("sum(settle_tax_mny) as totalSettleAmount");
        Map<String, Object> amount = super.getMap(query);

        return null != amount ? new BigDecimal(amount.get("totalSettleAmount").toString()) : BigDecimal.ZERO.setScale(8);
    }
}
