package com.ejianc.business.asset.controller;

import java.io.Serializable;


import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.bean.AssetOutDetailEntity;
import com.ejianc.business.asset.pub.ReceiveState;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.vo.AssetOutDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.asset.bean.AssetOutEntity;
import com.ejianc.business.asset.service.IAssetOutService;
import com.ejianc.business.asset.vo.AssetOutVO;

/**
 * 固定资产调出
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("assetOut")
public class AssetOutController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZY_ASSET_OUT";//此处需要根据实际修改

    @Autowired
    private IAssetOutService service;
    @Autowired
    private IAssetService assetService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AssetOutVO> saveOrUpdate(@RequestBody AssetOutVO saveOrUpdateVO) {
    	AssetOutEntity entity = BeanMapper.map(saveOrUpdateVO, AssetOutEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
    	    List<Long> assetIdList = new ArrayList<>();
            for (AssetOutDetailVO assetOutDetailVO : saveOrUpdateVO.getDetailList()) {
                if ("del".equals(assetOutDetailVO.getRowState())){
                    assetIdList.add(assetOutDetailVO.getAssetId());
                }
            }
            if (CollectionUtils.isNotEmpty(assetIdList) && assetIdList.size() > 0){
                assetService.update(new UpdateWrapper<AssetEntity>().in("id", entity.getDetailList().stream().map(AssetOutDetailEntity::getAssetId).collect(Collectors.toList())).set("out_occupy_flag", 0));
            }
        }
        assetService.update(new UpdateWrapper<AssetEntity>().in("id", entity.getDetailList().stream().map(AssetOutDetailEntity::getAssetId).collect(Collectors.toList())).set("out_occupy_flag", 1));
    	service.saveOrUpdate(entity, false);
    	AssetOutVO vo = BeanMapper.map(entity, AssetOutVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AssetOutVO> queryDetail(Long id) {
    	AssetOutEntity entity = service.selectById(id);
    	AssetOutVO vo = BeanMapper.map(entity, AssetOutVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AssetOutVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (AssetOutVO vo : vos) {
                AssetOutEntity assetOutEntity = service.selectById(vo.getId());
                assetService.update(new UpdateWrapper<AssetEntity>().in("id", assetOutEntity.getDetailList().stream().map(AssetOutDetailEntity::getAssetId).collect(Collectors.toList())).set("out_occupy_flag", 0));
            }
        }
        service.removeByIds(vos.stream().map(AssetOutVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AssetOutVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("inOrgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<AssetOutEntity> page = service.queryPage(param,false);
        IPage<AssetOutVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AssetOutVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("inOrgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AssetOutEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<AssetOutVO> voList = BeanMapper.mapList(list, AssetOutVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            if (null != e.getReceiveState()){
                switch (e.getReceiveState()){
                    case "1":
                        e.setReceiveStateName(ReceiveState.TO_RECEIVING.getDescription());
                        break;
                    case "2":
                        e.setReceiveStateName(ReceiveState.RECEIVED.getDescription());
                        break;
                    case "3":
                        e.setReceiveStateName(ReceiveState.REJECT.getDescription());
                        break;
                }
            }
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("AssetOut-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refAssetOutData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AssetOutVO>> refAssetOutData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AssetOutEntity> page = service.queryPage(param,false);
        IPage<AssetOutVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AssetOutVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
