package com.ejianc.business.cost.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.bean.EngdepartRespcostEntity;
import com.ejianc.business.cost.bean.PreBidCostCalcEntity;
import com.ejianc.business.cost.service.IEngdepartRespcostService;
import com.ejianc.business.cost.service.IPreBidCostCalcService;
import com.ejianc.business.cost.vo.EngdepartRespcostDetailVO;
import com.ejianc.business.cost.vo.EngdepartRespcostVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工程部责任成本
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("engdepartRespcost")
public class EngdepartRespcostController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "zydxEngdepartRespcost";//此处需要根据实际修改

    @Autowired
    private IEngdepartRespcostService service;
    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPreBidCostCalcService preBidCostCalcService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EngdepartRespcostVO> saveOrUpdate(@RequestBody EngdepartRespcostVO saveOrUpdateVO) {
    	EngdepartRespcostEntity entity = BeanMapper.map(saveOrUpdateVO, EngdepartRespcostEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        PreBidCostCalcEntity preBidCostCalcEntity = preBidCostCalcService.queryDataByProjectId(saveOrUpdateVO.getProjectId());
        if(preBidCostCalcEntity==null){
            throw new BusinessException("未获取到该项目标前测算数据，请先完成标前测算");
        }
        BigDecimal costTaxTotal = preBidCostCalcEntity.getCostTaxTotal()!=null ? preBidCostCalcEntity.getCostTaxTotal() : new BigDecimal(0);

        String projectProperty = "父项目";
        List<Long> pIds = new ArrayList<>();
        pIds.add(saveOrUpdateVO.getProjectId());
        CommonResponse<List<ProjectRegisterVO>> pvos = projectApi.queryProjectByIds(pIds);
        List<Long> projectIds = new ArrayList<>();
        if(pvos.isSuccess() && pvos.getData()!=null && pvos.getData().size()>0) {
            ProjectRegisterVO pvo = pvos.getData().get(0);
            if(pvo.getParentId()!=null){
                projectProperty = "子项目";
                //获取
                CommonResponse<List<ProjectRegisterVO>> listResponse = projectApi.queryProjectByPid(pvo.getParentId());
                if(listResponse.isSuccess() && listResponse.getData()!=null && listResponse.getData().size()>0){
                    for(ProjectRegisterVO vo : listResponse.getData()){
                        projectIds.add(vo.getId());
                    }
                }
            }else{
                projectIds.add(saveOrUpdateVO.getProjectId());
            }
        }
        /*
        if("子项目".equals(projectProperty)){
            //子项目累计工程部责任成本金额不得超标前测算
            if(projectIds!=null && projectIds.size()>0){
                QueryWrapper<EngdepartRespcostEntity> wrapper = new QueryWrapper<>();
                wrapper.in("project_id", projectIds);
                List<EngdepartRespcostEntity> lsit = service.list(wrapper);
                if(lsit!=null && lsit.size()>0){
                    BigDecimal all =  new BigDecimal(0);
                    for(EngdepartRespcostEntity vo : lsit){
                        if(!vo.getId().equals(saveOrUpdateVO.getProjectId())){
                            BigDecimal prebidCost = vo.getPrebidCost()!=null ? vo.getPrebidCost(): new BigDecimal(0);
                            all = all.add(prebidCost);
                        }else{
                            BigDecimal prebidCost = saveOrUpdateVO.getPrebidCost()!=null ? saveOrUpdateVO.getPrebidCost(): new BigDecimal(0);
                            all = all.add(prebidCost);
                        }
                    }
                    if(all.compareTo(costTaxTotal)>0){
                        throw new BusinessException("工程部责任成本：子项目累计责任成本总金额【"+all.setScale(2,BigDecimal.ROUND_HALF_UP)+"】不得超标前测算【"+costTaxTotal.setScale(2,BigDecimal.ROUND_HALF_UP)+"】");
                    }
                }
            }
        }else{
            BigDecimal prebidCost = saveOrUpdateVO.getPrebidCost()!=null ? saveOrUpdateVO.getPrebidCost(): new BigDecimal(0);
            if(prebidCost.compareTo(costTaxTotal)>0){
                throw new BusinessException("工程部责任成本：责任成本总金额【"+prebidCost.setScale(2,BigDecimal.ROUND_HALF_UP)+"】不得超标前测算【"+costTaxTotal.setScale(2,BigDecimal.ROUND_HALF_UP)+"】");
            }
        }
*/
        if(entity.getEngdepartRespcostDetailList()!=null && entity.getEngdepartRespcostDetailList().size()>0){
            Map<String, Long> map = new HashMap<>();
            entity.getEngdepartRespcostDetailList().forEach(item -> {
                if("add".equals(item.getRowState())){
                    item.setId(IdWorker.getId());
                    item.setRespcostId(entity.getId());
                }
                if(!"del".equals(item.getRowState())){
                    map.put(item.getCode(), item.getId());
                }
            });
            entity.getEngdepartRespcostDetailList().forEach(item -> {
                if("add".equals(item.getRowState()) && item.getCode().indexOf(".")!=-1){
                    String code = item.getCode().substring(0, item.getCode().lastIndexOf("."));
                    item.setPid(map.get(code));
                }
            });
        }
    	service.saveOrUpdate(entity, false);
    	EngdepartRespcostVO vo = BeanMapper.map(entity, EngdepartRespcostVO.class);

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getEngdepartRespcostDetailList())) {
            sortIntMethod(vo.getEngdepartRespcostDetailList());
            List<EngdepartRespcostDetailVO> detailVOS = createTreeData(vo.getEngdepartRespcostDetailList());
            vo.setEngdepartRespcostDetailList(detailVOS);
        }
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EngdepartRespcostVO> queryDetail(Long id) {
    	EngdepartRespcostEntity entity = service.selectById(id);
    	EngdepartRespcostVO vo = BeanMapper.map(entity, EngdepartRespcostVO.class);

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(vo.getEngdepartRespcostDetailList())) {
            sortIntMethod(vo.getEngdepartRespcostDetailList());
            List<EngdepartRespcostDetailVO> detailVOS = createTreeData(vo.getEngdepartRespcostDetailList());
            vo.setEngdepartRespcostDetailList(detailVOS);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/queryDetailByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EngdepartRespcostVO> queryDetailByProjectId(Long projectId) {
        EngdepartRespcostVO vo = service.queryDetailByProjectId(projectId);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EngdepartRespcostVO> vos) {
        service.removeByIds(vos.stream().map(EngdepartRespcostVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EngdepartRespcostVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<EngdepartRespcostEntity> page = service.queryPage(param,false);
        IPage<EngdepartRespcostVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), EngdepartRespcostVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */        List<EngdepartRespcostEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("EngdepartRespcost-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refEngdepartRespcostData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EngdepartRespcostVO>> refEngdepartRespcostData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pubUnitName");
        fuzzyFields.add("contractUnitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("excodeProjectTargetcost")!=null){
                param.getParams().put("excodeProjectTargetcost", new Parameter(QueryParam.SQL, " (id not in (select t.respcost_id from ejc_zypms_project_targetcost t where t.dr = 0 and t.respcost_id is not null))"));
            }
        }

        IPage<EngdepartRespcostEntity> page = service.queryPage(param,false);
        IPage<EngdepartRespcostVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EngdepartRespcostVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    private static void sortIntMethod(List<EngdepartRespcostDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                EngdepartRespcostDetailVO o1Detail = objectMapper.convertValue(o1, EngdepartRespcostDetailVO.class);
                EngdepartRespcostDetailVO o2Detail = objectMapper.convertValue(o2, EngdepartRespcostDetailVO.class);
                String[] strs1 = o1Detail.getCode().split("\\.");
                String[] strs2 = o2Detail.getCode().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }

    public static List<EngdepartRespcostDetailVO> createTreeData(List<EngdepartRespcostDetailVO> list) {
        List<EngdepartRespcostDetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, EngdepartRespcostDetailVO> listMap = new HashMap<>();
        for(EngdepartRespcostDetailVO item:list) {
            listMap.put(item.getId().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            EngdepartRespcostDetailVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            EngdepartRespcostDetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<EngdepartRespcostDetailVO> child = (List<EngdepartRespcostDetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<EngdepartRespcostDetailVO> children = new ArrayList<EngdepartRespcostDetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    @RequestMapping(value = "/checkBillParam", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONArray> checkBillParam(@RequestBody EngdepartRespcostVO vo) {
        JSONArray list = new JSONArray();
        /*
        PrjcontractCostsEntity costsEntity = costsService.selectById(vo.getPrjcontractCostsId());
        //工程部责任成本总金额＞项目合同造价表“项目成本”+“工程部销售费用
        BigDecimal prebidCost = vo.getPrebidCost()!=null?vo.getPrebidCost():new BigDecimal(0);//工程部责任成本总金额
        BigDecimal prjcostTotal = costsEntity.getPrjcostTotal()!=null?costsEntity.getPrjcostTotal():new BigDecimal(0);//项目合同造价表“项目成本”
        BigDecimal prjsaleCost = costsEntity.getPrjsaleCost()!=null?costsEntity.getPrjsaleCost():new BigDecimal(0);//项目合同造价表“工程部销售费用”

        if(prebidCost.compareTo(prjcostTotal.add(prjsaleCost))>0){
            JSONObject item = new JSONObject();
            item.put("type", "1");
            item.put("warnItem", "1");
            item.put("warnName", "项目合同造价表控工程部责任成本");
            item.put("content", "工程部责任成本项目成本"+(vo.getRespcostTotal()!=null?vo.getRespcostTotal().setScale(2):0)
                    +"元，工程部销售费用"+(vo.getPrjsaleCost()!=null?vo.getPrjsaleCost().setScale(2):0)+"元，大于项目合同造价表项目成本"
                    +prjcostTotal.setScale(2)+"元，工程部销售费用"+prjsaleCost.setScale(2)+"元");
            list.add(item);
        }
        //子项目工程部责任成本＞工程部责任成本
        //判断项目合同造价表中的项目是执行项目还是父项目，若是执行项目，不需要统计子项目合计的规则预警，否则需要计算子项目的合计预警
        List<Long> projectIds = new ArrayList<>();
        projectIds.add(costsEntity.getProjectId());
        CommonResponse<List<ProjectRegisterVO>> pvos = projectApi.queryProjectByIds(projectIds);
        if(pvos.isSuccess() && pvos.getData()!=null && pvos.getData().size()>0){
            ProjectRegisterVO pvo = pvos.getData().get(0);
            if(pvo.getHasChild()!=null && pvo.getHasChild()){
                //是父项目
                //获取除本节点的所有工程部责任成本金额的累计和
                QueryWrapper<EngdepartRespcostEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("prjcontract_costs_id", vo.getPrjcontractCostsId());
                if(vo.getId() == null || vo.getId() == 0) {
                    wrapper.ne("id", vo.getId());
                }
                List<EngdepartRespcostEntity> datas = service.list(wrapper);
                if(datas!=null && datas.size()>0){
                    BigDecimal allPrebidCost = prebidCost;
                    for(EngdepartRespcostEntity en : datas){
                        allPrebidCost = allPrebidCost.add(en.getPrebidCost());
                    }
                    if(allPrebidCost.compareTo(prjcostTotal.add(prjsaleCost))>0){
                        JSONObject item = new JSONObject();
                        item.put("type", "2");
                        item.put("warnItem", (list.size()+1)+"");
                        item.put("warnName", "项目合同造价表控子项目工程部责任成本");
                        item.put("content", "子项目工程部责任成本金额累计值"+allPrebidCost.setScale(2)+"元，大于项目合同造价表项目成本"+prjcostTotal.setScale(2)+"元，工程部销售费用"+prjsaleCost.setScale(2)+"元");
                        list.add(item);
                    }
                }
            }
        }
*/
        return CommonResponse.success(list);
    }

    @RequestMapping(value = "/queryDataByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryDataByProjectId(Long projectId) {
        JSONObject data = service.queryDataByProjectId(projectId);
        return CommonResponse.success(data);
    }
}
