package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionClaimEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionClaimService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

@Service("production")
public class ProductionBpmService implements ICommonBusinessService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IProductionClaimService productionClaimService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //回写主表
        ProductionEntity productionEntity = productionService.selectById(billId);
        ContractEntity contractEntity = contractService.selectById(productionEntity.getContractId());
        QueryWrapper<ProductionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("IFNULL(sum(finish_tax_mny),0) as sumFinishTaxMny, IFNULL(sum(finish_mny),0) as sumFinishMny")
                .eq("contract_id", productionEntity.getContractId())
                .in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()))
                .ne("id", billId);
        Map<String, Object> map = productionService.getMap(queryWrapper);
        //累计产值报量
        BigDecimal sumFinishTaxMny = ComputeUtil.toBigDecimal(map.get("sumFinishTaxMny"));
        //累计产值报量（无税）
        BigDecimal sumFinishMny = ComputeUtil.toBigDecimal(map.get("sumFinishMny"));
        contractEntity.setSumProductionTaxMny(ComputeUtil.safeAdd(sumFinishTaxMny, productionEntity.getFinishTaxMny()));
        contractEntity.setSumProductionMny(ComputeUtil.safeAdd(sumFinishMny, productionEntity.getFinishMny()));
        contractService.updateById(contractEntity);

        //回写签证洽商索赔
        QueryParam parm = new QueryParam();
        parm.getParams().put("productionId", new Parameter(QueryParam.EQ, productionEntity.getId()));
        List<ProductionClaimEntity> claimList = productionClaimService.queryList(parm, false);

        if (null != claimList && claimList.size() > 0) {
            List<Long> ids = new ArrayList<>();
            Map<Long, BigDecimal> idMap = new HashMap<>();
            for (ProductionClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
            }

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<ClaimEntity> claimEntities = claimService.queryList(queryParam, false);
            for (ClaimEntity ce : claimEntities) {
                ce.setSumProductionMny((ce.getSumProductionMny() == null ? BigDecimal.ZERO : ce.getSumProductionMny())
                        .add(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : idMap.get(ce.getId())));
            }
            claimService.updateBatchById(claimEntities);
        }
        return CommonResponse.success();
    }

    // 审批通过回退
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

        ProductionEntity productionEntity = productionService.selectById(billId);
        if(productionEntity == null){
            return CommonResponse.error("该产值进度单不存在！");
        }
        LambdaQueryWrapper<ProductionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ProductionEntity::getContractId, productionEntity.getContractId());
        queryWrapper.gt(ProductionEntity::getCreateTime, productionEntity.getCreateTime());
        List<ProductionEntity> productionEntities = productionService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(productionEntities)) {
            return CommonResponse.error("该产值进度单存在同一合同下编号为【" + productionEntities.get(0).getBillCode() + "】的后续单据，无法撤回！");
        }

        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            callBackProduction(billId,state,billTypeCode);
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }
    // 撤回回写
    private void callBackProduction(Long billId, Integer state, String billTypeCode){

        //回写主表
        ProductionEntity productionEntity = productionService.selectById(billId);
        ContractEntity contractEntity = contractService.selectById(productionEntity.getContractId());

        QueryWrapper<ProductionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("IFNULL(sum(finish_tax_mny),0) as sumFinishTaxMny, IFNULL(sum(finish_mny),0) as sumFinishMny")
                .eq("contract_id", productionEntity.getContractId())
                .in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()))
                .ne("id", billId);
        Map<String, Object> map = productionService.getMap(queryWrapper);
        //累计产值报量
        BigDecimal sumFinishTaxMny = ComputeUtil.toBigDecimal(map.get("sumFinishTaxMny"));
        //累计产值报量（无税）
        BigDecimal sumFinishMny = ComputeUtil.toBigDecimal(map.get("sumFinishMny"));
        contractEntity.setSumProductionTaxMny(sumFinishTaxMny);
        contractEntity.setSumProductionMny(sumFinishMny);
        contractService.updateById(contractEntity);

        //回写签证洽商索赔
        QueryParam parm = new QueryParam();
        parm.getParams().put("productionId", new Parameter(QueryParam.EQ, productionEntity.getId()));
        List<ProductionClaimEntity> claimList = productionClaimService.queryList(parm, false);

        if (null != claimList && claimList.size() > 0) {
            List<Long> ids = new ArrayList<>();
            Map<Long, BigDecimal> idMap = new HashMap<>();
            for (ProductionClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
            }

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<ClaimEntity> claimEntities = claimService.queryList(queryParam, false);
            for (ClaimEntity ce : claimEntities) {
                ce.setSumProductionMny((ce.getSumProductionMny() == null ? BigDecimal.ZERO : ce.getSumProductionMny())
                        .subtract(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : idMap.get(ce.getId())));
            }
            claimService.updateBatchById(claimEntities);
        }
    }

}
