package com.ejianc.business.labprice.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.othprice.bean.PicketageSupplierEntity;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 定标自制-清单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_labprice_labor_picketage_detail")
public class LaborPicketageDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="picketage_id")
    private Long picketageId; // 定标单id
    @TableField(value="detail_code")
    private String detailCode; // 编码
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="detail_name")
    private String detailName; // 物资名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="refer_price")
    private BigDecimal referPrice; // 参考价
    @TableField(value="num")
    private BigDecimal num; // 数量
    @TableField(value="mny")
    private BigDecimal mny; // 金额
    @TableField(value="quote_area")
    private String quoteArea; // 报价区间
    @TableField(value="source_id")
    private Long sourceId; // 来源id
    @TableField(value="source_type")
    private Integer sourceType; // 物资来源类型：1-物料档案，2-用料申请,3-新增
    @TableField(value="tmp_price")
    private BigDecimal tmpPrice; // 

    @TableField(exist=false)
    @SubEntity(serviceName="laborPicketageSupplierService",pidName = "picketageDetailId")//此处有pid="xxx"，默认值pid="pid"
    private List<LaborPicketageSupplierEntity> laborPicketageSupplierList = new ArrayList<>(); // 材料定标-供应商

    public List<LaborPicketageSupplierEntity> getLaborPicketageSupplierList() {
        return laborPicketageSupplierList;
    }

    public void setLaborPicketageSupplierList(List<LaborPicketageSupplierEntity> laborPicketageSupplierList) {
        this.laborPicketageSupplierList = laborPicketageSupplierList;
    }

    public Long getPicketageId() {
        return picketageId;
    }

    public void setPicketageId(Long picketageId) {
        this.picketageId = picketageId;
    }
    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getReferPrice() {
        return referPrice;
    }

    public void setReferPrice(BigDecimal referPrice) {
        this.referPrice = referPrice;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public String getQuoteArea() {
        return quoteArea;
    }

    public void setQuoteArea(String quoteArea) {
        this.quoteArea = quoteArea;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public BigDecimal getTmpPrice() {
        return tmpPrice;
    }

    public void setTmpPrice(BigDecimal tmpPrice) {
        this.tmpPrice = tmpPrice;
    }
    
}
