package com.ejianc.business.labprice.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.labprice.vo.LaborPicketageDetailVO;
import com.ejianc.business.labprice.vo.LaborPicketageQuoteVO;
import com.ejianc.business.labprice.vo.LaborPicketageQuoteDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 定标
 * 
 * @author generator
 * 
 */
public class LaborPicketageVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 询比价单号
    private Long inquiryId; // 询价id
    private String name; // 采购主题
    private Integer purchaseType; // 采购方式 1、项目自采；2、公司集采；
    private Long projectId; // 项目名称参照
    private String projectName; // 项目名称
    private String orgName; // 所属组织名称
    private Long orgId; // 所属组织参照
    private Integer pricingType; // 计价方式 1：采购 2:租赁


    private Integer quotationAuthority; // 报价权限 1、候选供应商；2、所有供应商；
    private BigDecimal inquiryMny; // 询价金额
    private String bidWinnerId; // 中标单位id
    private String bidWinnerName; // 中标单位名称
    private BigDecimal bidWinMny; // 中标金额
    private BigDecimal bidWinMnyNoTax; // 中标金额(无税)
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date handleDate; // 办理日期
    private String memo; // 备注
    private Integer selfFlag; // 是否自制 1:是 0:否
    private Integer contractSign; // 合同签订
    private BigDecimal contractSignMny; // 已签合同金额
    private String bidWinMnyStr; // 中标金额(多个供应商使用这个)
    
    private List<LaborPicketageDetailVO> detailList = new ArrayList<>(); // 定标自制-清单
    private List<LaborPicketageQuoteVO> quoteList = new ArrayList<>(); //  定标参照-报价记录
    private List<LaborPicketageQuoteDetailVO> quoteDetailList = new ArrayList<>(); // 定标参照-报价记录-清单

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "laborInquiry")
    public Long getInquiryId() {
        return inquiryId;
    }
    @ReferDeserialTransfer
    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目名称参照
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织参照
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Integer getPricingType() {
        return pricingType;
    }

    public void setPricingType(Integer pricingType) {
        this.pricingType = pricingType;
    }
    public Integer getQuotationAuthority() {
        return quotationAuthority;
    }

    public void setQuotationAuthority(Integer quotationAuthority) {
        this.quotationAuthority = quotationAuthority;
    }
    public BigDecimal getInquiryMny() {
        return inquiryMny;
    }

    public void setInquiryMny(BigDecimal inquiryMny) {
        this.inquiryMny = inquiryMny;
    }
    public String getBidWinnerId() {
        return bidWinnerId;
    }

    public void setBidWinnerId(String bidWinnerId) {
        this.bidWinnerId = bidWinnerId;
    }
    public String getBidWinnerName() {
        return bidWinnerName;
    }

    public void setBidWinnerName(String bidWinnerName) {
        this.bidWinnerName = bidWinnerName;
    }
    public BigDecimal getBidWinMny() {
        return bidWinMny;
    }

    public void setBidWinMny(BigDecimal bidWinMny) {
        this.bidWinMny = bidWinMny;
    }
    public BigDecimal getBidWinMnyNoTax() {
        return bidWinMnyNoTax;
    }

    public void setBidWinMnyNoTax(BigDecimal bidWinMnyNoTax) {
        this.bidWinMnyNoTax = bidWinMnyNoTax;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSelfFlag() {
        return selfFlag;
    }

    public void setSelfFlag(Integer selfFlag) {
        this.selfFlag = selfFlag;
    }
    public Integer getContractSign() {
        return contractSign;
    }

    public void setContractSign(Integer contractSign) {
        this.contractSign = contractSign;
    }
    public BigDecimal getContractSignMny() {
        return contractSignMny;
    }

    public void setContractSignMny(BigDecimal contractSignMny) {
        this.contractSignMny = contractSignMny;
    }
    public String getBidWinMnyStr() {
        return bidWinMnyStr;
    }

    public void setBidWinMnyStr(String bidWinMnyStr) {
        this.bidWinMnyStr = bidWinMnyStr;
    }


    public List<LaborPicketageDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<LaborPicketageDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<LaborPicketageQuoteVO> getQuoteList() {
        return quoteList;
    }

    public void setQuoteList(List<LaborPicketageQuoteVO> quoteList) {
        this.quoteList = quoteList;
    }

    public List<LaborPicketageQuoteDetailVO> getQuoteDetailList() {
        return quoteDetailList;
    }

    public void setQuoteDetailList(List<LaborPicketageQuoteDetailVO> quoteDetailList) {
        this.quoteDetailList = quoteDetailList;
    }
}
