package com.ejianc.business.bidprice.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 材料询价-采购清单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zypms_bidprice_material_inquiry_purchase_detail")
public class MaterialInquiryPurchaseDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="inquiry_id")
    private Long inquiryId; // 询价id
    @TableField(value="material_category_id")
    private Long materialCategoryId; // 物资分类Id
    @TableField(value="material_category_name")
    private String materialCategoryName; // 物资分类名称
    @TableField(value="material_id")
    private Long materialId; // 物资Id
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="num")
    private BigDecimal num; // 数量
    @TableField(value="refer_price")
    private BigDecimal referPrice; // 参考价
    @TableField(value="mny")
    private BigDecimal mny; // 金额
    @TableField(value="memo")
    private String memo; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="plan_use_date")
    private Date planUseDate; // 计划使用日期
    @TableField(value="source_id")
    private String sourceId; // 来源id
    @TableField(value="source_type")
    private String sourceType; // 物资来源类型：1-物料档案，2-用料申请,3-新增

    @TableField(value="fixed_material")
    private String fixedMaterial;//是否固定资产1是0否

    public String getFixedMaterial() {
        return fixedMaterial;
    }

    public void setFixedMaterial(String fixedMaterial) {
        this.fixedMaterial = fixedMaterial;
    }

    public Long getInquiryId() {
        return inquiryId;
    }

    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getReferPrice() {
        return referPrice;
    }

    public void setReferPrice(BigDecimal referPrice) {
        this.referPrice = referPrice;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getPlanUseDate() {
        return planUseDate;
    }

    public void setPlanUseDate(Date planUseDate) {
        this.planUseDate = planUseDate;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
}
