package com.ejianc.business.material.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.IInstallDetailService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.vo.PurchaseSettlementVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.material.service.IInstallService;
import com.ejianc.business.material.vo.InstallVO;

/**
 * 安装验收
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("install")
public class InstallController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZYDX_AZYS";//此处需要根据实际修改

    @Autowired
    private IInstallService service;
    @Autowired
    private IInstallDetailService detailService;
    @Autowired
    private IOutStoreService outStoreService;
    @Autowired
    private IOutStoreSubService outStoreSubService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InstallVO> saveOrUpdate(@RequestBody InstallVO saveOrUpdateVO) {
    	InstallEntity entity = BeanMapper.map(saveOrUpdateVO, InstallEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<InstallDetailEntity> detailList = entity.getInstallDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Set<Long> useIdSubs = new HashSet<>();
            Set<Long> freeSubIds = new HashSet<>();
            Set<Long> useIds = new HashSet<>();
            Set<Long> freeIds = new HashSet<>();
            Map<Long, Set<Long>> sourceSubMap = new HashMap<>();
            for (InstallDetailEntity detail : detailList) {
                Long sourceId = detail.getSourceMainId();
                Long sourceSubId = detail.getSourceSubId();
                if ("del".equals(detail.getRowState())) {
                    freeIds.add(sourceId);
                    freeSubIds.add(sourceSubId);
                } else {
                    useIdSubs.add(sourceSubId);
                    useIds.add(sourceId);
                    if (CollectionUtils.isNotEmpty(sourceSubMap.get(sourceId))) {
                        Set<Long> sourceSubIds = sourceSubMap.get(sourceId);
                        sourceSubIds.add(sourceSubId);
                        sourceSubMap.put(sourceId, sourceSubIds);
                    } else {
                        Set<Long> sourceSubIdSet = new HashSet();
                        sourceSubIdSet.add(sourceSubId);
                        sourceSubMap.put(sourceId, sourceSubIdSet);
                    }
                }
            }
            freeIds.removeAll(useIds);
            freeSubIds.removeAll(useIdSubs);
            if (CollectionUtils.isNotEmpty(useIds)) {
                StringBuffer msg = new StringBuffer("");
                useIds.forEach(s -> {
                    OutStoreEntity outStoreEntity = outStoreService.selectById(s);
                    if (outStoreEntity != null) {
                        List<OutStoreSubEntity> outStoreSubEntities = outStoreEntity.getOutStoreSubEntities();
                        List<OutStoreSubEntity> collect2 = outStoreSubEntities.stream().filter(e -> null == e.getInstallFlag() || 0 == e.getInstallFlag()).collect(Collectors.toList());
                        //如果未被引用的和该单据被引用的相等则全部
                        if (sourceSubMap.get(s).size() == collect2.size()) {
                            LambdaUpdateWrapper<OutStoreEntity> uw = new LambdaUpdateWrapper<>();
                            uw.eq(OutStoreEntity::getId, s);
                            uw.set(OutStoreEntity::getInstallFlag, 1);
                            outStoreService.update(uw);
                        }
                        LambdaUpdateWrapper<OutStoreSubEntity> uw = new LambdaUpdateWrapper<>();
                        uw.in(OutStoreSubEntity::getId, sourceSubMap.get(s));
                        uw.set(OutStoreSubEntity::getInstallFlag, 1);
                        outStoreSubService.update(uw);
                    } else {
                        msg.append("1");
                    }
                });
                if (msg.length() > 0) {
                    return CommonResponse.error("没有找到出库单信息！");
                }
            }
            if (CollectionUtils.isNotEmpty(freeIds)) {
                LambdaUpdateWrapper<OutStoreEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.in(OutStoreEntity::getId, freeIds);
                updateWrapper.set(OutStoreEntity::getInstallFlag, 0);
                outStoreService.update(updateWrapper);

                LambdaUpdateWrapper<OutStoreSubEntity> updateWrapperMain = new LambdaUpdateWrapper<>();
                updateWrapperMain.in(OutStoreSubEntity::getId, freeSubIds);
                updateWrapperMain.set(OutStoreSubEntity::getInstallFlag, 0);
                outStoreSubService.update(updateWrapperMain);
            }
        }
    	service.saveOrUpdate(entity, false);
    	InstallVO vo = BeanMapper.map(entity, InstallVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InstallVO> queryDetail(Long id) {
    	InstallEntity entity = service.selectById(id);
    	InstallVO vo = BeanMapper.map(entity, InstallVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InstallVO> vos) {
        List<Long> ids = vos.stream().map(InstallVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            LambdaQueryWrapper<InstallDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(InstallDetailEntity::getPid, ids);
            queryWrapper.eq(InstallDetailEntity::getDr, 0);
            List<InstallDetailEntity> detailList = detailService.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(detailList)) {
                Set<Long> freeIds = new HashSet<>();
                Set<Long> freeSubIds = new HashSet<>();
                for (InstallDetailEntity detail : detailList) {
                    Long sourceMainId = detail.getSourceMainId();
                    Long sourceSubId = detail.getSourceSubId();
                    freeIds.add(sourceMainId);
                    freeSubIds.add(sourceSubId);
                }
                if (CollectionUtils.isNotEmpty(freeIds)) {
                    LambdaUpdateWrapper<OutStoreEntity> uw = new LambdaUpdateWrapper<>();
                    uw.in(OutStoreEntity::getId, freeIds);
                    uw.set(OutStoreEntity::getInstallFlag, 0);
                    outStoreService.update(uw);
                    LambdaUpdateWrapper<OutStoreSubEntity> uwSub = new LambdaUpdateWrapper<>();
                    uwSub.in(OutStoreSubEntity::getId, freeSubIds);
                    uwSub.set(OutStoreSubEntity::getInstallFlag, 0);
                    outStoreSubService.update(uwSub);

                }
            }
            service.removeByIds(ids, true);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InstallVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName","pubUnitName","contractorUnitName","outStoreName","employeeName","",""));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        IPage<InstallEntity> page = service.queryPage(param,false);
        IPage<InstallVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InstallVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName","pubUnitName","contractorUnitName","outStoreName","employeeName","",""));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InstallEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Install-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refInstallData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InstallVO>> refInstallData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InstallEntity> page = service.queryPage(param,false);
        IPage<InstallVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InstallVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
